/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public class CommonUtils {
    private static final Pattern FOOTER_PATTERN = Pattern.compile("(?:\n(?:[A-Za-z0-9-]+:[^\n]*))+\\s*$");
    private static final int TABLE_INSET = 5;
    public static final Comparator<String> STRING_ASCENDING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() == 0 || o2.length() == 0) {
                return o1.length() - o2.length();
            }
            LinkedList<String> o1Parts = this.splitIntoDigitAndNonDigitParts(o1);
            LinkedList<String> o2Parts = this.splitIntoDigitAndNonDigitParts(o2);
            Iterator o2PartsIterator = o2Parts.iterator();
            for (String o1Part : o1Parts) {
                int result;
                if (!o2PartsIterator.hasNext()) {
                    return 1;
                }
                String o2Part = (String)o2PartsIterator.next();
                if (Character.isDigit(o1Part.charAt(0)) && Character.isDigit(o2Part.charAt(0))) {
                    o1Part = this.stripLeadingZeros(o1Part);
                    o2Part = this.stripLeadingZeros(o2Part);
                    result = o1Part.length() - o2Part.length();
                    if (result == 0) {
                        result = o1Part.compareToIgnoreCase(o2Part);
                    }
                } else {
                    result = o1Part.compareToIgnoreCase(o2Part);
                }
                if (result == 0) continue;
                return result;
            }
            if (o2PartsIterator.hasNext()) {
                return -1;
            }
            return o1.compareTo(o2);
        }

        private LinkedList<String> splitIntoDigitAndNonDigitParts(String input) {
            LinkedList<String> parts = new LinkedList<String>();
            int partStart = 0;
            boolean previousWasDigit = Character.isDigit(input.charAt(0));
            int i = 1;
            while (i < input.length()) {
                boolean isDigit = Character.isDigit(input.charAt(i));
                if (isDigit != previousWasDigit) {
                    parts.add(input.substring(partStart, i));
                    partStart = i;
                    previousWasDigit = isDigit;
                }
                ++i;
            }
            parts.add(input.substring(partStart));
            return parts;
        }

        private String stripLeadingZeros(String input) {
            int i = 0;
            while (i < input.length()) {
                if (input.charAt(i) != '0') {
                    return input.substring(i);
                }
                ++i;
            }
            return "";
        }
    };
    public static final Comparator<Ref> REF_ASCENDING_COMPARATOR = Comparator.comparing(Ref::getName, STRING_ASCENDING_COMPARATOR);
    public static final Comparator<IResource> RESOURCE_NAME_COMPARATOR = (a, b) -> Policy.getComparator().compare(a.getName(), b.getName());
    public static final Comparator<Path> PATH_STRING_COMPARATOR = Comparator.comparing(p -> p.toAbsolutePath().toString(), STRING_ASCENDING_COMPARATOR);

    private CommonUtils() {
    }

    public static boolean runCommand(String commandId, IStructuredSelection selection) {
        ICommandService commandService = CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), ICommandService.class);
        Command cmd = commandService.getCommand(commandId);
        if (!cmd.isDefined()) {
            return false;
        }
        IHandlerService handlerService = CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), IHandlerService.class);
        EvaluationContext c = null;
        if (selection != null) {
            c = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection.toList());
            c.addVariable("selection", (Object)selection);
            c.removeVariable("activeMenuSelection");
        }
        try {
            if (c != null) {
                handlerService.executeCommandInContext(new ParameterizedCommand(cmd, null), null, (IEvaluationContext)c);
            } else {
                handlerService.executeCommand(commandId, null);
            }
            return true;
        }
        catch (CommandException commandException) {
            return false;
        }
    }

    public static <T> T getService(IServiceLocator locator, Class<T> api) {
        Object service = locator.getService(api);
        return (T)service;
    }

    public static int getFooterOffset(String commitMessage) {
        if (commitMessage == null) {
            return -1;
        }
        Matcher matcher = FOOTER_PATTERN.matcher(commitMessage);
        if (matcher.find()) {
            int start = matcher.start();
            int i = start - 1;
            while (i >= 0) {
                char ch;
                if ((ch = commitMessage.charAt(i--)) == '\n') {
                    return start + 1;
                }
                if (Character.isWhitespace(ch)) continue;
                return -1;
            }
            return start + 1;
        }
        return -1;
    }

    public static String getResourceNames(Iterable<IResource> resources) {
        LinkedList<String> names = new LinkedList<String>();
        for (IResource resource : resources) {
            if (resource.getName() == null) continue;
            names.add(resource.getName());
        }
        return StringUtils.join(names, (String)", ", (String)" & ");
    }

    public static int getCommitIdColumnWidth(Control control, String columnHeading) {
        GC gc = new GC((Drawable)control.getDisplay());
        try {
            gc.setFont(control.getFont());
            int n = Math.max(gc.stringExtent((String)"bbbbbbb").x, gc.stringExtent((String)columnHeading).x) + 10;
            return n;
        }
        finally {
            gc.dispose();
        }
    }
}

