/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.endo.IEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IGraphIterator;
import org.eclipse.emf.diffmerge.structures.endo.IIterableEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IRecursivelyDefinedEndorelation;

public abstract class AbstractEndorelationIterator<T>
implements IGraphIterator<T> {
    protected final IRecursivelyDefinedEndorelation<T> _endorelation;
    protected final boolean _ensureUniqueness;
    protected final Set<T> _returnedElementsAndNext;
    private long _lastDepth;
    protected long _nextDepth;
    private long _maxDepth;
    protected boolean _prune;
    protected final Collection<T> _maximalElements;
    protected final Collection<T> _recurrentElements;
    protected T _next;

    public AbstractEndorelationIterator(IRecursivelyDefinedEndorelation<T> endorelation_p) {
        this._endorelation = endorelation_p;
        this._ensureUniqueness = this.mustEnsureUniqueness(endorelation_p);
        this._maximalElements = new FHashSet<T>(this._endorelation.getEqualityTester());
        this._recurrentElements = new FHashSet<T>(this._endorelation.getEqualityTester());
        this._returnedElementsAndNext = new FHashSet<T>(endorelation_p.getEqualityTester());
        this._next = null;
        this._prune = false;
        this._lastDepth = -1L;
        this._nextDepth = -1L;
        this._maxDepth = -1L;
    }

    protected Iterator<T> emptyIterator() {
        return Collections.emptySet().iterator();
    }

    protected T getNextThrough(Iterator<T> iterator_p) {
        T result = null;
        while (result == null && iterator_p.hasNext()) {
            T next = iterator_p.next();
            if (!this._ensureUniqueness) {
                result = next;
                continue;
            }
            boolean added = this._returnedElementsAndNext.add(next);
            if (added) {
                result = next;
                continue;
            }
            if (!this.trackRecurrentElements()) continue;
            this._recurrentElements.add(next);
        }
        return result;
    }

    public Collection<T> getRecurrentElements() {
        return Collections.unmodifiableCollection(this._recurrentElements);
    }

    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public long lastDepth() {
        return this._lastDepth;
    }

    @Override
    public long maxDepth() {
        return this._maxDepth;
    }

    @Override
    public Collection<T> maximalElements() {
        return Collections.unmodifiableCollection(this._maximalElements);
    }

    protected boolean mustEnsureUniqueness(IEndorelation<?> endorelation_p) {
        IEndorelation.WithProperties pEndorelation;
        boolean injective;
        boolean result = true;
        if (endorelation_p instanceof IEndorelation.WithProperties && (injective = (pEndorelation = (IEndorelation.WithProperties)endorelation_p).isInjective().is(Boolean.TRUE))) {
            boolean noCycles = pEndorelation.isWithoutCycles().is(Boolean.TRUE);
            result = !noCycles;
        }
        return result;
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this._next;
        this._next = null;
        this.updateCurrentDepth();
        this.update();
        if (!this.hasNext() && this._endorelation instanceof IIterableEndorelation.Internal) {
            ((IIterableEndorelation.Internal)((Object)this._endorelation)).notifyExplored(this);
        }
        return result;
    }

    @Override
    public long nextDepth() {
        return this._nextDepth;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@');
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append('[');
        builder.append("Next(");
        builder.append(this._next);
        builder.append("), CurrentDepth(");
        builder.append(this.lastDepth());
        builder.append("), NextDepth(");
        builder.append(this.nextDepth());
        builder.append("), NextPath(");
        boolean first = true;
        try {
            for (Object val : this.nextPath()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(val);
            }
        }
        catch (UnsupportedOperationException e) {
            builder.append('?');
        }
        builder.append(")]");
        return builder.toString();
    }

    protected boolean trackRecurrentElements() {
        return false;
    }

    protected abstract void update();

    private void updateCurrentDepth() {
        this._lastDepth = this._nextDepth;
        this._maxDepth = Math.max(this._maxDepth, this._lastDepth);
    }
}

