/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>System Settings</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getSendMode <em>Send Mode</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendMode <em>Reset Send Mode</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendModeOn <em>Reset Send Mode On</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#isConfigured <em>Configured</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#isDebugEnabled <em>Debug Enabled</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getAnonymousId <em>Anonymous Id</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings()
 * @model
 * @generated
 */
public interface ISystemSettings extends IUserSettings {
	/**
	 * Returns the value of the '<em><b>Send Mode</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.epp.logging.aeri.core.SendMode}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Send Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Send Mode</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.SendMode
	 * @see #setSendMode(SendMode)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings_SendMode()
	 * @model
	 * @generated
	 */
	SendMode getSendMode();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getSendMode <em>Send Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Send Mode</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.SendMode
	 * @see #getSendMode()
	 * @generated
	 */
	void setSendMode(SendMode value);

	/**
	 * Returns the value of the '<em><b>Reset Send Mode</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.epp.logging.aeri.core.ResetSendMode}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reset Send Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reset Send Mode</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.ResetSendMode
	 * @see #setResetSendMode(ResetSendMode)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings_ResetSendMode()
	 * @model
	 * @generated
	 */
	ResetSendMode getResetSendMode();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendMode <em>Reset Send Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reset Send Mode</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.ResetSendMode
	 * @see #getResetSendMode()
	 * @generated
	 */
	void setResetSendMode(ResetSendMode value);

	/**
	 * Returns the value of the '<em><b>Reset Send Mode On</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reset Send Mode On</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reset Send Mode On</em>' attribute.
	 * @see #setResetSendModeOn(long)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings_ResetSendModeOn()
	 * @model
	 * @generated
	 */
	long getResetSendModeOn();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getResetSendModeOn <em>Reset Send Mode On</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reset Send Mode On</em>' attribute.
	 * @see #getResetSendModeOn()
	 * @generated
	 */
	void setResetSendModeOn(long value);

	/**
	 * Returns the value of the '<em><b>Configured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configured</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configured</em>' attribute.
	 * @see #setConfigured(boolean)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings_Configured()
	 * @model
	 * @generated
	 */
	boolean isConfigured();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#isConfigured <em>Configured</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configured</em>' attribute.
	 * @see #isConfigured()
	 * @generated
	 */
	void setConfigured(boolean value);

	/**
	 * Returns the value of the '<em><b>Debug Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Debug Enabled</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Debug Enabled</em>' attribute.
	 * @see #setDebugEnabled(boolean)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings_DebugEnabled()
	 * @model
	 * @generated
	 */
	boolean isDebugEnabled();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#isDebugEnabled <em>Debug Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Debug Enabled</em>' attribute.
	 * @see #isDebugEnabled()
	 * @generated
	 */
	void setDebugEnabled(boolean value);

	/**
	 * Returns the value of the '<em><b>Anonymous Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Anonymous Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Anonymous Id</em>' attribute.
	 * @see #setAnonymousId(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSystemSettings_AnonymousId()
	 * @model
	 * @generated
	 */
	String getAnonymousId();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISystemSettings#getAnonymousId <em>Anonymous Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Anonymous Id</em>' attribute.
	 * @see #getAnonymousId()
	 * @generated
	 */
	void setAnonymousId(String value);

} // ISystemSettings
