/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import static org.eclipse.epp.logging.aeri.core.Constants.AERI_NAMESPACE;

import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;

public final class IDEConstants {

    public static final String BUNDLE_ID = "org.eclipse.epp.logging.aeri.ide"; //$NON-NLS-1$
    public static final String PREFERENCE_PAGE_ID = BUNDLE_ID + ".preferencePages.root"; //$NON-NLS-1$
    /**
     * {@value} of type <code>List&lt;{@link IServerDescriptor}&gt;</code>
     */
    // values for notifications
    public static final String NOTIFY_CONFIGURATION = AERI_NAMESPACE + ".notifications.event.setup"; //$NON-NLS-1$
    public static final String NOTIFY_REPORT = AERI_NAMESPACE + ".notifications.event.newProblem"; //$NON-NLS-1$
    public static final String NOTIFY_RESPONSES = AERI_NAMESPACE + ".notifications.event.responses"; //$NON-NLS-1$

    public static final String HELP_URL = "https://wiki.eclipse.org/EPP/Logging"; //$NON-NLS-1$
    public static final String FEEDBACK_FORM_URL = "https://docs.google.com/a/codetrails.com/forms/d/1wd9AzydLv_TMa7ZBXHO7zQIhZjZCJRNMed-6J4fVNsc/viewform"; //$NON-NLS-1$

    private IDEConstants() {
        // Not meant to be instantiated
    }
}
