/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.text.edits.TextEditGroup;

public abstract class ConvertLoopOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    protected static final String FOR_LOOP_ELEMENT_IDENTIFIER = "element";
    protected static final IStatus ERROR_STATUS = new Status(4, JavaManipulationPlugin.getPluginId(), "");
    private final ForStatement fStatement;
    private ConvertLoopOperation fOperation;
    private final String[] fUsedNames;

    public ConvertLoopOperation(ForStatement statement, String[] usedNames) {
        this.fStatement = statement;
        this.fUsedNames = usedNames;
    }

    public void setBodyConverter(ConvertLoopOperation operation) {
        this.fOperation = operation;
    }

    public abstract String getIntroducedVariableName();

    public abstract IStatus satisfiesPreconditions();

    protected abstract Statement convert(CompilationUnitRewrite var1, TextEditGroup var2, LinkedProposalModelCore var3) throws CoreException;

    protected ForStatement getForStatement() {
        return this.fStatement;
    }

    protected Statement getBody(CompilationUnitRewrite cuRewrite, TextEditGroup group, LinkedProposalModelCore positionGroups) throws CoreException {
        if (this.fOperation != null) {
            return this.fOperation.convert(cuRewrite, group, positionGroups);
        }
        return (Statement)cuRewrite.getASTRewrite().createMoveTarget((ASTNode)this.getForStatement().getBody());
    }

    protected String[] getUsedVariableNames() {
        final ArrayList<String> results = new ArrayList<String>();
        ForStatement forStatement = this.getForStatement();
        CompilationUnit root = (CompilationUnit)forStatement.getRoot();
        Collection<String> variableNames = new ScopeAnalyzer(root).getUsedVariableNames(forStatement.getStartPosition(), forStatement.getLength());
        results.addAll(variableNames);
        forStatement.accept((ASTVisitor)new GenericVisitor(){

            @Override
            public boolean visit(SingleVariableDeclaration node) {
                results.add(node.getName().getIdentifier());
                return super.visit(node);
            }

            @Override
            public boolean visit(VariableDeclarationFragment fragment) {
                results.add(fragment.getName().getIdentifier());
                return super.visit(fragment);
            }
        });
        results.addAll(Arrays.asList(this.fUsedNames));
        return results.toArray(new String[results.size()]);
    }
}

