/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.LifecycleCallback;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.ejb.ActivationConfigProperty;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.InitMethodType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.MethodParams;
import org.eclipse.jst.javaee.ejb.NamedMethodType;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.SessionType;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationFactory;
import org.eclipse.jst.jee.model.internal.common.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbAnnotationFactory
extends AbstractAnnotationFactory {
    private static final String INIT = "Init";
    private static final String RUN_AS = "RunAs";
    private static final String RESOURCES = "Resources";
    private static final String CONTAINER = "CONTAINER";
    private static final String TRANSACTION_MANAGEMENT_TYPE_CONTAINER = "TransactionManagementType.CONTAINER";
    private static final String VALUE = "value";
    private static final String TRANSACTION_MANAGEMENT = "TransactionManagement";
    private static final String EJBS = "EJBs";
    private static final String DECLARE_ROLES = "DeclareRoles";
    private static final String LOCAL_HOME = "LocalHome";
    private static final String REMOTE_HOME = "RemoteHome";
    private static final String JAVAX_EJB_TIMER = "javax.ejb.Timer";
    private static final String TIMER = "Timer";
    private static final String RETAIN_IF_EXCEPTION = "retainIfException";
    private static final String REMOVE = "Remove";
    private static final String PRE_PASSIVATE = "PrePassivate";
    private static final String POST_ACTIVATE = "PostActivate";
    private static final String TIMEOUT = "Timeout";
    private static final String PRE_DESTROY = "PreDestroy";
    private static final String POST_CONSTRUCT = "PostConstruct";
    private static final String LOCAL = "Local";
    private static final String REMOTE = "Remote";
    private static final String RESOURCE = "Resource";
    private static final String EJB = "EJB";
    private static final String DESCRIPTION = "description";
    private static final String MAPPED_NAME = "mappedName";
    private static final String NAME = "name";
    private static final String VOID_RETURN_TYPE = "V";
    private static final String JAVAX_EJB_STATEFUL = "javax.ejb.Stateful";
    private static final String JAVAX_EJB_SINGLETON = "javax.ejb.Singleton";
    private static final String STATEFUL = "Stateful";
    private static final String JAVAX_EJB_MESSAGE_DRIVEN = "javax.ejb.MessageDriven";
    private static final String MESSAGE_DRIVEN = "MessageDriven";
    private static final String JAVAX_EJB_STATELESS = "javax.ejb.Stateless";
    private static final String STATELESS = "Stateless";
    private static final String SINGLETON = "Singleton";
    private static final String CREATE_METHOD = "create";

    public static EjbAnnotationFactory createFactory() {
        return new EjbAnnotationFactory();
    }

    private EjbAnnotationFactory() {
    }

    public Result createJavaeeObject(IType type) throws JavaModelException {
        Result result = new Result();
        IAnnotation[] iAnnotationArray = type.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationName = annotation.getElementName();
            if (STATELESS.equals(annotationName) || JAVAX_EJB_STATELESS.equals(annotationName)) {
                this.processStatelessBean(result, annotation, type);
                break;
            }
            if (MESSAGE_DRIVEN.equals(annotationName) || JAVAX_EJB_MESSAGE_DRIVEN.equals(annotationName)) {
                this.processMessageDrivenBean(result, annotation, type);
                break;
            }
            if (STATEFUL.equals(annotationName) || JAVAX_EJB_STATEFUL.equals(annotationName)) {
                this.processStatefulBean(result, annotation, type);
                break;
            }
            if (SINGLETON.equals(annotationName) || JAVAX_EJB_SINGLETON.equals(annotationName)) {
                this.processSingletonBean(result, annotation, type);
                break;
            }
            ++n2;
        }
        return result;
    }

    private void processMessageDrivenBean(Result result, IAnnotation annotation, IType type) throws JavaModelException {
        MessageDrivenBean mdb = this.createMDB(result, annotation, type);
        result.setMainObject((JavaEEObject)mdb);
    }

    private void processStatelessBean(Result result, IAnnotation annotation, IType type) throws JavaModelException {
        SessionBean sessionBean = this.createSession(result, SessionType.STATELESS_LITERAL, annotation, type);
        result.setMainObject((JavaEEObject)sessionBean);
    }

    private void processSingletonBean(Result result, IAnnotation annotation, IType type) throws JavaModelException {
        SessionBean sessionBean = this.createSession(result, SessionType.SINGLETON_LITERAL, annotation, type);
        result.setMainObject((JavaEEObject)sessionBean);
    }

    private void processStatefulBean(Result result, IAnnotation annotation, IType type) throws JavaModelException {
        SessionBean sessionBean = this.createSession(result, SessionType.STATEFUL_LITERAL, annotation, type);
        this.processStatefulMethods(sessionBean, type);
        result.setMainObject((JavaEEObject)sessionBean);
    }

    private void addInterfaces(List list, IType type, IMemberValuePair pair, Collection<IType> dependedTypes) throws JavaModelException {
        if (!EjbAnnotationFactory.isArrayOfObject((Object)pair.getValue())) {
            return;
        }
        Object[] value = (Object[])pair.getValue();
        IType interfaceType = null;
        int i = 0;
        while (i < value.length) {
            interfaceType = this.resolveType(type, (String)value[i]);
            if (interfaceType != null) {
                list.add(interfaceType.getFullyQualifiedName());
                dependedTypes.add(interfaceType);
            } else {
                list.add(value[i]);
            }
            ++i;
        }
    }

    private static void addLifecycleMethod(List callbacks, IMethod method, IAnnotation annotation) {
        LifecycleCallback callback = JavaeeFactory.eINSTANCE.createLifecycleCallback();
        callback.setLifecycleCallbackClass(method.getDeclaringType().getFullyQualifiedName());
        callback.setLifecycleCallbackMethod(method.getElementName());
        callbacks.add(callback);
    }

    private MessageDrivenBean createMDB(Result result, IAnnotation annotation, IType type) throws JavaModelException {
        result.getDependedTypes().add(type);
        MessageDrivenBean mdbBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        mdbBean.setEjbClass(type.getFullyQualifiedName());
        this.processMessageDrivenAnnotation(mdbBean, annotation, type);
        this.processTypeAnnotations(result, (JavaEEObject)mdbBean, type);
        this.processFieldAnnotations((JavaEEObject)mdbBean, type, result.getDependedTypes());
        this.processMethodAnnotations((JavaEEObject)mdbBean, type, result.getDependedTypes());
        return mdbBean;
    }

    private SessionBean createSession(Result result, SessionType sessionType, IAnnotation annotation, IType type) throws JavaModelException {
        result.getDependedTypes().add(type);
        SessionBean sessionBean = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean.setSessionType(sessionType);
        this.processAnnotation(sessionBean, annotation, type);
        this.processTypeAnnotations(result, (JavaEEObject)sessionBean, type);
        this.processFieldAnnotations((JavaEEObject)sessionBean, type, result.getDependedTypes());
        this.processMethodAnnotations((JavaEEObject)sessionBean, type, result.getDependedTypes());
        this.processImplementedInterfaces(sessionBean, type, result.getDependedTypes(), null);
        return sessionBean;
    }

    private static boolean isLifecycleMethod(IMethod method) throws JavaModelException {
        if (!VOID_RETURN_TYPE.equals(method.getReturnType())) {
            return false;
        }
        if ((method.getFlags() & 8) != 0 || (method.getFlags() & 0x10) != 0) {
            return false;
        }
        if (method.getNumberOfParameters() != 0) {
            return false;
        }
        return method.getExceptionTypes().length == 0;
    }

    private void procesRemoteHomeAnnotation(IAnnotation annotation, SessionBean sessionBean, IType type, Collection<IType> dependedTypes) throws JavaModelException {
        IMemberValuePair[] pair = annotation.getMemberValuePairs();
        if (pair.length == 1) {
            String value = (String)pair[0].getValue();
            IType interfaceType = this.resolveType(type, value);
            if (interfaceType != null) {
                sessionBean.setHome(interfaceType.getFullyQualifiedName());
                dependedTypes.add(interfaceType);
                try {
                    IMethod method = interfaceType.getMethod(CREATE_METHOD, null);
                    if (method != null && !VOID_RETURN_TYPE.equals(method.getReturnType())) {
                        String componentType = Signature.toString((String)method.getReturnType());
                        String[][] resolveType = interfaceType.resolveType(componentType);
                        if (resolveType[0].length == 2) {
                            componentType = String.valueOf(resolveType[0][0]) + "." + resolveType[0][1];
                        }
                        sessionBean.setRemote(componentType);
                    }
                }
                catch (CoreException coreException) {}
            } else {
                sessionBean.setHome(value);
            }
        }
    }

    private void processActivationConfig(IAnnotation activationAnnotation, MessageDrivenBean mdbBean, IType type) throws JavaModelException {
        IMemberValuePair[] pairs = activationAnnotation.getMemberValuePairs();
        if (pairs.length != 2) {
            return;
        }
        String name = (String)this.getAnnotatedValue("propertyName", pairs);
        String value = (String)this.getAnnotatedValue("propertyValue", pairs);
        ActivationConfigProperty property = EjbFactory.eINSTANCE.createActivationConfigProperty();
        property.setActivationConfigPropertyName(name);
        property.setActivationConfigPropertyValue(value);
        if (mdbBean.getActivationConfig() == null) {
            mdbBean.setActivationConfig(EjbFactory.eINSTANCE.createActivationConfig());
        }
        mdbBean.getActivationConfig().getActivationConfigProperties().add(property);
    }

    private SessionBean processAnnotation(SessionBean sessionBean, IAnnotation annotation, IType type) throws JavaModelException {
        String fullyQualifiedName = type.getFullyQualifiedName();
        sessionBean.setEjbClass(fullyQualifiedName);
        sessionBean.setEjbName(type.getElementName());
        IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
        String name = (String)this.getAnnotatedValue(NAME, memberValuePairs);
        String mappedName = (String)this.getAnnotatedValue(MAPPED_NAME, memberValuePairs);
        String descr = (String)this.getAnnotatedValue(DESCRIPTION, memberValuePairs);
        if (name != null) {
            sessionBean.setEjbName(name);
        }
        if (mappedName != null) {
            sessionBean.setMappedName(mappedName);
        }
        if (descr != null) {
            Description description = JavaeeFactory.eINSTANCE.createDescription();
            description.setValue(descr);
            if (sessionBean.getDescriptions().isEmpty()) {
                sessionBean.getDescriptions().add(description);
            } else {
                sessionBean.getDescriptions().set(0, description);
            }
        }
        return sessionBean;
    }

    private void processFieldAnnotations(JavaEEObject bean, IType type, Collection<IType> dependedTypes) throws JavaModelException {
        SessionBean sessionBean = null;
        MessageDrivenBean messageBean = null;
        List ejbRefs = null;
        List resourceRefs = null;
        if (SessionBean.class.isInstance(bean)) {
            sessionBean = (SessionBean)bean;
            ejbRefs = sessionBean.getEjbLocalRefs();
            resourceRefs = sessionBean.getResourceRefs();
        } else if (MessageDrivenBean.class.isInstance(bean)) {
            messageBean = (MessageDrivenBean)bean;
            ejbRefs = messageBean.getEjbLocalRefs();
            resourceRefs = messageBean.getResourceRefs();
        }
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            IAnnotation[] iAnnotationArray = field.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                String annotationName = annotation.getElementName();
                if (EJB.equals(annotationName)) {
                    this.processEjbAnnotation(annotation, ejbRefs, (IMember)field, dependedTypes);
                } else if (RESOURCE.equals(annotationName)) {
                    this.processResourceRefAnnotation(annotation, resourceRefs, (IMember)field, dependedTypes);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void processImplementedInterfaces(SessionBean sessionBean, IType type, Collection<IType> dependedTypes, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<String> superInterfaces = new ArrayList<String>(Arrays.asList(type.getSuperInterfaceNames()));
        String[] stringArray = type.getSuperInterfaceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            String[][] fullTypeName = type.resolveType(interfaceName);
            if (fullTypeName != null) {
                IType inter = type.getJavaProject().findType(fullTypeName[0][0], fullTypeName[0][1]);
                if (EjbAnnotationFactory.isDefinedInBeanClass(inter, sessionBean.getBusinessLocals()) || EjbAnnotationFactory.isDefinedInBeanClass(inter, sessionBean.getBusinessRemotes())) {
                    superInterfaces.remove(interfaceName);
                } else {
                    String fullyQualifiedName = inter.getFullyQualifiedName();
                    IAnnotation[] iAnnotationArray = inter.getAnnotations();
                    int n3 = iAnnotationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        String annotationName = annotation.getElementName();
                        if (REMOTE.equals(annotationName)) {
                            sessionBean.getBusinessRemotes().add(fullyQualifiedName);
                            if (dependedTypes != null) {
                                dependedTypes.add(inter);
                            }
                            superInterfaces.remove(interfaceName);
                        } else if (LOCAL.equals(annotationName)) {
                            sessionBean.getBusinessLocals().add(fullyQualifiedName);
                            if (dependedTypes != null) {
                                dependedTypes.add(inter);
                            }
                            superInterfaces.remove(interfaceName);
                        }
                        ++n4;
                    }
                    if (!sessionBean.getBusinessRemotes().contains(fullyQualifiedName) && !sessionBean.getBusinessLocals().contains(fullyQualifiedName)) {
                        sessionBean.getBusinessLocals().add(fullyQualifiedName);
                        if (dependedTypes != null) {
                            dependedTypes.add(inter);
                        }
                        superInterfaces.remove(interfaceName);
                    }
                }
            }
            ++n2;
        }
        for (String string : superInterfaces) {
            if (sessionBean.getBusinessRemotes().contains(string) || sessionBean.getBusinessLocals().contains(string)) continue;
            sessionBean.getBusinessLocals().add(string);
        }
    }

    private static boolean isDefinedInBeanClass(IType type, List list) {
        if (list == null) {
            return false;
        }
        for (Object object : list) {
            if (!type.getFullyQualifiedName().equals(object.toString())) continue;
            return true;
        }
        return false;
    }

    private void processLocalHomeAnnotation(IAnnotation annotation, SessionBean sessionBean, IType type, Collection<IType> dependedTypes) throws JavaModelException {
        IMemberValuePair[] pair = annotation.getMemberValuePairs();
        if (pair.length == 1) {
            String value = (String)pair[0].getValue();
            IType interfaceType = this.resolveType(type, value);
            if (interfaceType != null) {
                sessionBean.setLocalHome(interfaceType.getFullyQualifiedName());
                dependedTypes.add(interfaceType);
                try {
                    IMethod method = interfaceType.getMethod(CREATE_METHOD, null);
                    if (method != null && !VOID_RETURN_TYPE.equals(method.getReturnType())) {
                        String componentType = Signature.toString((String)method.getReturnType());
                        String[][] resolveType = interfaceType.resolveType(componentType);
                        if (resolveType[0].length == 2) {
                            componentType = String.valueOf(resolveType[0][0]) + "." + resolveType[0][1];
                        }
                        sessionBean.setLocal(componentType);
                    }
                }
                catch (CoreException coreException) {}
            } else {
                sessionBean.setLocalHome(value);
            }
        }
    }

    private void processMessageDrivenAnnotation(MessageDrivenBean mdbBean, IAnnotation annotation, IType type) throws JavaModelException {
        Object values;
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        String beanName = type.getElementName();
        String beanName2 = (String)this.getAnnotatedValue(NAME, pairs);
        mdbBean.setEjbName(beanName2 == null ? beanName : beanName2);
        String mappedName = (String)this.getAnnotatedValue(MAPPED_NAME, pairs);
        String descr = (String)this.getAnnotatedValue(DESCRIPTION, pairs);
        if (mappedName != null) {
            mdbBean.setMappedName(mappedName);
        }
        if (descr != null) {
            Description description = JavaeeFactory.eINSTANCE.createDescription();
            description.setValue(descr);
            if (mdbBean.getDescriptions().isEmpty()) {
                mdbBean.getDescriptions().add(description);
            } else {
                mdbBean.getDescriptions().set(0, description);
            }
        }
        if (!EjbAnnotationFactory.isArrayOfObject((Object)(values = this.getAnnotatedValue("activationConfig", pairs)))) {
            return;
        }
        Object[] objectArray = (Object[])values;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object activationAnnotation = objectArray[n2];
            this.processActivationConfig((IAnnotation)activationAnnotation, mdbBean, type);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMethodAnnotations(JavaEEObject bean, IType type, Collection<IType> dependedTypes) throws JavaModelException {
        sessionBean = null;
        messageBean = null;
        ejbRefs = null;
        resourceRefs = null;
        postConstructs = null;
        preDestroys = null;
        if (SessionBean.class.isInstance(bean)) {
            sessionBean = (SessionBean)bean;
            ejbRefs = sessionBean.getEjbLocalRefs();
            resourceRefs = sessionBean.getResourceRefs();
            postConstructs = sessionBean.getPostConstructs();
            preDestroys = sessionBean.getPreDestroys();
        } else if (MessageDrivenBean.class.isInstance(bean)) {
            messageBean = (MessageDrivenBean)bean;
            ejbRefs = messageBean.getEjbLocalRefs();
            resourceRefs = messageBean.getResourceRefs();
            postConstructs = messageBean.getPostConstructs();
            preDestroys = messageBean.getPreDestroys();
        }
        var13_10 = type.getMethods();
        var12_11 = var13_10.length;
        var11_12 = 0;
        while (var11_12 < var12_11) {
            method = var13_10[var11_12];
            isLifecycle = EjbAnnotationFactory.isLifecycleMethod(method);
            var18_18 = method.getAnnotations();
            var17_17 = var18_18.length;
            var16_16 = 0;
            while (var16_16 < var17_17) {
                annotation = var18_18[var16_16];
                annotationName = annotation.getElementName();
                if (!isLifecycle) ** GOTO lbl-1000
                if ("PostConstruct".equals(annotationName)) {
                    EjbAnnotationFactory.addLifecycleMethod(postConstructs, method, annotation);
                } else if ("PreDestroy".equals(annotationName)) {
                    EjbAnnotationFactory.addLifecycleMethod(preDestroys, method, annotation);
                } else if ("EJB".equals(annotationName)) {
                    this.processEjbAnnotation(annotation, ejbRefs, (IMember)method, dependedTypes);
                } else if ("Resource".equals(annotationName)) {
                    this.processResourceRefAnnotation(annotation, resourceRefs, (IMember)method, dependedTypes);
                } else if (sessionBean != null && sessionBean.getSessionType().getValue() == 2 && "Timeout".equals(annotationName)) {
                    this.processTimeoutAnnotation(sessionBean, method, annotation);
                }
                ++var16_16;
            }
            ++var11_12;
        }
    }

    private void processStatefulMethods(SessionBean bean, IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        boolean searchForInit = bean.getLocalHome() != null || bean.getHome() != null;
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation[] iAnnotationArray = method.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block13: {
                    IAnnotation annotation;
                    block12: {
                        annotation = iAnnotationArray[n4];
                        if (!searchForInit || !annotation.getElementName().equals(INIT)) break block12;
                        if (!VOID_RETURN_TYPE.equals(method.getReturnType())) break block13;
                        InitMethodType initMethod = EjbFactory.eINSTANCE.createInitMethodType();
                        NamedMethodType methodType = EjbFactory.eINSTANCE.createNamedMethodType();
                        methodType.setMethodName(method.getElementName());
                        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
                        String[] stringArray = method.getParameterTypes();
                        int n5 = stringArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String param = stringArray[n6];
                            params.getMethodParams().add(Signature.toString((String)param));
                            ++n6;
                        }
                        methodType.setMethodParams(params);
                        initMethod.setBeanMethod(methodType);
                        bean.getInitMethods().add(initMethod);
                    }
                    if (EjbAnnotationFactory.isLifecycleMethod(method)) {
                        if (annotation.getElementName().equals(POST_ACTIVATE)) {
                            EjbAnnotationFactory.addLifecycleMethod(bean.getPostActivates(), method, annotation);
                        } else if (annotation.getElementName().equals(PRE_PASSIVATE)) {
                            EjbAnnotationFactory.addLifecycleMethod(bean.getPrePassivates(), method, annotation);
                        } else if (annotation.getElementName().equals(REMOVE)) {
                            RemoveMethodType removeMethod = EjbFactory.eINSTANCE.createRemoveMethodType();
                            Boolean retainIfException = (Boolean)this.getAnnotatedValue(RETAIN_IF_EXCEPTION, annotation.getMemberValuePairs());
                            removeMethod.setRetainIfException(retainIfException != null ? retainIfException : false);
                            NamedMethodType methodType = EjbFactory.eINSTANCE.createNamedMethodType();
                            methodType.setMethodName(method.getElementName());
                            removeMethod.setBeanMethod(methodType);
                            bean.getRemoveMethods().add(removeMethod);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void processTimeoutAnnotation(SessionBean sessionBean, IMethod method, IAnnotation annotation) throws JavaModelException {
        if (method.getNumberOfParameters() != 1) {
            return;
        }
        String paramName = Signature.toString((String)method.getParameterTypes()[0]);
        if (!TIMER.equals(paramName) && !JAVAX_EJB_TIMER.equals(paramName)) {
            return;
        }
        if (method.getExceptionTypes().length != 0) {
            return;
        }
        NamedMethodType methodType = EjbFactory.eINSTANCE.createNamedMethodType();
        methodType.setMethodName(method.getElementName());
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        params.getMethodParams().add(paramName);
        methodType.setMethodParams(params);
        sessionBean.setTimeoutMethod(methodType);
    }

    private void processTypeAnnotations(Result result, JavaEEObject bean, IType type) throws JavaModelException {
        SessionBean sessionBean = null;
        MessageDrivenBean messageBean = null;
        List ejbRefs = null;
        List resourceRefs = null;
        if (SessionBean.class.isInstance(bean)) {
            sessionBean = (SessionBean)bean;
            ejbRefs = sessionBean.getEjbLocalRefs();
            resourceRefs = sessionBean.getResourceRefs();
        } else if (MessageDrivenBean.class.isInstance(bean)) {
            messageBean = (MessageDrivenBean)bean;
            ejbRefs = messageBean.getEjbLocalRefs();
            resourceRefs = messageBean.getResourceRefs();
        }
        IAnnotation[] iAnnotationArray = type.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            IMemberValuePair[] pairs = annotation.getMemberValuePairs();
            String annotationName = annotation.getElementName();
            if (sessionBean != null) {
                if (LOCAL.equals(annotationName)) {
                    if (pairs.length == 1) {
                        this.addInterfaces(sessionBean.getBusinessLocals(), type, pairs[0], result.getDependedTypes());
                    }
                } else if (REMOTE.equals(annotationName)) {
                    if (pairs.length == 1) {
                        this.addInterfaces(sessionBean.getBusinessRemotes(), type, pairs[0], result.getDependedTypes());
                    }
                } else if (REMOTE_HOME.equals(annotationName)) {
                    this.procesRemoteHomeAnnotation(annotation, sessionBean, type, result.getDependedTypes());
                } else if (LOCAL_HOME.equals(annotationName)) {
                    this.processLocalHomeAnnotation(annotation, sessionBean, type, result.getDependedTypes());
                } else if (DECLARE_ROLES.equals(annotationName)) {
                    this.processDeclareRoles(result, sessionBean.getSecurityRoleRefs(), annotation, type);
                }
            }
            if (EJB.equals(annotationName)) {
                this.processEjbAnnotation(annotation, ejbRefs, (IMember)type, result.getDependedTypes());
            } else if (EJBS.equals(annotationName)) {
                Object[] values;
                if (!EjbAnnotationFactory.isArrayOfObject((Object)pairs[0].getValue())) {
                    return;
                }
                Object[] objectArray = values = (Object[])pairs[0].getValue();
                int n3 = values.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object ejbAnnotation = objectArray[n4];
                    this.processEjbAnnotation((IAnnotation)ejbAnnotation, ejbRefs, (IMember)type, result.getDependedTypes());
                    ++n4;
                }
            } else if (TRANSACTION_MANAGEMENT.equals(annotationName)) {
                String value = (String)this.getAnnotatedValue(VALUE, pairs);
                TransactionType transaction = null;
                if (TRANSACTION_MANAGEMENT_TYPE_CONTAINER.equals(value)) {
                    transaction = TransactionType.CONTAINER_LITERAL;
                } else if (CONTAINER.equals(value) && this.containsImport(type.getCompilationUnit(), TRANSACTION_MANAGEMENT_TYPE_CONTAINER)) {
                    transaction = TransactionType.CONTAINER_LITERAL;
                }
                if (transaction != null) {
                    if (sessionBean != null) {
                        sessionBean.setTransactionType(transaction);
                    } else if (messageBean != null) {
                        messageBean.setTransactionType(transaction);
                    }
                }
            } else if (RESOURCE.equals(annotationName)) {
                this.processResourceRefAnnotation(annotation, resourceRefs, (IMember)type, result.getDependedTypes());
            } else if (RESOURCES.equals(annotationName)) {
                this.processResourcesAnnotation(annotation, resourceRefs, type, result.getDependedTypes());
            } else if (RUN_AS.equals(annotationName)) {
                SecurityIdentityType identity = EjbFactory.eINSTANCE.createSecurityIdentityType();
                RunAs runAs = JavaeeFactory.eINSTANCE.createRunAs();
                this.processRunAs(annotation, runAs);
                identity.setRunAs(runAs);
                if (identity.getRunAs().getRoleName() != null) {
                    if (sessionBean != null) {
                        sessionBean.setSecurityIdentities(identity);
                    } else if (messageBean != null) {
                        messageBean.setSecurityIdentity(identity);
                    }
                }
            }
            ++n2;
        }
    }
}

