/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.open;

import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TestResultNodeTraverser;
import org.eclipse.jubula.client.ui.editors.TestResultEditorInput;
import org.eclipse.jubula.client.ui.editors.TestResultViewer;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTestResultViewerHandler
extends AbstractProjectHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTestResultViewerHandler.class);

    @Override
    public Object executeImpl(final ExecutionEvent event) throws ExecutionException {
        String summaryIdString = event.getParameter("org.eclipse.jubula.client.ui.commands.OpenTestResultViewer.parameter.summaryId");
        IEditorInput editorInput = null;
        EntityManager mSession = GeneralStorage.getInstance().getMasterSession();
        if (summaryIdString != null) {
            final Long summaryId = Long.valueOf(summaryIdString);
            if (TestResultPM.hasTestResultDetails((EntityManager)mSession, (Long)summaryId)) {
                ITestResultSummaryPO testResultSummary = TestResultPM.getTestResultSummary((EntityManager)mSession, (Long)summaryId);
                editorInput = new TestResultEditorInput(testResultSummary);
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox mb = new MessageBox(HandlerUtil.getActiveShell((ExecutionEvent)event));
                        mb.setMessage(NLS.bind((String)Messages.TestresultDetailsForSummaryNotFound, (Object)summaryId));
                        mb.open();
                    }
                });
            }
        } else {
            editorInput = this.getEditorInputFromTestResultSummaryView(event, mSession);
        }
        this.openTestResultViewerEditor(event, editorInput);
        return null;
    }

    private IEditorInput getEditorInputFromTestResultSummaryView(ExecutionEvent event, EntityManager session) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        TestResultEditorInput editorInput = null;
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)currentSelection;
            for (Object firstElement : structuredSel) {
                if (firstElement instanceof ITestResultSummaryPO) {
                    ITestResultSummaryPO result = (ITestResultSummaryPO)firstElement;
                    if (!result.hasTestResultDetails()) continue;
                    editorInput = new TestResultEditorInput(result);
                    continue;
                }
                LOG.info(String.valueOf(Messages.SelectedElementIsNotTestResultSummary) + ".");
            }
        }
        return editorInput;
    }

    private void openTestResultViewerEditor(ExecutionEvent event, IEditorInput editorInput) throws ExecutionException {
        if (editorInput != null) {
            IWorkbenchPage currentPage = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event).getPage();
            String nodeId = event.getParameter("org.eclipse.jubula.client.ui.commands.OpenTestResultViewer.parameter.resultNode");
            long nodeID = 1L;
            try {
                nodeID = Math.abs(Long.valueOf(nodeId));
            }
            catch (NumberFormatException numberFormatException) {}
            if (currentPage != null) {
                this.openEditor(editorInput, currentPage, nodeID);
            }
        } else {
            LOG.info(Messages.NoEditorInputCouldBeCreated);
        }
    }

    private void openEditor(final IEditorInput editorInput, final IWorkbenchPage currentPage, final long nodeId) {
        Display currentDisplay = Display.getDefault();
        currentDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TestResultViewer editor = (TestResultViewer)currentPage.openEditor(editorInput, "org.eclipse.jubula.client.ui.editors.TestResultViewer");
                    if (editor != null && editor.getTreeViewer() != null) {
                        SearchNodeByCountOperation operation = new SearchNodeByCountOperation(nodeId);
                        TestResultNodeTraverser traverser = new TestResultNodeTraverser(editor.getTestResultRootNode(), (ITreeNodeOperation)operation);
                        traverser.traverse();
                        Object nodeToSelect = operation.getNode();
                        if (nodeToSelect != null) {
                            StructuredSelection selection = new StructuredSelection(nodeToSelect);
                            editor.getTreeViewer().reveal(nodeToSelect);
                            editor.setSelection((ISelection)selection);
                        }
                    }
                }
                catch (PartInitException partInitException) {
                    ErrorHandlingUtil.createMessageDialog(MessageIDs.E_CANNOT_OPEN_EDITOR);
                }
            }
        });
    }

    private static class SearchNodeByCountOperation
    implements ITreeNodeOperation<TestResultNode> {
        private Long m_initialNodeToSelect;
        private Long m_currentNodeCount = new Long(0L);
        private Object m_node = null;
        private boolean m_found = false;

        public SearchNodeByCountOperation(Long nodeToSearchByCount) {
            this.m_initialNodeToSelect = nodeToSearchByCount;
        }

        public boolean operate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
            this.m_currentNodeCount = this.m_currentNodeCount + 1L;
            if (this.m_currentNodeCount.equals(this.m_initialNodeToSelect)) {
                this.setNode(node);
                this.m_found = true;
            }
            return !this.m_found;
        }

        public void postOperate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
        }

        public Object getNode() {
            return this.m_node;
        }

        private void setNode(Object node) {
            this.m_node = node;
        }
    }
}

