/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerCompose;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;

public class DockerComposeStopJob
extends Job {
    private final IDockerConnection connection;
    private final String workingDir;

    public DockerComposeStopJob(IDockerConnection connection, String workingDir) {
        super(JobMessages.getString("DockerComposeStop.title"));
        this.connection = connection;
        this.workingDir = workingDir;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String dockerComposeInstallDir = Activator.getDefault().getPreferenceStore().getString("dockerComposeInstallDir");
        try {
            Process dockerComposeStopProcess = DockerCompose.getInstance().stop(this.connection, dockerComposeInstallDir, this.workingDir);
            dockerComposeStopProcess.waitFor();
        }
        catch (InterruptedException | DockerException e) {
            Activator.logErrorMessage(JobMessages.getString("DockerComposeStop.error"), e);
        }
        return Status.OK_STATUS;
    }
}

