/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MavenDependenciesWizardPage
extends AbstractMavenWizardPage {
    TableViewer dependencyViewer;
    private Dependency[] dependencies;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    boolean showScope = false;

    public MavenDependenciesWizardPage() {
        this(null, Messages.wizardProjectPageDependenciesTitle, Messages.wizardProjectPageDependenciesDescription);
    }

    public MavenDependenciesWizardPage(ProjectImportConfiguration projectImportConfiguration, String title, String description) {
        super("MavenDependenciesWizardPage", projectImportConfiguration);
        this.setTitle(title);
        this.setDescription(description);
        this.setPageComplete(true);
    }

    public void setShowScope(boolean showScope) {
        this.showScope = showScope;
    }

    public void setDependencies(Dependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        if (this.dependencies != null) {
            this.createArtifacts(composite);
        }
        this.createAdvancedSettings(composite, new GridData(4, 128, false, false, 3, 1));
        this.setControl((Control)composite);
        this.updatePage();
    }

    private void createArtifacts(Composite composite) {
        Label mavenArtifactsLabel = new Label(composite, 0);
        mavenArtifactsLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        mavenArtifactsLabel.setText(Messages.MavenDependenciesWizardPage_lblArtifacts);
        this.dependencyViewer = new TableViewer(composite, 2818);
        this.dependencyViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        this.dependencyViewer.setUseHashlookup(true);
        this.dependencyViewer.setLabelProvider((IBaseLabelProvider)new ArtifactLabelProvider());
        this.dependencyViewer.setComparator((ViewerComparator)new DependencySorter());
        this.dependencyViewer.add((Object[])this.dependencies);
        Button addDependencyButton = new Button(composite, 8);
        GridData gd_addDependencyButton = new GridData(4, 128, false, false);
        addDependencyButton.setLayoutData((Object)gd_addDependencyButton);
        addDependencyButton.setText(Messages.wizardProjectPageDependenciesAdd);
        addDependencyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenRepositorySearchDialog dialog = MavenRepositorySearchDialog.createSearchDependencyDialog(MavenDependenciesWizardPage.this.getShell(), Messages.MavenDependenciesWizardPage_searchDialog_title, null, null, false);
                if (dialog.open() == 0) {
                    Set files;
                    Object result = dialog.getFirstResult();
                    if (result instanceof IndexedArtifactFile) {
                        Dependency dependency = ((IndexedArtifactFile)result).getDependency();
                        dependency.setScope(dialog.getSelectedScope());
                        MavenDependenciesWizardPage.this.dependencyViewer.add((Object)dependency);
                        MavenDependenciesWizardPage.this.notifyListeners();
                    } else if (result instanceof IndexedArtifact && (files = ((IndexedArtifact)result).getFiles()) != null && !files.isEmpty()) {
                        MavenDependenciesWizardPage.this.dependencyViewer.add((Object)((IndexedArtifactFile)files.iterator().next()).getDependency());
                        MavenDependenciesWizardPage.this.notifyListeners();
                    }
                }
            }
        });
        Button removeDependencyButton = new Button(composite, 8);
        removeDependencyButton.setLayoutData((Object)new GridData(4, 128, false, true));
        removeDependencyButton.setText(Messages.wizardProjectPageDependenciesRemove);
        removeDependencyButton.setEnabled(false);
        removeDependencyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MavenDependenciesWizardPage.this.dependencyViewer.getSelection();
                if (selection != null) {
                    MavenDependenciesWizardPage.this.dependencyViewer.remove(selection.toArray());
                    MavenDependenciesWizardPage.this.notifyListeners();
                }
            }
        });
        this.dependencyViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            removeDependencyButton.setEnabled(selection.size() > 0);
        });
    }

    public IWizardContainer getContainer() {
        return super.getContainer();
    }

    void updatePage() {
        this.setPageComplete(this.isPageValid());
    }

    private boolean isPageValid() {
        this.setErrorMessage(null);
        return true;
    }

    protected void notifyListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this.dependencyViewer, this.dependencyViewer.getSelection());
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void addListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public Dependency[] getDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        int i = 0;
        while (i < this.dependencyViewer.getTable().getItemCount()) {
            Object element = this.dependencyViewer.getElementAt(i);
            if (element instanceof Dependency) {
                dependencies.add((Dependency)element);
            }
            ++i;
        }
        return dependencies.toArray(new Dependency[dependencies.size()]);
    }

    public static class ArtifactLabelProvider
    extends LabelProvider {
        private static final Image DEPENDENCY_IMAGE = MavenImages.IMG_JAR;

        public String getText(Object element) {
            if (element instanceof Dependency) {
                Dependency d = (Dependency)element;
                return String.valueOf(d.getGroupId()) + ":" + d.getArtifactId() + ":" + d.getVersion() + (d.getClassifier() == null ? "" : ":" + d.getClassifier());
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Dependency) {
                return DEPENDENCY_IMAGE;
            }
            return super.getImage(element);
        }
    }

    public static class DependencySorter
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            int result;
            if (!(e1 instanceof Dependency) || !(e2 instanceof Dependency)) {
                return super.compare(viewer, e1, e2);
            }
            String group1 = ((Dependency)e1).getGroupId();
            String group2 = ((Dependency)e2).getGroupId();
            int n = result = group1 == null ? -1 : group1.compareToIgnoreCase(group2);
            if (result == 0) {
                String artifact1 = ((Dependency)e1).getArtifactId();
                String artifact2 = ((Dependency)e2).getArtifactId();
                result = artifact1 == null ? -1 : artifact1.compareToIgnoreCase(artifact2);
            }
            return result;
        }
    }
}

