/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.oomph.internal.setup.SetupPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private FileUtil() {
    }

    public static File rename(File from) throws IOException, InterruptedException {
        File to = new File(from.getParentFile(), String.valueOf(from.getName()) + "." + System.currentTimeMillis());
        FileUtil.rename(from, to);
        return to;
    }

    public static void rename(File from, File to) throws IOException, InterruptedException {
        if (from.exists()) {
            int i = 0;
            while (i < 200) {
                if (from.renameTo(to)) {
                    return;
                }
                Thread.sleep(10L);
                ++i;
            }
        }
        throw new IOException("Could not rename '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'");
    }

    public static void deleteAsync(final File file) throws IOException, InterruptedException {
        new Job("Deleting old files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FileUtil.delete(file, monitor, false);
                    return Status.OK_STATUS;
                }
                catch (Exception ex) {
                    SetupPlugin.INSTANCE.log(ex);
                    return SetupPlugin.INSTANCE.getStatus(ex);
                }
            }
        }.schedule();
    }

    public static void delete(File file, IProgressMonitor monitor) throws IOException, InterruptedException {
        FileUtil.delete(file, monitor, true);
    }

    private static void delete(File file, IProgressMonitor monitor, boolean verbose) throws IOException, InterruptedException {
        List<File> files = FileUtil.listAllFiles(file);
        int size = files.size();
        if (size == 0) {
            return;
        }
        if (verbose) {
            String message = "";
            if (file.isDirectory() && size > 1) {
                message = "Deleting files in " + file.getAbsolutePath();
            }
            monitor.beginTask(message, size);
        }
        try {
            Collections.reverse(files);
            for (File child : files) {
                SetupPlugin.checkCancelation((IProgressMonitor)monitor);
                if (verbose) {
                    String childPath = child.getAbsolutePath();
                    monitor.setTaskName("Deleting file " + childPath);
                }
                FileUtil.doDelete(child);
                monitor.worked(1);
            }
        }
        finally {
            if (verbose) {
                monitor.done();
            }
        }
    }

    private static void doDelete(File file) throws IOException, InterruptedException {
        int i = 0;
        while (i < 1000) {
            if (file.delete()) {
                return;
            }
            Thread.sleep(5L);
            ++i;
        }
        throw new IOException("Could not delete '" + file.getAbsolutePath() + "'");
    }

    private static List<File> listAllFiles(File file) {
        ArrayList<File> result = new ArrayList<File>();
        if (file != null && file.exists()) {
            FileUtil.listAllFiles(file, result);
        }
        return result;
    }

    private static void listAllFiles(File file, List<File> result) {
        result.add(file);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtil.listAllFiles(child, result);
                ++n2;
            }
        }
    }
}

