/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.reconciler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableReconciler;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableVersioningUtils;

public class TableReconcilersReader
extends RegistryReader {
    private static volatile TableReconcilersReader ourInstance = null;
    private static final String EXT_PT = "tableReconciler";
    private static final String TAG_TABLE_RECONCILER = "tableReconciler";
    private List<TableReconciler> myReconcilers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final TableReconcilersReader getInstance() {
        if (ourInstance != null) return ourInstance;
        Class<TableReconcilersReader> clazz = TableReconcilersReader.class;
        synchronized (TableReconcilersReader.class) {
            if (ourInstance != null) return ourInstance;
            ourInstance = new TableReconcilersReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    TableReconcilersReader() {
        super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.nattable.common", "tableReconciler");
    }

    public synchronized List<TableReconciler> load() {
        if (this.myReconcilers == null) {
            this.myReconcilers = new ArrayList<TableReconciler>();
            this.readRegistry();
        }
        return this.myReconcilers;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (!"tableReconciler".equals(element.getName())) {
            return false;
        }
        String className = element.getAttribute("reconcilerClass");
        String sourceVersion = element.getAttribute("source");
        String targetVersion = element.getAttribute("target");
        if (!TableReconcilersReader.checkNotEmpty(className)) {
            this.logMissingAttribute(element, "reconcilerClass");
            return false;
        }
        if (!TableReconcilersReader.checkNotEmpty(sourceVersion)) {
            this.logMissingAttribute(element, "source");
            return false;
        }
        if (!TableReconcilersReader.checkNotEmpty(targetVersion)) {
            this.logMissingAttribute(element, "target");
            return false;
        }
        if (!TableVersioningUtils.isCurrentPapyrusVersion(targetVersion)) {
            Activator.log.debug("Reconciler for outdated version is still registered but will never be executed: " + className);
            return false;
        }
        if (add) {
            this.addTableReconciler(element);
        } else {
            this.removeTableReconciler(element);
        }
        return true;
    }

    private static boolean checkNotEmpty(String attr) {
        return attr != null && attr.length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTableReconciler(IConfigurationElement element) {
        TableReconciler reconciler = this.createReconciler(element);
        if (reconciler != null) {
            List<TableReconciler> list = this.myReconcilers;
            synchronized (list) {
                this.myReconcilers.add(reconciler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTableReconciler(IConfigurationElement element) {
        String fqn = element.getAttribute("reconcilerClass");
        if (fqn == null) {
            return;
        }
        List<TableReconciler> list = this.myReconcilers;
        synchronized (list) {
            Iterator<TableReconciler> it = this.myReconcilers.iterator();
            while (it.hasNext()) {
                TableReconciler next = it.next();
                if (!fqn.equals(next.getClassFqn())) continue;
                it.remove();
                break;
            }
        }
    }

    private TableReconciler createReconciler(IConfigurationElement element) {
        try {
            Object reconcilerObject = element.createExecutableExtension("reconcilerClass");
            if (reconcilerObject instanceof TableReconciler) {
                return (TableReconciler)reconcilerObject;
            }
            Activator.log.error("Table reconciler extension does not extend mandatory TableReconciler base class: " + element.getAttribute("reconcilerClass"), null);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }
}

