/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.nattableconfiguration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattabletester.AbstractTableTester;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattabletester.JavaTableTester;
import org.eclipse.papyrus.infra.nattable.tester.ITableTester;
import org.eclipse.papyrus.infra.nattable.tester.TableTesterRegistry;

public class NattableConfigurationRegistry {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.configuration";
    public static final String FILE_ATTRIBUTE = "file";
    private Map<String, TableConfiguration> configsURI;
    private ResourceSet resourceSet;
    public static final NattableConfigurationRegistry INSTANCE = new NattableConfigurationRegistry();

    private NattableConfigurationRegistry() {
        this.initFields();
    }

    public Collection<TableConfiguration> getTableConfigurations() {
        return this.configsURI.values();
    }

    public void registerTableConfiguration(TableConfiguration newTableConfiguration) {
        this.configsURI.put(newTableConfiguration.getType(), newTableConfiguration);
    }

    public TableConfiguration getConfiguration(String tableType) {
        return this.configsURI.get(tableType);
    }

    private void initFields() {
        if (this.configsURI == null) {
            this.configsURI = new HashMap<String, TableConfiguration>();
            IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
            this.resourceSet = new ResourceSetImpl();
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String file = iConfigurationElement.getAttribute(FILE_ATTRIBUTE);
                IContributor contributor = iConfigurationElement.getContributor();
                URI uri = URI.createPlatformPluginURI((String)(String.valueOf(contributor.getName()) + "/" + file.toString()), (boolean)true);
                Resource res = this.resourceSet.getResource(uri, true);
                if (res.getContents().size() > 0) {
                    EObject first = (EObject)res.getContents().get(0);
                    if (first instanceof TableConfiguration) {
                        String type = ((TableConfiguration)first).getType();
                        if (type != null) {
                            if (!this.configsURI.containsKey(type)) {
                                this.configsURI.put(type, (TableConfiguration)first);
                            } else {
                                Activator.log.warn(String.format(Messages.NattableConfigurationRegistry_SeveralConfigurationsWithTheSameType, type));
                            }
                        } else {
                            Activator.log.warn(String.format(Messages.NattableConfigurationRegistry_NoTypeForAConfiguration, uri));
                        }
                    } else {
                        Activator.log.warn(String.format(Messages.NattableConfigurationRegistry_TableConfigurationNotFound, uri));
                    }
                } else {
                    Activator.log.warn(String.format(Messages.NattableConfigurationRegistry_ResourceEmpty, uri));
                }
                ++n2;
            }
        }
    }

    public IStatus canCreateTable(String tableType, Object tableContext) {
        TableConfiguration config = this.configsURI.get(tableType);
        if (config != null) {
            AbstractTableTester tester = config.getCreationTester();
            if (tester instanceof JavaTableTester) {
                String testerId = ((JavaTableTester)tester).getTester();
                ITableTester myTester = TableTesterRegistry.INSTANCE.getTableTester(testerId);
                if (myTester != null) {
                    return myTester.isAllowed(tableContext);
                }
                return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.NattableConfigurationRegistry_TesterNotFound);
            }
            if (tester == null) {
                return new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.NattableConfigurationRegistry_NoTesterForThisConfiguration);
            }
            return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.NattableConfigurationRegistry_TesterNotManager);
        }
        return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.NattableConfigurationRegistry_ConfigurationNotFound);
    }
}

