/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.internal.handler;

import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.internal.handler.SubmodelState;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleSubmodelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain domain;
        EObject selection = this.getSelection(event.getApplicationContext());
        if (selection != null && (domain = TransactionUtil.getEditingDomain((EObject)selection)) != null) {
            ControlModeRequest request = ControlModeRequest.createUIControlModelRequest(domain, selection, selection.eResource().getURI());
            Throwable throwable = null;
            Object var6_7 = null;
            try (ShardResourceHelper helper = new ShardResourceHelper(selection);){
                request.setParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.CreateShard", !helper.isShard());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ICommand modelCommand = ControlModeManager.getInstance().getShardModeCommand(request);
            if (modelCommand != null && modelCommand.canExecute()) {
                domain.getCommandStack().execute((Command)ICommandWrapper.wrap((Object)modelCommand, Command.class));
            }
        }
        return null;
    }

    EObject getSelection(Object evaluationContext) {
        EObject result = null;
        Object value = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (value instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)value;
            result = selection.toList().stream().map(EMFHelper::getEObject).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return result;
    }

    public void setEnabled(Object evaluationContext) {
        boolean enabled = false;
        EObject selection = this.getSelection(evaluationContext);
        if (selection != null) {
            enabled = ControlModeManager.getInstance().canCreateSubmodel(selection) || SubmodelState.isIndependentSubmodel(selection);
        }
        this.setBaseEnabled(enabled);
    }
}

