/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.part;

import java.util.EventObject;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDragSourceListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.commands.util.OperationHistoryDirtyState;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.GmfMultiDiagramDocumentProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteContextMenuProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteViewer;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.uml.diagram.common.listeners.DropTargetListener;
import org.eclipse.papyrus.uml.diagram.common.part.UmlGmfDiagramEditor;
import org.eclipse.papyrus.uml.diagram.statemachine.part.DiagramEditorContextMenuProvider;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.ShowInContext;

public class UMLDiagramEditor
extends UmlGmfDiagramEditor
implements IProviderChangeListener,
IGotoMarker {
    public static final String ID = "org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorID";
    public static final String CONTEXT_ID = "org.eclipse.papyrus.uml.diagram.statemachine.ui.diagramContext";
    private KeyHandler paletteKeyHandler = null;
    private MouseListener paletteMouseListener = null;
    private OperationHistoryDirtyState dirtyState;
    private TransactionalEditingDomain editingDomain;
    private IDocumentProvider documentProvider;

    public UMLDiagramEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws ServiceException {
        super(servicesRegistry, diagram);
        PapyrusPaletteService.getInstance().addProviderChangeListener((IProviderChangeListener)this);
        this.editingDomain = (TransactionalEditingDomain)servicesRegistry.getService(TransactionalEditingDomain.class);
        this.documentProvider = new GmfMultiDiagramDocumentProvider(this.editingDomain);
        this.setDocumentProvider(this.documentProvider);
    }

    protected String getContextID() {
        return CONTEXT_ID;
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot paletteRoot;
        if (existingPaletteRoot == null) {
            paletteRoot = PapyrusPaletteService.getInstance().createPalette((IEditorPart)this, this.getDefaultPaletteContent());
        } else {
            PapyrusPaletteService.getInstance().updatePalette(existingPaletteRoot, (IEditorPart)this, this.getDefaultPaletteContent());
            paletteRoot = existingPaletteRoot;
        }
        this.applyCustomizationsToPalette(paletteRoot);
        return paletteRoot;
    }

    protected PreferencesHint getPreferencesHint() {
        return UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    public String getContributorId() {
        return "org.eclipse.papyrus.uml.diagram.statemachine";
    }

    protected final IDocumentProvider getDocumentProvider(IEditorInput input) {
        return this.documentProvider;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected final void setDocumentProvider(IEditorInput input) {
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), this.getGraphicalViewer().getSelection());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        DiagramEditorContextMenuProvider provider = new DiagramEditorContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
        this.getDiagramGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)this.getDiagramGraphicalViewer());
    }

    protected TransactionalEditingDomain createEditingDomain() {
        return this.editingDomain;
    }

    protected void configureDiagramEditDomain() {
        super.configureDiagramEditDomain();
        this.getDiagramEditDomain().getDiagramCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UMLDiagramEditor.this.firePropertyChange(257);
                        }
                    });
                } else {
                    UMLDiagramEditor.this.firePropertyChange(257);
                }
            }
        });
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.getDirtyState().saved();
    }

    protected OperationHistoryDirtyState getDirtyState() {
        if (this.dirtyState == null) {
            this.dirtyState = OperationHistoryDirtyState.newInstance((IUndoContext)this.getUndoContext(), (IOperationHistory)this.getOperationHistory());
        }
        return this.dirtyState;
    }

    protected void setUndoContext(IUndoContext context) {
        if (this.dirtyState != null) {
            this.dirtyState.dispose();
            this.dirtyState = null;
        }
        super.setUndoContext(context);
    }

    public boolean isDirty() {
        return this.getDirtyState().isDirty();
    }

    public void providerChanged(ProviderChangeEvent event) {
        if (PapyrusPaletteService.getInstance().equals(event.getSource())) {
            PapyrusPaletteService.getInstance().updatePalette(this.getPaletteViewer().getPaletteRoot(), (IEditorPart)this, this.getDefaultPaletteContent());
        }
    }

    public void dispose() {
        PapyrusPaletteService.getInstance().removeProviderChangeListener((IProviderChangeListener)this);
        if (this.dirtyState != null) {
            this.dirtyState.dispose();
            this.dirtyState = null;
        }
        super.dispose();
    }

    protected PaletteViewer getPaletteViewer() {
        return this.getEditDomain().getPaletteViewer();
    }

    protected PaletteViewer constructPaletteViewer() {
        return new PapyrusPaletteViewer();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        this.getEditDomain().setPaletteRoot(this.createPaletteRoot(null));
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setContextMenu((MenuManager)new PapyrusPaletteContextMenuProvider(viewer));
                viewer.getKeyHandler().setParent(this.getPaletteKeyHandler());
                viewer.getControl().addMouseListener(this.getPaletteMouseListener());
                viewer.addDragSourceListener((TransferDragSourceListener)new PaletteToolTransferDragSourceListener((EditPartViewer)viewer));
                viewer.setCustomizer(UMLDiagramEditor.this.createPaletteCustomizer());
            }

            public PaletteViewer createPaletteViewer(Composite parent) {
                PaletteViewer pViewer = UMLDiagramEditor.this.constructPaletteViewer();
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }

            private KeyHandler getPaletteKeyHandler() {
                if (UMLDiagramEditor.this.paletteKeyHandler == null) {
                    UMLDiagramEditor.this.paletteKeyHandler = new KeyHandler(){

                        public boolean keyReleased(KeyEvent event) {
                            if (event.keyCode == 13) {
                                Tool tool = UMLDiagramEditor.this.getPaletteViewer().getActiveTool().createTool();
                                if (UMLDiagramEditor.this.toolSupportsAccessibility(tool)) {
                                    tool.keyUp(event, (EditPartViewer)UMLDiagramEditor.this.getDiagramGraphicalViewer());
                                    UMLDiagramEditor.this.getPaletteViewer().setActiveTool(null);
                                    return true;
                                }
                            }
                            return super.keyReleased(event);
                        }
                    };
                }
                return UMLDiagramEditor.this.paletteKeyHandler;
            }

            private MouseListener getPaletteMouseListener() {
                if (UMLDiagramEditor.this.paletteMouseListener == null) {
                    UMLDiagramEditor.this.paletteMouseListener = new MouseListener(){
                        private boolean clearActiveTool = false;

                        public void mouseDoubleClick(MouseEvent e) {
                            Tool tool = UMLDiagramEditor.this.getPaletteViewer().getActiveTool().createTool();
                            if (UMLDiagramEditor.this.toolSupportsAccessibility(tool)) {
                                tool.setViewer((EditPartViewer)UMLDiagramEditor.this.getDiagramGraphicalViewer());
                                tool.setEditDomain(UMLDiagramEditor.this.getDiagramGraphicalViewer().getEditDomain());
                                tool.mouseDoubleClick(e, (EditPartViewer)UMLDiagramEditor.this.getDiagramGraphicalViewer());
                                this.clearActiveTool = true;
                            }
                        }

                        public void mouseDown(MouseEvent e) {
                        }

                        public void mouseUp(MouseEvent e) {
                            if (this.clearActiveTool) {
                                UMLDiagramEditor.this.getPaletteViewer().setActiveTool(null);
                                this.clearActiveTool = false;
                            }
                        }
                    };
                }
                return UMLDiagramEditor.this.paletteMouseListener;
            }
        };
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalSelectionTransfer.getTransfer()){

            protected Object getJavaObject(TransferData data) {
                return LocalSelectionTransfer.getTransfer().getSelection();
            }

            protected TransactionalEditingDomain getTransactionalEditingDomain() {
                return UMLDiagramEditor.this.getEditingDomain();
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getSite().getPage().getActiveEditor() instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)this.getSite().getPage().getActiveEditor();
            if (((Object)((Object)this)).equals(editor.getActiveEditor())) {
                this.updateActions(this.getSelectionActions());
                super.selectionChanged(part, selection);
            } else {
                super.selectionChanged(part, selection);
            }
        } else {
            super.selectionChanged(part, selection);
        }
        if (part == this) {
            this.rebuildStatusLine();
        }
    }
}

