/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.expressions.edit.internal.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeTreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Namespace) {
            Iterator namedElementIter = ((Namespace)parentElement).getOwnedMembers().iterator();
            ArrayList<NamedElement> children = new ArrayList<NamedElement>();
            while (namedElementIter.hasNext()) {
                NamedElement current = (NamedElement)namedElementIter.next();
                if (!this.isValid((EObject)current)) continue;
                children.add(current);
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Stereotype) {
            return false;
        }
        if (element instanceof EObject) {
            return this.isValid((EObject)element);
        }
        return false;
    }

    protected final boolean hasStereotypeInHierarchy(Package pack) {
        for (NamedElement current : pack.getOwnedMembers()) {
            if (!this.isValid((EObject)current)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValid(EObject eobject) {
        if (eobject instanceof Stereotype) {
            return true;
        }
        if (eobject instanceof Package) {
            return this.hasStereotypeInHierarchy((Package)eobject);
        }
        return false;
    }
}

