/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.php.refactoring.core.rename.INameUpdating;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.wizard.IQualifiedNameUpdating;
import org.eclipse.php.refactoring.ui.wizard.QualifiedNameComponent;
import org.eclipse.php.refactoring.ui.wizard.RowLayouter;
import org.eclipse.php.refactoring.ui.wizard.TextInputWizardPage;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

abstract class RenameInputWizardPage
extends TextInputWizardPage {
    private String fHelpContextID;
    private Button fUpdateTextualMatches;
    private Button fUpdateQualifiedNames;
    private QualifiedNameComponent fQualifiedNameComponent;
    private static final String UPDATE_TEXTUAL_MATCHES = "updateTextualMatches";
    private static final String UPDATE_QUALIFIED_NAMES = "updateQualifiedNames";

    public RenameInputWizardPage(String description, String contextHelpId, boolean isLastUserPage, String initialValue) {
        super(description, isLastUserPage, initialValue);
        this.fHelpContextID = contextHelpId;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        this.setControl((Control)superComposite);
        this.initializeDialogUnits((Control)superComposite);
        superComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        Text text = this.createTextInputField(composite);
        text.selectAll();
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gd);
        layouter.perform((Control)label, (Control)text, 1);
        Label separator = new Label(composite, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.heightHint = 2;
        separator.setLayoutData((Object)gridData);
        int indent = this.convertWidthInCharsToPixels(2);
        this.addAdditionalOptions(composite, layouter);
        this.addOptionalUpdateTextualMatches(composite, layouter);
        this.addOptionalUpdateQualifiedNameComponent(composite, layouter, indent);
        this.updateForcePreview();
        Dialog.applyDialogFont((Control)superComposite);
        this.getControl().setData("org.eclipse.ui.help", (Object)this.fHelpContextID);
        this.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent arg0) {
                Program.launch((String)RenameInputWizardPage.this.fHelpContextID);
            }
        });
    }

    protected void addAdditionalOptions(Composite composite, RowLayouter layouter) {
    }

    @Override
    public void setVisible(boolean visible) {
        String newName;
        INameUpdating nameUpdating;
        if (visible && (nameUpdating = (INameUpdating)this.getRefactoring().getAdapter(INameUpdating.class)) != null && (newName = this.getNewName(nameUpdating)) != null && newName.length() > 0 && !newName.equals(this.getInitialValue())) {
            Text textField = this.getTextField();
            textField.setText(newName);
            textField.setSelection(0, newName.length());
        }
        super.setVisible(visible);
    }

    protected String getNewName(INameUpdating nameUpdating) {
        return nameUpdating.getNewElementName();
    }

    protected boolean saveSettings() {
        if (this.getContainer() instanceof Dialog) {
            return ((Dialog)this.getContainer()).getReturnCode() == 0;
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.saveSettings()) {
            this.saveBooleanSetting(UPDATE_TEXTUAL_MATCHES, this.fUpdateTextualMatches);
            this.saveBooleanSetting(UPDATE_QUALIFIED_NAMES, this.fUpdateQualifiedNames);
            if (this.fQualifiedNameComponent != null) {
                this.fQualifiedNameComponent.savePatterns(this.getRefactoringSettings());
            }
        }
        super.dispose();
    }

    private void addOptionalUpdateTextualMatches(Composite result, RowLayouter layouter) {
        final ITextUpdating refactoring = (ITextUpdating)this.getRefactoring().getAdapter(ITextUpdating.class);
        if (refactoring == null || !refactoring.canEnableTextUpdating()) {
            return;
        }
        String title = PHPRefactoringUIMessages.getString("RenameInputWizardPage_update_textual_matches");
        boolean defaultValue = this.getBooleanSetting(UPDATE_TEXTUAL_MATCHES, refactoring.getUpdateTextualMatches());
        this.fUpdateTextualMatches = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateTextualMatches(this.fUpdateTextualMatches.getSelection());
        this.fUpdateTextualMatches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateTextualMatches(RenameInputWizardPage.this.fUpdateTextualMatches.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    private void addOptionalUpdateQualifiedNameComponent(Composite parent, RowLayouter layouter, int marginWidth) {
        final IQualifiedNameUpdating ref = (IQualifiedNameUpdating)this.getRefactoring().getAdapter(IQualifiedNameUpdating.class);
        if (ref == null || !ref.canEnableQualifiedNameUpdating()) {
            return;
        }
        this.fUpdateQualifiedNames = new Button(parent, 32);
        int indent = marginWidth + this.fUpdateQualifiedNames.computeSize((int)-1, (int)-1).x;
        this.fUpdateQualifiedNames.setText(PHPRefactoringUIMessages.getString("RenameInputWizardPage_update_qualified_names"));
        layouter.perform((Control)this.fUpdateQualifiedNames);
        this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, ref, this.getRefactoringSettings());
        layouter.perform((Control)this.fQualifiedNameComponent);
        GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = indent;
        boolean defaultSelection = this.getBooleanSetting(UPDATE_QUALIFIED_NAMES, ref.getUpdateQualifiedNames());
        this.fUpdateQualifiedNames.setSelection(defaultSelection);
        this.updateQulifiedNameUpdating(ref, defaultSelection);
        this.fUpdateQualifiedNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                RenameInputWizardPage.this.updateQulifiedNameUpdating(ref, enabled);
            }
        });
    }

    private void updateQulifiedNameUpdating(IQualifiedNameUpdating ref, boolean enabled) {
        this.fQualifiedNameComponent.setEnabled(enabled);
        ref.setUpdateQualifiedNames(enabled);
        this.updateForcePreview();
    }

    protected String getLabelText() {
        return PHPRefactoringUIMessages.getString("RenameInputWizardPage_new_name");
    }

    protected boolean getBooleanSetting(String key, boolean defaultValue) {
        String update = this.getRefactoringSettings().get(key);
        if (update != null) {
            return Boolean.valueOf(update);
        }
        return defaultValue;
    }

    protected void saveBooleanSetting(String key, Button checkBox) {
        if (checkBox != null) {
            this.getRefactoringSettings().put(key, checkBox.getSelection());
        }
    }

    protected static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        layouter.perform((Control)checkBox);
        return checkBox;
    }

    protected void updateForcePreview() {
        boolean forcePreview = false;
        Refactoring refactoring = this.getRefactoring();
        ITextUpdating tu = (ITextUpdating)refactoring.getAdapter(ITextUpdating.class);
        IQualifiedNameUpdating qu = (IQualifiedNameUpdating)refactoring.getAdapter(IQualifiedNameUpdating.class);
        if (tu != null) {
            forcePreview = tu.getUpdateTextualMatches();
        }
        if (qu != null) {
            forcePreview |= qu.getUpdateQualifiedNames();
        }
        this.getRefactoringWizard().setForcePreviewReview(forcePreview);
    }
}

