/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.ptp.internal.rm.lml.core.model.Pattern;
import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.IPattern;
import org.eclipse.ptp.rm.lml.core.model.ITableColumnLayout;
import org.eclipse.ptp.rm.lml.ui.providers.FilterDataRow;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterDialog
extends Dialog {
    private FilterDataRow[] filterData;
    private final ILguiItem lguiItem = LMLManager.getInstance().getSelectedLguiItem();
    private final String gid;
    private final Shell shell;
    private boolean filtered = false;
    private final List<IPattern> filterOld;

    public FilterDialog(Shell parentShell, String gid) {
        super(parentShell);
        this.gid = gid;
        this.filterOld = this.lguiItem.getTableHandler().getPattern(gid);
        this.shell = parentShell;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            if (this.filtered) {
                LMLManager.getInstance().filterLgui(this.gid, new LinkedList());
            }
            this.close();
            return;
        }
        boolean error = false;
        FilterDataRow[] filterDataRowArray = this.filterData;
        int n = this.filterData.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDataRow row = filterDataRowArray[n2];
            if (row.isCheckboxSet()) {
                if (row.getType().equals("alpha")) {
                    if (row.getRelationValueTextAlpha().getText().equals("") || row.getRelationValueTextAlpha().getText().equals("?")) {
                        error = true;
                        break;
                    }
                } else if (row.getRadioButtonRelation().getSelection()) {
                    if (row.getType().equals("numeric")) {
                        if (row.getRelationValueTextNumeric().getText().equals("")) {
                            error = true;
                            break;
                        }
                    } else if (row.getType().equals("date") && row.getRelationValueButtonDate().getText().equals("")) {
                        error = true;
                        break;
                    }
                } else if (row.getRadioButtonRange().getSelection()) {
                    if (row.getType().equals("numeric")) {
                        if (row.getMinValueTextNumeric().getText().equals("") || row.getMaxValueTextNumeric().equals("") || Integer.parseInt(row.getMinValueTextNumeric().getText()) >= Integer.parseInt(row.getMaxValueTextNumeric().getText())) {
                            error = true;
                            break;
                        }
                    } else if (row.getType().equals("date") && (row.getMinValueButtonDate().getText().equals("") || row.getMaxValueButtonDate().equals("") || row.getMinValueButtonDate().getText().compareTo(row.getMaxValueButtonDate().getText()) >= 0)) {
                        error = true;
                        break;
                    }
                }
            }
            ++n2;
        }
        if (error) {
            Status status = new Status(4, Messages.FilterDialog_Missing_arguments, 0, Messages.FilterDialog_Missing_arguments_message, null);
            ErrorDialog dialog = new ErrorDialog(this.shell, Messages.FilterDialog_Missing_arguments, Messages.FilterDialog_An_error_occurred, (IStatus)status, 4);
            dialog.open();
            return;
        }
        LinkedList<Pattern> filterValues = new LinkedList<Pattern>();
        FilterDataRow[] filterDataRowArray2 = this.filterData;
        int n3 = this.filterData.length;
        n = 0;
        while (n < n3) {
            FilterDataRow row = filterDataRowArray2[n];
            boolean complete = false;
            if (row.isCheckboxSet()) {
                Pattern pattern = new Pattern(row.getTitle(), row.getType());
                if (row.getType().equals("alpha")) {
                    pattern.setRelation(row.getRelationComboAlpha().getText(), row.getRelationValueTextAlpha().getText());
                    complete = true;
                } else if (row.getRadioButtonRelation().getSelection()) {
                    if (row.getType().equals("numeric")) {
                        pattern.setRelation(row.getRelationComboNumericDate().getText(), row.getRelationValueTextNumeric().getText());
                        complete = true;
                    } else if (row.getType().equals("date")) {
                        pattern.setRelation(row.getRelationComboNumericDate().getText(), row.getRelationValueButtonDate().getText());
                        complete = true;
                    }
                } else if (row.getRadioButtonRange().getSelection()) {
                    if (row.getType().equals("numeric")) {
                        pattern.setRange(row.getMinValueTextNumeric().getText(), row.getMaxValueTextNumeric().getText());
                        complete = true;
                    } else if (row.getType().equals("numeric")) {
                        pattern.setRange(row.getMinValueButtonDate().getText(), row.getMaxValueButtonDate().getText());
                        complete = true;
                    }
                }
                if (complete) {
                    filterValues.add(pattern);
                }
            }
            ++n;
        }
        if (buttonId == 0 && this.lguiItem != null && this.lguiItem.getTableHandler() != null) {
            this.lguiItem.lockPattern();
            this.lguiItem.getTableHandler().deleteOldPattern(this.gid);
            this.lguiItem.getTableHandler().generateNewPattern(this.gid, filterValues);
            this.lguiItem.unlockPattern();
        }
        this.filtered = true;
        LMLManager.getInstance().filterLgui(this.gid, filterValues);
        if (buttonId == 0) {
            this.close();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FilterDialog_Filters);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 5, Messages.FilterDialog_Apply, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        GridDataFactory.swtDefaults().align(4, 4).hint(-1, -1).grab(true, true).applyTo((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        boolean error = false;
        if (this.lguiItem == null || this.lguiItem.getTableHandler() == null) {
            error = true;
        }
        ITableColumnLayout[] columnLayouts = new ITableColumnLayout[]{};
        if (!error) {
            columnLayouts = this.lguiItem.getTableHandler().getActiveTableColumnLayout(this.gid);
        }
        if (columnLayouts.length == 0) {
            error = true;
        }
        if (error) {
            Label errorLabel = new Label(composite, 0);
            errorLabel.setText(Messages.FilterDialog_An_error_occurred);
            this.filterData = new FilterDataRow[0];
            return composite;
        }
        this.filterData = new FilterDataRow[columnLayouts.length];
        VerifyListener numericListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String s = String.valueOf(((Text)e.widget).getText()) + e.text;
                e.doit = s.matches("0|([1-9][0-9]*)");
            }
        };
        VerifyListener alphaListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String s = String.valueOf(((Text)e.widget).getText()) + e.text;
                e.doit = s.matches(".+");
            }
        };
        composite.setLayout((Layout)new GridLayout(2, false));
        int i = 0;
        while (i < columnLayouts.length) {
            String type = columnLayouts[i].getOrder();
            final Button checkbox = new Button(composite, 32);
            checkbox.setText(columnLayouts[i].getTitle());
            checkbox.setLayoutData((Object)new GridData());
            final FilterDataRow row = new FilterDataRow(type, checkbox);
            if (type == "alpha") {
                Composite compositeText = new Composite(composite, 0);
                compositeText.setLayout((Layout)new GridLayout(2, false));
                Combo relationCombo = new Combo(compositeText, 8);
                relationCombo.setItems(new String[]{"=", "!=", "=~", "!~"});
                relationCombo.select(0);
                relationCombo.setLayoutData((Object)new GridData());
                relationCombo.setEnabled(false);
                row.addRelationComboAlpha(relationCombo);
                Text relationValue = new Text(compositeText, 16388);
                relationValue.setEnabled(false);
                relationValue.addVerifyListener(alphaListener);
                relationValue.setLayoutData((Object)new GridData(768));
                row.addRelationValueAlpha(relationValue);
                compositeText.setLayoutData((Object)new GridData(768));
            } else {
                Label labelMinus;
                Composite compositeRadio = new Composite(composite, 0);
                compositeRadio.setLayout((Layout)new GridLayout(2, false));
                final Button radioButtonRelation = new Button(compositeRadio, 16);
                radioButtonRelation.setLayoutData((Object)new GridData());
                radioButtonRelation.setSelection(true);
                radioButtonRelation.setEnabled(false);
                row.addRadioRelation(radioButtonRelation);
                Composite compositeRelation = new Composite(compositeRadio, 0);
                compositeRelation.setLayout((Layout)new GridLayout(2, false));
                Combo relations = new Combo(compositeRelation, 8);
                relations.setItems(new String[]{"=", "<", "<=", ">", ">=", "!="});
                relations.select(0);
                relations.setEnabled(false);
                relations.setLayoutData((Object)new GridData(4));
                row.addRelationComboNumericDate(relations);
                if (type == "numeric") {
                    Text relationValueText = new Text(compositeRelation, 131076);
                    relationValueText.addVerifyListener(numericListener);
                    relationValueText.setEnabled(false);
                    relationValueText.setLayoutData((Object)new GridData(768));
                    row.addRelationValueNumeric(relationValueText);
                } else {
                    Button relationValueButton = new Button(compositeRelation, 0);
                    relationValueButton.setEnabled(false);
                    relationValueButton.setLayoutData((Object)new GridData(768));
                    relationValueButton.addSelectionListener((SelectionListener)new SelectDateAdpater(relationValueButton));
                    row.addRelationValueDate(relationValueButton);
                }
                radioButtonRelation.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean selected = radioButtonRelation.getSelection();
                        if (row.getRelationComboNumericDate() != null) {
                            row.getRelationComboNumericDate().setEnabled(selected);
                        }
                        if (row.getRelationValueTextNumeric() != null) {
                            row.getRelationValueTextNumeric().setEnabled(selected);
                        }
                        if (row.getRelationValueButtonDate() != null) {
                            row.getRelationValueButtonDate().setEnabled(selected);
                        }
                    }
                });
                compositeRelation.setLayoutData((Object)new GridData(768));
                final Button radioButtonRange = new Button(compositeRadio, 16);
                radioButtonRange.setEnabled(false);
                radioButtonRange.setLayoutData((Object)new GridData());
                row.addRadioRange(radioButtonRange);
                Composite compositeRange = new Composite(compositeRadio, 0);
                compositeRange.setLayout((Layout)new GridLayout(3, false));
                if (type == "numeric") {
                    Text textValueMin = new Text(compositeRange, 131076);
                    textValueMin.setLayoutData((Object)new GridData(768));
                    textValueMin.setEnabled(false);
                    textValueMin.addVerifyListener(numericListener);
                    labelMinus = new Label(compositeRange, 0);
                    labelMinus.setText(" - ");
                    labelMinus.setLayoutData((Object)new GridData(4));
                    Text textValueMax = new Text(compositeRange, 131076);
                    textValueMax.setLayoutData((Object)new GridData(768));
                    textValueMax.setEnabled(false);
                    textValueMax.addVerifyListener(numericListener);
                    row.addMinValueNumeric(textValueMin);
                    row.addMaxValueNumeric(textValueMax);
                } else {
                    Button buttonValueMin = new Button(compositeRange, 0);
                    buttonValueMin.setEnabled(false);
                    buttonValueMin.setLayoutData((Object)new GridData(768));
                    labelMinus = new Label(compositeRange, 0);
                    labelMinus.setText(" - ");
                    labelMinus.setLayoutData((Object)new GridData(4));
                    Button buttonValueMax = new Button(compositeRange, 0);
                    buttonValueMax.setEnabled(false);
                    buttonValueMax.setLayoutData((Object)new GridData(768));
                    buttonValueMin.addSelectionListener((SelectionListener)new SelectDateAdpater(buttonValueMin, buttonValueMax));
                    buttonValueMax.addSelectionListener((SelectionListener)new SelectDateAdpater(buttonValueMax, buttonValueMin));
                    row.addMinValueDate(buttonValueMin);
                    row.addMaxValueDate(buttonValueMax);
                }
                radioButtonRange.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean selected = radioButtonRange.getSelection();
                        if (row.getMinValueTextNumeric() != null && row.getMaxValueTextNumeric() != null) {
                            row.getMinValueTextNumeric().setEnabled(selected);
                            row.getMaxValueTextNumeric().setEnabled(selected);
                        }
                        if (row.getMinValueButtonDate() != null && row.getMaxValueButtonDate() != null) {
                            row.getMinValueButtonDate().setEnabled(selected);
                            row.getMaxValueButtonDate().setEnabled(selected);
                        }
                    }
                });
                compositeRange.setLayoutData((Object)new GridData(768));
                compositeRadio.setLayoutData((Object)new GridData(768));
            }
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = checkbox.getSelection();
                    if (row.getRelationValueTextAlpha() != null) {
                        row.getRelationValueTextAlpha().setEnabled(selected);
                    }
                    if (row.getRelationComboAlpha() != null) {
                        row.getRelationComboAlpha().setEnabled(selected);
                    }
                    if (row.getRadioButtonRelation() != null && row.getRadioButtonRange() != null) {
                        row.getRadioButtonRelation().setEnabled(selected);
                        row.getRadioButtonRange().setEnabled(checkbox.getSelection());
                        if (row.getRadioButtonRelation().getSelection()) {
                            if (row.getRelationComboNumericDate() != null) {
                                row.getRelationComboNumericDate().setEnabled(selected);
                            }
                            if (row.getRelationValueTextNumeric() != null) {
                                row.getRelationValueTextNumeric().setEnabled(selected);
                            }
                            if (row.getRelationValueButtonDate() != null) {
                                row.getRelationValueButtonDate().setEnabled(selected);
                            }
                        } else {
                            if (row.getMinValueTextNumeric() != null && row.getMaxValueTextNumeric() != null) {
                                row.getMinValueTextNumeric().setEnabled(selected);
                                row.getMaxValueTextNumeric().setEnabled(selected);
                            }
                            if (row.getMinValueButtonDate() != null && row.getMaxValueButtonDate() != null) {
                                row.getMinValueButtonDate().setEnabled(selected);
                                row.getMaxValueButtonDate().setEnabled(selected);
                            }
                        }
                    }
                }
            });
            if (this.filterOld.size() > 0) {
                for (IPattern filter : this.filterOld) {
                    String[] items;
                    if (!filter.getColumnTitle().equals(row.getTitle())) continue;
                    row.getCheckbox().setSelection(true);
                    if (filter.getType().equals("alpha")) {
                        row.getRelationValueTextAlpha().setText(filter.getRelationValue());
                        row.getRelationValueTextAlpha().setEnabled(true);
                        items = row.getRelationComboAlpha().getItems();
                        row.getRelationComboAlpha().setEnabled(true);
                        int j = 0;
                        while (j < items.length) {
                            if (filter.getRelationOperator().equals(items[j])) {
                                row.getRelationComboAlpha().select(j);
                            }
                            ++j;
                        }
                        continue;
                    }
                    row.getRadioButtonRange().setEnabled(true);
                    row.getRadioButtonRelation().setEnabled(true);
                    if (filter.isRange()) {
                        row.getRadioButtonRange().setSelection(true);
                        row.getRadioButtonRelation().setSelection(false);
                        if (filter.getType().equals("numeric")) {
                            row.getMinValueTextNumeric().setText(filter.getMinValueRange());
                            row.getMaxValueTextNumeric().setText(filter.getMaxValueRange());
                            row.getMinValueTextNumeric().setEnabled(true);
                            row.getMaxValueTextNumeric().setEnabled(true);
                            continue;
                        }
                        row.getMinValueButtonDate().setText(filter.getMinValueRange());
                        row.getMaxValueButtonDate().setText(filter.getMaxValueRange());
                        row.getMinValueButtonDate().setEnabled(true);
                        row.getMaxValueButtonDate().setEnabled(true);
                        continue;
                    }
                    if (!filter.isRelation()) continue;
                    row.getRadioButtonRelation().setSelection(true);
                    row.getRelationComboNumericDate().setEnabled(true);
                    items = row.getRelationComboNumericDate().getItems();
                    int j = 0;
                    while (j < items.length) {
                        if (filter.getRelationOperator().equals(items[j])) {
                            row.getRelationComboNumericDate().select(j);
                        }
                        ++j;
                    }
                    if (filter.getType().equals("numeric")) {
                        row.getRelationValueTextNumeric().setText(filter.getRelationValue());
                        row.getRelationValueTextNumeric().setEnabled(true);
                        continue;
                    }
                    row.getRelationValueButtonDate().setText(filter.getRelationValue());
                    row.getRelationValueButtonDate().setEnabled(true);
                }
            }
            if ((this.gid.equals("org.eclipse.ptp.rm.lml.ui.ActiveJobsView") || this.gid.equals("org.eclipse.ptp.rm.lml.ui.InactiveJobsView")) && columnLayouts[i].getTitle().equals("status")) {
                row.getCheckbox().setEnabled(false);
                row.getRelationComboAlpha().setEnabled(false);
                row.getRelationValueTextAlpha().setEnabled(false);
            }
            this.filterData[i] = row;
            ++i;
        }
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        scrolledComposite.setSize(100, 400);
        return scrolledComposite;
    }

    public class SelectDateAdpater
    extends SelectionAdapter {
        private final Button button;
        private String date;
        private Button comparisonButton = null;

        public SelectDateAdpater(Button button) {
            this.button = button;
            this.date = button.getText() == null ? new String() : button.getText();
        }

        public SelectDateAdpater(Button button, Button comparisonButton) {
            this.button = button;
            this.comparisonButton = comparisonButton;
            this.date = comparisonButton.getText();
        }

        public void widgetSelected(SelectionEvent e) {
            final Shell dialog = new Shell(FilterDialog.this.shell, 67680);
            dialog.setLayout((Layout)new GridLayout(5, false));
            if (this.button.getText().length() == 0 && this.comparisonButton != null && this.comparisonButton.getText().length() > 0) {
                this.date = this.comparisonButton.getText();
            }
            final DateTime calendar = new DateTime((Composite)dialog, 3072);
            final DateTime time = new DateTime((Composite)dialog, 128);
            calendar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
            time.setLayoutData((Object)new GridData());
            Button ok = new Button((Composite)dialog, 8);
            ok.setText(Messages.FilterDialog_OK);
            ok.setLayoutData((Object)new GridData(768));
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DecimalFormat formatter = new DecimalFormat("00");
                    SelectDateAdpater.this.button.setText(String.valueOf(calendar.getYear()) + "-" + formatter.format(calendar.getMonth() + 1) + "-" + formatter.format(calendar.getDay()) + " " + formatter.format(time.getHours()) + ":" + formatter.format(time.getMinutes()) + ":" + formatter.format(time.getSeconds()));
                    SelectDateAdpater.this.date = SelectDateAdpater.this.button.getText();
                    dialog.close();
                }
            });
            Button delete = new Button((Composite)dialog, 8);
            delete.setText(Messages.FilterDialog_Delete);
            delete.setLayoutData((Object)new GridData(768));
            delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectDateAdpater.this.button.setText("");
                    SelectDateAdpater.this.date = new String();
                    dialog.close();
                }
            });
            Button cancel = new Button((Composite)dialog, 8);
            cancel.setText(Messages.FilterDialog_Cancel);
            cancel.setLayoutData((Object)new GridData(768));
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    dialog.close();
                }
            });
            if (!this.date.isEmpty()) {
                calendar.setDate(Integer.valueOf(this.date.substring(0, 4)).intValue(), Integer.valueOf(this.date.substring(5, 7)) - 1, Integer.valueOf(this.date.substring(8, 10)).intValue());
                time.setTime(Integer.valueOf(this.date.substring(11, 13)).intValue(), Integer.valueOf(this.date.substring(14, 16)).intValue(), Integer.valueOf(this.date.substring(17)).intValue());
            }
            dialog.setDefaultButton(ok);
            dialog.pack();
            dialog.open();
        }
    }
}

