/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.ui.IJobManager;
import org.eclipse.ptp.internal.ui.PTPUIDebugOptions;
import org.eclipse.ptp.internal.ui.managers.JobManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.ui";
    public static final String RUNTIME_MODEL_PRESENTATION_EXTENSION_POINT_ID = "runtimeModelPresentations";
    private static PTPUIPlugin plugin;
    private IJobManager jobManager = null;

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPUIPlugin getDefault() {
        return plugin;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getUniqueIdentifier() {
        if (PTPUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        PTPUIPlugin.log((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPUIPlugin.log((IStatus)new Status(4, PTPUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public PTPUIPlugin() {
        plugin = this;
    }

    public IJobManager getJobManager() {
        if (this.jobManager == null) {
            this.jobManager = new JobManager();
        }
        return this.jobManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PTPUIDebugOptions.configure(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getJobManager().shutdown();
        this.jobManager = null;
        plugin = null;
    }
}

