/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.serviceproject;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.NlsType;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class NlsServiceType
extends NlsType {
    private static final Pattern REGEX_RESOURCE_BUNDLE_GETTER = Pattern.compile("return\\s*\\\"([^\\\"]*)\\\"\\s*\\;", 32);
    public static final String DYNAMIC_NLS_BASE_NAME_GETTER = "getDynamicNlsBaseName";

    public NlsServiceType(IType serviceType) {
        super(serviceType);
    }

    @Override
    protected void loadSuperTypeHierarchy() throws JavaModelException {
    }

    @Override
    protected String getBundleValue() throws JavaModelException {
        IMethod getter = this.m_type.getMethod(DYNAMIC_NLS_BASE_NAME_GETTER, new String[0]);
        if (!S2eUtils.exists((IJavaElement)getter)) {
            return null;
        }
        String source = getter.getSource();
        if (source == null) {
            return null;
        }
        Matcher matcher = REGEX_RESOURCE_BUNDLE_GETTER.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

