/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.services.filetransfer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;

public class FileTransferItem
extends PropertiesContainer
implements IFileTransferItem {
    private boolean fPatchingSetProperty;

    public FileTransferItem() {
        this.setProperty("enabled", true);
        this.setProperty("direction", "1");
    }

    public FileTransferItem(IPath fromHost, boolean enabled) {
        this();
        if (fromHost != null) {
            this.setProperty("host", fromHost.toPortableString());
        }
        this.setProperty("enabled", enabled);
    }

    @Deprecated
    public FileTransferItem(IPath fromHost, IPath toTarget) {
        this();
        if (fromHost != null) {
            this.setProperty("host", fromHost.toPortableString());
        }
        if (toTarget != null) {
            this.setProperty("target", toTarget.toPortableString());
        }
    }

    public FileTransferItem(IPath fromHost, String toTarget) {
        this();
        if (fromHost != null) {
            this.setProperty("host", fromHost.toPortableString());
        }
        if (toTarget != null) {
            this.setProperty("target-string", toTarget);
        }
    }

    private String normalizeTargetPath(Object tgtPath) {
        if (tgtPath == null) {
            return null;
        }
        String path = String.valueOf(tgtPath);
        if ((path = path.replaceAll("/+", "/")).endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean setProperty(String key, Object value) {
        if (!this.fPatchingSetProperty) {
            try {
                this.fPatchingSetProperty = true;
                if ("target".equals(key)) {
                    this.setProperty("target-string", this.pathToString(value));
                    boolean bl = this.setProperty("target", value);
                    return bl;
                }
                if ("target-string".equals(key)) {
                    value = this.normalizeTargetPath(value);
                    this.setProperty("target", this.stringToPath(value));
                    boolean bl = this.setProperty("target-string", value);
                    return bl;
                }
            }
            finally {
                this.fPatchingSetProperty = false;
            }
        }
        return super.setProperty(key, value);
    }

    public final void setProperties(Map<String, Object> properties) {
        if (properties.containsKey("target")) {
            if (!properties.containsKey("target-string")) {
                properties = new HashMap<String, Object>(properties);
                properties.put("target-string", this.pathToString(properties.get("target")));
            }
        } else if (properties.containsKey("target-string")) {
            properties = new HashMap<String, Object>(properties);
            properties.put("target", this.stringToPath(properties.get("target-string")));
        }
        super.setProperties(properties);
    }

    private String pathToString(Object value) {
        if (value == null) {
            return null;
        }
        return Path.fromPortableString((String)String.valueOf(value)).toString();
    }

    private String stringToPath(Object value) {
        if (value == null) {
            return null;
        }
        return new Path(String.valueOf(value)).toPortableString();
    }

    @Override
    public boolean isEnabled() {
        return this.getBooleanProperty("enabled");
    }

    @Override
    public IPath getHostPath() {
        return this.getStringProperty("host") != null ? new Path(this.getStringProperty("host")) : null;
    }

    @Override
    @Deprecated
    public IPath getTargetPath() {
        if (this.getStringProperty("target") != null) {
            return new Path(this.getStringProperty("target"));
        }
        if (this.getStringProperty("target-string") != null) {
            return new Path(this.getStringProperty("target-string"));
        }
        return null;
    }

    @Override
    public String getTargetPathString() {
        return this.getStringProperty("target-string");
    }

    @Override
    public int getDirection() {
        int direction = this.getIntProperty("direction");
        return direction == 2 ? 2 : 1;
    }

    @Override
    public String getOptions() {
        return this.getStringProperty("options");
    }

    public int hashCode() {
        int hc = this.getHostPath() != null ? this.getHostPath().hashCode() : 0;
        hc <<= 8 + (this.getTargetPathString() != null ? this.getTargetPathString().hashCode() : 0);
        return hc <<= 8 + this.getDirection();
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals && obj instanceof IFileTransferItem) {
            boolean directionEqual;
            boolean hostPathEqual;
            boolean bl = this.getHostPath() != null ? this.getHostPath().equals((Object)((IFileTransferItem)obj).getHostPath()) : (hostPathEqual = ((IFileTransferItem)obj).getHostPath() == null);
            boolean targetPathEqual = this.getTargetPathString() != null ? this.getTargetPathString().equals(((IFileTransferItem)obj).getTargetPathString()) : ((IFileTransferItem)obj).getTargetPathString() == null;
            boolean bl2 = directionEqual = this.getDirection() == ((IFileTransferItem)obj).getDirection();
            return hostPathEqual && targetPathEqual && directionEqual;
        }
        return equals;
    }
}

