/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.team.internal.ccvs.core.CVSProjectSetCapability;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class CVSRepositoryLocationMatcher {
    private static final String EXTSSH = "extssh";
    private static final String PSERVER = "pserver";
    private static final String EXT = "ext";
    private static Comparator<ICVSRepositoryLocation> COMPATIBLE_LOCATIONS_COMPARATOR = (rl1, rl2) -> {
        String name2;
        String name1 = rl1.getMethod().getName();
        if (!name1.equals(name2 = rl2.getMethod().getName()) && CVSRepositoryLocationMatcher.isCompatible(rl1, rl2, false)) {
            if (name1.equals(EXTSSH)) {
                return -1;
            }
            if (name2.equals(EXTSSH)) {
                return 1;
            }
            if (name1.equals(PSERVER)) {
                return -1;
            }
            if (name2.equals(PSERVER)) {
                return 1;
            }
            if (name1.equals(EXT)) {
                return -1;
            }
            if (name2.equals(EXT)) {
                return 1;
            }
        }
        return name1.compareTo(name2);
    };

    public static Map<IProject, List<ICVSRepositoryLocation>> prepareSuggestedRepositoryLocations(IProject[] projects, Map<IProject, CVSProjectSetCapability.LoadInfo> infoMap) {
        HashMap<IProject, List<ICVSRepositoryLocation>> result;
        List<IProject> confirmedProjectsList = Arrays.asList(projects);
        HashSet<ICVSRepositoryLocation> projectSetRepositoryLocations = new HashSet<ICVSRepositoryLocation>();
        for (IProject project : infoMap.keySet()) {
            if (!confirmedProjectsList.contains(project)) continue;
            CVSProjectSetCapability.LoadInfo loadInfo = infoMap.get(project);
            projectSetRepositoryLocations.add(loadInfo.repositoryLocation);
        }
        if (projectSetRepositoryLocations.isEmpty()) {
            return null;
        }
        List<ICVSRepositoryLocation> knownRepositories = Arrays.asList(KnownRepositories.getInstance().getRepositories());
        if (knownRepositories.isEmpty()) {
            result = new HashMap<IProject, List<ICVSRepositoryLocation>>();
            for (ICVSRepositoryLocation projectSetRepositoryLocation : projectSetRepositoryLocations) {
                ArrayList<ICVSRepositoryLocation> list = new ArrayList<ICVSRepositoryLocation>(1);
                list.add(projectSetRepositoryLocation);
                result.put((IProject)projectSetRepositoryLocation, list);
            }
            return result;
        }
        if (knownRepositories.containsAll(projectSetRepositoryLocations)) {
            return Collections.emptyMap();
        }
        result = new HashMap();
        for (ICVSRepositoryLocation projectSetRepositoryLocation : projectSetRepositoryLocations) {
            ArrayList<ICVSRepositoryLocation> matching = new ArrayList<ICVSRepositoryLocation>();
            ArrayList<ICVSRepositoryLocation> compatible = new ArrayList<ICVSRepositoryLocation>();
            ArrayList<ICVSRepositoryLocation> list = new ArrayList<ICVSRepositoryLocation>();
            for (ICVSRepositoryLocation knownRepositoryLocation : knownRepositories) {
                if (CVSRepositoryLocationMatcher.isMatching(projectSetRepositoryLocation, knownRepositoryLocation)) {
                    matching.add(knownRepositoryLocation);
                    continue;
                }
                if (CVSRepositoryLocationMatcher.isCompatible(knownRepositoryLocation, projectSetRepositoryLocation, false)) {
                    compatible.add(knownRepositoryLocation);
                    continue;
                }
                list.add(knownRepositoryLocation);
            }
            Collections.sort(compatible, COMPATIBLE_LOCATIONS_COMPARATOR);
            list.addAll(0, compatible);
            if (matching.isEmpty()) {
                list.add(0, projectSetRepositoryLocation);
            } else {
                if (matching.size() == 1) {
                    list.clear();
                    list.addAll(matching);
                    result.put((IProject)projectSetRepositoryLocation, list);
                    continue;
                }
                list.addAll(0, matching);
            }
            result.put((IProject)projectSetRepositoryLocation, list);
        }
        return result;
    }

    public static boolean isCompatible(ICVSRepositoryLocation location1, ICVSRepositoryLocation location2, boolean equalIsCompatible) {
        if (!location1.getHost().equals(location2.getHost())) {
            return false;
        }
        if (!location1.getRootDirectory().equals(location2.getRootDirectory())) {
            return false;
        }
        return equalIsCompatible || !location1.equals(location2);
    }

    public static boolean isMatching(ICVSRepositoryLocation location1, ICVSRepositoryLocation location2) {
        return CVSRepositoryLocationMatcher.isCompatible(location1, location2, true) && location2.getMethod() == location1.getMethod() && location2.getPort() == location1.getPort();
    }

    static boolean isPromptRequired(Map suggestedRepositoryLocations) {
        if (suggestedRepositoryLocations == null) {
            return false;
        }
        for (List list : suggestedRepositoryLocations.values()) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

