/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;

public class JobInfo
extends JobTreeElement {
    private IStatus blockedStatus;
    private volatile boolean canceled;
    private final Queue<JobTreeElement> children = new ConcurrentLinkedQueue<JobTreeElement>();
    private final Job job;
    private GroupInfo parent;
    private TaskInfo taskInfo;
    private int ticks = -1;

    protected JobInfo(Job enclosingJob) {
        this.job = enclosingJob;
    }

    void addSubTask(String subTaskName) {
        this.children.add(new SubTaskInfo(this, subTaskName));
    }

    void addWork(double workIncrement) {
        if (this.taskInfo == null) {
            return;
        }
        if (this.parent == null || this.ticks < 1) {
            this.taskInfo.addWork(workIncrement);
        } else {
            this.taskInfo.addWork(workIncrement, this.parent, this.ticks);
        }
    }

    void beginTask(String taskName, int work) {
        this.taskInfo = new TaskInfo(this, taskName, work);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.job.cancel();
        ProgressManager.getInstance().refreshJobInfo(this);
    }

    void clearChildren() {
        this.children.clear();
    }

    void clearTaskInfo() {
        FinishedJobs.getInstance().remove(this.taskInfo);
        this.taskInfo = null;
    }

    private int compareJobs(JobInfo jobInfo) {
        int otherPriority;
        int thisPriority;
        Job job2 = jobInfo.getJob();
        if (this.job.isUser()) {
            if (!job2.isUser()) {
                return -1;
            }
        } else if (job2.isUser()) {
            return 1;
        }
        if (this.isBlocked()) {
            if (!jobInfo.isBlocked()) {
                return 1;
            }
        } else if (jobInfo.isBlocked()) {
            return -1;
        }
        if ((thisPriority = this.job.getPriority()) == (otherPriority = job2.getPriority())) {
            return this.job.getName().compareTo(job2.getName());
        }
        if (thisPriority > otherPriority) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(JobTreeElement other) {
        int anotherState;
        if (!(other instanceof JobInfo)) {
            return super.compareTo(other);
        }
        JobInfo element = (JobInfo)other;
        boolean thisCanceled = this.isCanceled();
        boolean anotherCanceled = element.isCanceled();
        if (thisCanceled && !anotherCanceled) {
            return 1;
        }
        if (!thisCanceled && anotherCanceled) {
            return -1;
        }
        int thisState = this.getJob().getState();
        if (thisState == (anotherState = element.getJob().getState())) {
            return this.compareJobs(element);
        }
        return Integer.compare(anotherState, thisState);
    }

    void dispose() {
        if (this.parent != null) {
            this.parent.removeJobInfo(this);
        }
    }

    public IStatus getBlockedStatus() {
        return this.blockedStatus;
    }

    @Override
    Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    String getCondensedDisplayString() {
        TaskInfo info = this.getTaskInfo();
        if (info != null) {
            return info.getDisplayStringWithoutTask(true);
        }
        return this.getJob().getName();
    }

    @Override
    public Image getDisplayImage() {
        int done = this.getPercentDone();
        if (done > 0) {
            return super.getDisplayImage();
        }
        if (this.isBlocked()) {
            return JFaceResources.getImage((String)"LOCKED_JOB");
        }
        int state = this.getJob().getState();
        if (state == 1) {
            return JFaceResources.getImage((String)"SLEEPING_JOB");
        }
        if (state == 2) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        return super.getDisplayImage();
    }

    @Override
    String getDisplayString() {
        return this.getDisplayString(true);
    }

    @Override
    String getDisplayString(boolean showProgress) {
        String name = this.getDisplayStringWithStatus(showProgress);
        if (this.job.isSystem()) {
            return NLS.bind((String)ProgressMessages.JobInfo_System, (Object[])new Object[]{name});
        }
        return name;
    }

    private String getDisplayStringWithStatus(boolean showProgress) {
        if (this.isCanceled()) {
            return NLS.bind((String)ProgressMessages.JobInfo_Cancelled, (Object[])new Object[]{this.getJob().getName()});
        }
        IStatus blocked = this.getBlockedStatus();
        if (blocked != null) {
            return NLS.bind((String)ProgressMessages.JobInfo_Blocked, (Object[])new Object[]{this.getJob().getName(), blocked.getMessage()});
        }
        if (this.getJob().getState() == 4) {
            TaskInfo info = this.getTaskInfo();
            if (info == null) {
                return this.getJob().getName();
            }
            return info.getDisplayString(showProgress);
        }
        if (this.getJob().getState() == 1) {
            return NLS.bind((String)ProgressMessages.JobInfo_Sleeping, (Object[])new Object[]{this.getJob().getName()});
        }
        return NLS.bind((String)ProgressMessages.JobInfo_Waiting, (Object[])new Object[]{this.getJob().getName()});
    }

    GroupInfo getGroupInfo() {
        if (this.parent != null) {
            return this.parent;
        }
        return null;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public GroupInfo getParent() {
        return this.parent;
    }

    int getPercentDone() {
        TaskInfo info = this.getTaskInfo();
        if (info != null) {
            if (info.totalWork == -1) {
                return -1;
            }
            if (info.totalWork == 0) {
                return 0;
            }
            return (int)info.preWork * 100 / info.totalWork;
        }
        return -1;
    }

    TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    @Override
    boolean hasChildren() {
        return !this.children.isEmpty();
    }

    boolean hasTaskInfo() {
        return this.taskInfo != null;
    }

    @Override
    boolean isActive() {
        return this.getJob().getState() != 0;
    }

    public boolean isBlocked() {
        return this.getBlockedStatus() != null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isCancellable() {
        return super.isCancellable();
    }

    @Override
    boolean isJobInfo() {
        return true;
    }

    public void setBlockedStatus(IStatus blockedStatus) {
        this.blockedStatus = blockedStatus;
    }

    void setGroupInfo(GroupInfo group) {
        this.parent = group;
    }

    void setTaskName(String name) {
        this.taskInfo.setTaskName(name);
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }
}

