/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XbaseEditorInputRedirector {
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private LanguageInfo languageInfo;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public ITypeRoot getTypeRoot(IEditorInput it) {
        ITypeRoot _xblockexpression = null;
        IJavaElement adapter = (IJavaElement)it.getAdapter(IJavaElement.class);
        ITypeRoot _xifexpression = null;
        if (adapter instanceof ITypeRoot) {
            _xifexpression = (ITypeRoot)adapter;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IEditorInput findOriginalSourceForOuputFolderCopy(IEditorInput input) {
        try {
            IJavaProject project;
            boolean _exists;
            boolean _isValid;
            IFile resource = ResourceUtil.getFile((IEditorInput)input);
            if (resource != null && (_isValid = this.fileExtensionProvider.isValid(resource.getFullPath().getFileExtension())) && (_exists = (project = JavaCore.create((IProject)resource.getProject())).exists())) {
                boolean _isPrefixOf = project.getOutputLocation().isPrefixOf(resource.getFullPath());
                if (_isPrefixOf) {
                    IPath relative = resource.getFullPath().removeFirstSegments(project.getOutputLocation().segmentCount());
                    Functions.Function1 _function = it -> {
                        try {
                            int _kind = it.getKind();
                            return _kind == 1;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)project.getPackageFragmentRoots())), (Functions.Function1)_function);
                    for (IPackageFragmentRoot source : _filter) {
                        IPath fullPath = source.getCorrespondingResource().getProjectRelativePath().append(relative);
                        IFile newFile = resource.getProject().getFile(fullPath);
                        boolean _exists_1 = newFile.exists();
                        if (!_exists_1) continue;
                        return new FileEditorInput(newFile);
                    }
                }
                Functions.Function1 _function_1 = it -> {
                    int _entryKind = it.getEntryKind();
                    return _entryKind == 3;
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)project.getRawClasspath())), (Functions.Function1)_function_1);
                for (IClasspathEntry sourceFolder : _filter_1) {
                    if (sourceFolder.getOutputLocation() == null || !sourceFolder.getOutputLocation().isPrefixOf(resource.getFullPath())) continue;
                    IPath relative_1 = resource.getFullPath().removeFirstSegments(sourceFolder.getOutputLocation().segmentCount());
                    IPackageFragmentRoot source_1 = (IPackageFragmentRoot)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)project.findPackageFragmentRoots(sourceFolder))));
                    IPath fullPath = source_1.getCorrespondingResource().getProjectRelativePath().append(relative_1);
                    IFile newFile = resource.getProject().getFile(fullPath);
                    boolean _exists_1 = newFile.exists();
                    if (!_exists_1) continue;
                    return new FileEditorInput(newFile);
                }
            }
            return input;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IEditorInput findOriginalSource(IEditorInput input) {
        IFile resource = ResourceUtil.getFile((IEditorInput)input);
        if (resource != null) {
            IEditorInput original = this.findOriginalSourceForOuputFolderCopy(input);
            if (original != input) {
                return original;
            }
            IEclipseTrace trace = (IEclipseTrace)this.traceInformation.getTraceToSource((Object)resource);
            if (trace == null) {
                return input;
            }
            Iterator allLocations = trace.getAllAssociatedLocations().iterator();
            ILocationInEclipseResource sourceInformation = null;
            while (allLocations.hasNext() && sourceInformation == null) {
                ILocationInEclipseResource candidate = (ILocationInEclipseResource)allLocations.next();
                boolean _equals = this.languageInfo.equals((Object)candidate.getLanguage());
                if (!_equals) continue;
                sourceInformation = candidate;
            }
            if (sourceInformation == null) {
                return input;
            }
            IStorage originalStorage = (IStorage)sourceInformation.getPlatformResource();
            if (originalStorage != null) {
                return EditorUtils.createEditorInput((IStorage)originalStorage);
            }
        }
        return input;
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(IJavaElement element) {
        return this.getPackageFragmentRoot(element.getParent());
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(IPackageFragmentRoot element) {
        return element;
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(Void element) {
        throw new IllegalStateException("couldn't find source package fragment root.");
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        if (element instanceof IPackageFragmentRoot) {
            return this._getPackageFragmentRoot((IPackageFragmentRoot)element);
        }
        if (element != null) {
            return this._getPackageFragmentRoot(element);
        }
        if (element == null) {
            return this._getPackageFragmentRoot((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

