/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.layouts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class AlignedFlowLayout
extends AbstractHintLayout {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_BEGIN = 1;
    public static final int ALIGN_END = 2;
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    protected boolean horizontal = true;
    protected boolean fill = false;
    protected boolean fillParent = false;
    protected Transposer transposer = new Transposer();
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected int secondaryAlignment;
    protected int horizontalSpacing;
    protected int verticalSpacing;
    private WorkingData data;

    public AlignedFlowLayout() {
        this.transposer.setEnabled(!this.horizontal);
        this.horizontalAlignment = 1;
        this.verticalAlignment = 1;
        this.secondaryAlignment = 1;
        this.horizontalSpacing = 5;
        this.verticalSpacing = 5;
        this.data = null;
    }

    public AlignedFlowLayout(boolean isHorizontal) {
        this.transposer.setEnabled(!this.horizontal);
        this.horizontalAlignment = 1;
        this.verticalAlignment = 1;
        this.secondaryAlignment = 1;
        this.horizontalSpacing = 5;
        this.verticalSpacing = 5;
        this.data = null;
        this.setHorizontal(isHorizontal);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int maxWidth;
        int cHorizontalSpacing = this.horizontalSpacing;
        if (!this.isHorizontal()) {
            cHorizontalSpacing = this.verticalSpacing;
        }
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        if (this.isHorizontal()) {
            maxWidth = wHint;
            hHint = -1;
        } else {
            maxWidth = hHint;
            wHint = -1;
        }
        if (maxWidth <= 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(this.getChildSize(child, wHint, hHint));
            if (i == 0) {
                width = childSize.width;
                height = childSize.height;
            } else {
                width += childSize.width + cHorizontalSpacing;
                height = Math.max(height, childSize.height);
            }
            ++i;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize = this.transposer.t(prefSize);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        return child.getPreferredSize(wHint, hHint);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    private void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
        this.data.rowCount = 0;
    }

    private void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    protected boolean isSensitiveHorizontally(IFigure parent) {
        return this.isHorizontal();
    }

    protected boolean isSensitiveVertically(IFigure parent) {
        return !this.isHorizontal();
    }

    public void layout(IFigure parent) {
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        this.data.spacing = this.transposer.t(new Dimension(this.horizontalSpacing, this.verticalSpacing));
        Iterator iterator = parent.getChildren().iterator();
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            wHint = parent.getClientArea().width;
        } else {
            hHint = parent.getClientArea().height;
        }
        this.initVariables(parent);
        this.initRow();
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.data.spacing.width;
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            if (this.fillParent) {
                this.data.rowHeight = Math.max(this.data.area.height, r.height);
            }
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int justification = 0;
        int correctHorizontalAlignment = this.horizontalAlignment;
        int correctVerticalAlignment = this.verticalAlignment;
        majorAdjustment = this.data.area.width - this.data.rowWidth;
        if (!this.isHorizontal()) {
            correctHorizontalAlignment = this.verticalAlignment;
            correctVerticalAlignment = this.horizontalAlignment;
        }
        switch (correctHorizontalAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        minorAdjustment = this.data.area.height - this.data.rowHeight;
        switch (correctVerticalAlignment) {
            case 1: {
                minorAdjustment = 0;
                break;
            }
            case 0: {
                minorAdjustment /= 2;
                break;
            }
        }
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.fill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                justification = this.data.rowHeight - this.data.bounds[j].height;
                switch (this.secondaryAlignment) {
                    case 1: {
                        justification = 0;
                        break;
                    }
                    case 0: {
                        justification /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment + justification;
            }
            this.data.bounds[j].x += majorAdjustment;
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            ++j;
        }
        this.data.rowY += this.data.spacing.height + this.data.rowHeight;
        this.initRow();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setStretchMinorAxis(boolean value) {
        this.fill = value;
    }

    public void setHorizontal(boolean flag) {
        if (this.horizontal == flag) {
            return;
        }
        this.invalidate();
        this.horizontal = flag;
        this.transposer.setEnabled(!this.horizontal);
    }

    public void setHorizontalAlignment(int align) {
        this.horizontalAlignment = align;
    }

    public void setVerticalSpacing(int n) {
        this.verticalSpacing = n;
    }

    public void setVerticalAlignment(int align) {
        this.verticalAlignment = align;
    }

    public void setHorizontalSpacing(int n) {
        this.horizontalSpacing = n;
    }

    public int getSecondaryAlignment() {
        return this.secondaryAlignment;
    }

    public void setSecondaryAlignment(int i) {
        this.secondaryAlignment = i;
    }

    public void setStretchMinorAxisToParent(boolean fillParent) {
        this.fillParent = fillParent;
    }

    class WorkingData {
        int rowHeight;
        int rowWidth;
        int rowCount;
        int rowX;
        int rowY;
        Rectangle[] bounds;
        Rectangle area;
        IFigure[] row;
        Dimension spacing;

        WorkingData() {
        }
    }
}

