/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.ContainerDataVolumeDialog;
import org.eclipse.cdt.internal.docker.launcher.ContainerPropertyVolumesModel;
import org.eclipse.cdt.internal.docker.launcher.DataVolumeModel;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.internal.docker.launcher.SWTImagesFactory;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuiltinSpecsDetector;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ContainerPropertyTab
extends AbstractCBuildPropertyTab
implements IDockerConnectionManagerListener,
IDockerImageListener {
    public static final String VOLUME_SEPARATOR = "|";
    private static final String GNU_ELF_PARSER_ID = "org.eclipse.cdt.core.GNU_ELF";
    private static final String ELF_PARSER_ID = "org.eclipse.cdt.core.ELF";
    private static final String RUN_IN_CONFIGURE_LAUNCHER = "org.eclipse.cdt.autotools.core.property.launchAutotoolsInContainer";
    private Combo imageCombo;
    private Combo connectionSelector;
    private Button enableButton;
    private Button launchAutotoolsButton;
    private Button addButton;
    private IDockerConnection connection;
    private IDockerConnection[] connections;
    private IDockerImageListener containerTab;
    private boolean isAutotoolsProject;
    private String connectionName;
    private String connectionUri = "";
    private boolean initialEnabled;
    private boolean initialAutotoolsLaunchEnabled;
    private String initialConnection;
    private String initialImageId;
    private String initialVolumes;
    private String initialSelectedVolumes;
    private boolean multiChange;
    private List<IDockerImage> displayedImages = new ArrayList<IDockerImage>();
    private IConfiguration iCfg;
    private ICConfigurationDescription iCfgd;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ContainerPropertyVolumesModel model;
    private ModifyListener connectionModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int index = ContainerPropertyTab.this.connectionSelector.getSelectionIndex();
            if (index < 0) {
                ContainerPropertyTab.this.connection = null;
                ContainerPropertyTab.this.connectionName = "";
                return;
            }
            if (ContainerPropertyTab.this.connection != null) {
                ContainerPropertyTab.this.connection.removeImageListener(ContainerPropertyTab.this.containerTab);
            }
            ContainerPropertyTab.this.connection = ContainerPropertyTab.this.connections[index];
            ContainerPropertyTab.this.connectionUri = ContainerPropertyTab.this.connection.getUri();
            if (!ContainerPropertyTab.this.connectionName.equals(ContainerPropertyTab.this.connection.getName())) {
                ContainerPropertyTab.this.imageCombo.setText("");
                ContainerPropertyTab.this.initialImageId = null;
                ContainerPropertyTab.this.refreshImages();
                ContainerPropertyTab.setVolumeControlsEnabled((Control[])new Button[]{ContainerPropertyTab.this.addButton}, false);
            }
            ContainerPropertyTab.this.connectionName = ContainerPropertyTab.this.connection.getName();
            ContainerPropertyTab.this.setConnection(ContainerPropertyTab.this.connectionUri);
            ContainerPropertyTab.this.model.setConnection(ContainerPropertyTab.this.connection);
        }
    };

    public ContainerPropertyTab() {
        this.containerTab = this;
        this.model = new ContainerPropertyVolumesModel(null);
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(5, false));
        this.usercomp.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.usercomp.setLayoutData((Object)gd);
        this.enableButton = new Button(this.usercomp, 32);
        this.enableButton.setText(Messages.ContainerPropertyTab_Enable_Msg);
        this.iCfg = this.getCfg();
        this.iCfgd = this.getResDesc().getConfiguration();
        gd = new GridData(768);
        gd.horizontalSpan = 5;
        this.enableButton.setLayoutData((Object)gd);
        Label connectionSelectorLabel = new Label(this.usercomp, 0);
        connectionSelectorLabel.setText(Messages.ContainerTab_Connection_Selector_Label);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        connectionSelectorLabel.setLayoutData((Object)gd);
        this.connectionSelector = new Combo(this.usercomp, 2056);
        this.initializeConnectionSelector();
        this.connectionSelector.addModifyListener(this.connectionModifyListener);
        this.connectionSelector.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = false;
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.connectionSelector.setLayoutData((Object)gd);
        Label label1 = new Label(this.usercomp, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        label1.setLayoutData((Object)gd);
        Label imageSelectorLabel = new Label(this.usercomp, 0);
        imageSelectorLabel.setText(Messages.ContainerTab_Image_Selector_Label);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        connectionSelectorLabel.setLayoutData((Object)gd);
        this.imageCombo = new Combo(this.usercomp, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.imageCombo.setLayoutData((Object)gd);
        Label label2 = new Label(this.usercomp, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        label2.setLayoutData((Object)gd);
        this.initializeImageCombo();
        this.imageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerPropertyTab.this.setImageId(ContainerPropertyTab.this.imageCombo.getText());
                ContainerPropertyTab.this.model.setSelectedImage((IDockerImage)ContainerPropertyTab.this.displayedImages.get(ContainerPropertyTab.this.imageCombo.getSelectionIndex()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createVolumeSettingsContainer(this.usercomp);
        try {
            IProject project = this.iCfgd.getProjectDescription().getProject();
            IProjectNature nature = project.getNature("org.eclipse.cdt.autotools.core.autotoolsNatureV2");
            boolean bl = this.isAutotoolsProject = nature != null;
            if (this.isAutotoolsProject) {
                this.launchAutotoolsButton = new Button(this.usercomp, 32);
                this.launchAutotoolsButton.setText(Messages.ContainerPropertyTab_Run_Autotools_In_Container_Msg);
                this.launchAutotoolsButton.setToolTipText(Messages.ContainerPropertyTab_Run_Autotools_In_Container_Tooltip);
                gd = new GridData(768);
                gd.horizontalSpan = 5;
                this.launchAutotoolsButton.setLayoutData((Object)gd);
                this.initializeLaunchAutotoolsButton();
                this.launchAutotoolsButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ContainerPropertyTab.this.setLaunchAutotoolsEnablement(ContainerPropertyTab.this.launchAutotoolsButton.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        this.initializeEnablementButton();
        this.enableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerPropertyTab.this.setControlsEnabled(ContainerPropertyTab.this.enableButton.getSelection());
                ContainerPropertyTab.this.setEnablement(ContainerPropertyTab.this.enableButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createVolumeSettingsContainer(Composite container) {
        Label volumesLabel = new Label(container, 0);
        volumesLabel.setText(WizardMessages.getString((String)"ImageRunResourceVolVarPage.dataVolumesLabel"));
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)volumesLabel);
        CheckboxTableViewer dataVolumesTableViewer = this.createVolumesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(400, 200).applyTo((Control)dataVolumesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        this.addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.addButton);
        this.addButton.setText(WizardMessages.getString((String)"ImageRunResourceVolVarPage.addButton"));
        this.addButton.addSelectionListener(this.onAddDataVolume(dataVolumesTableViewer));
        if (this.imageCombo.getText() != null && !this.imageCombo.getText().equals("")) {
            ContainerPropertyTab.setVolumeControlsEnabled((Control[])new Button[]{this.addButton}, true);
        }
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString((String)"ImageRunResourceVolVarPage.editButton"));
        editButton.addSelectionListener(this.onEditDataVolume(dataVolumesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString((String)"ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveDataVolumes((TableViewer)dataVolumesTableViewer));
        removeButton.setEnabled(false);
        this.bind((StructuredViewer)dataVolumesTableViewer, (IObservableList)this.model.getDataVolumes(), BeanProperties.values(DataVolumeModel.class, (String[])new String[]{"containerPath", "mount", "readOnly"}));
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)dataVolumesTableViewer, DataVolumeModel.class), BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model));
        dataVolumesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
        this.initializeVolumesTable();
    }

    private void bind(StructuredViewer viewer, IObservableList input, IBeanValueProperty[] labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new DataVolumesLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput((Object)input);
        }
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                ContainerPropertyTab.setVolumeControlsEnabled((Control[])targetButtons, false);
            } else {
                ContainerPropertyTab.setVolumeControlsEnabled((Control[])targetButtons, true);
            }
        };
    }

    private static void setVolumeControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != null) {
                control.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private SelectionListener onAddDataVolume(CheckboxTableViewer dataVolumesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(Display.getDefault().getActiveShell(), this.model.getConnection());
            dialog.create();
            if (dialog.open() == 0) {
                DataVolumeModel dataVolume = dialog.getDataVolume();
                dataVolume.setSelected(true);
                this.model.getDataVolumes().add((Object)dataVolume);
                this.model.getSelectedDataVolumes().add(dataVolume);
                dataVolumesTableViewer.setChecked((Object)dataVolume, true);
                this.setVolumes();
            }
        });
    }

    private SelectionListener onEditDataVolume(CheckboxTableViewer dataVolumesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = (IStructuredSelection)dataVolumesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            DataVolumeModel selectedDataVolume = (DataVolumeModel)selection.getFirstElement();
            ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(Display.getDefault().getActiveShell(), this.model.getConnection(), selectedDataVolume);
            dialog.create();
            if (dialog.open() == 0) {
                DataVolumeModel dialogDataVolume = dialog.getDataVolume();
                selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                selectedDataVolume.setMountType(dialogDataVolume.getMountType());
                selectedDataVolume.setHostPathMount(dialogDataVolume.getHostPathMount());
                selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                selectedDataVolume.setReadOnly(dialogDataVolume.isReadOnly());
                this.model.getSelectedDataVolumes().add(selectedDataVolume);
                dataVolumesTableViewer.setChecked((Object)selectedDataVolume, true);
                this.setVolumes();
            }
        });
    }

    private SelectionListener onRemoveDataVolumes(TableViewer dataVolumesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = dataVolumesTableViewer.getStructuredSelection();
            for (DataVolumeModel volume : selection) {
                this.model.removeDataVolume(volume);
                this.model.getSelectedDataVolumes().remove(volume);
            }
            this.setVolumes();
        });
    }

    private CheckboxTableViewer createVolumesTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)tableViewer, DataVolumeModel.class), BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model));
        this.addTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString((String)"ImageRunResourceVolVarPage.containerPathColumn"), 180);
        this.addTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString((String)"ImageRunResourceVolVarPage.mountColumn"), 180);
        this.addTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString((String)"ImageRunResourceVolVarPage.readonlyColumn"), 60);
        return tableViewer;
    }

    private TableViewerColumn addTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void setVolumes() {
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        for (DataVolumeModel volume : this.model.getDataVolumes()) {
            buffer.append(separator);
            buffer.append(volume.toString());
            separator = VOLUME_SEPARATOR;
        }
        StringBuffer selectedBuffer = new StringBuffer();
        separator = "";
        for (DataVolumeModel volume : this.model.getSelectedDataVolumes()) {
            selectedBuffer.append(separator);
            selectedBuffer.append(volume.toString());
            separator = VOLUME_SEPARATOR;
        }
        if (this.iCfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.iCfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IConfiguration cfg = cfs[i];
                IOptionalBuildProperties p = cfg.getOptionalBuildProperties();
                p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes", buffer.toString());
                p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes", selectedBuffer.toString());
                ++i;
            }
        } else {
            IOptionalBuildProperties p = this.iCfg.getOptionalBuildProperties();
            p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes", buffer.toString());
            p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes", selectedBuffer.toString());
        }
    }

    private void setEnablement(boolean enabled) {
        if (this.iCfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.iCfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IConfiguration cfg = cfs[i];
                IOptionalBuildProperties p = cfg.getOptionalBuildProperties();
                p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement", Boolean.toString(this.enableButton.getSelection()));
                ++i;
            }
        } else {
            IOptionalBuildProperties p = this.iCfg.getOptionalBuildProperties();
            p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement", Boolean.toString(this.enableButton.getSelection()));
        }
        if (enabled) {
            String[] ids = CoreModelUtil.getBinaryParserIds((ICConfigurationDescription[])this.page.getCfgsEditable());
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(ids));
            if (!idList.contains(GNU_ELF_PARSER_ID)) {
                idList.add(GNU_ELF_PARSER_ID);
            }
            if (!idList.contains(ELF_PARSER_ID)) {
                idList.add(ELF_PARSER_ID);
            }
            CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])this.page.getCfgsEditable(), (String[])idList.toArray(new String[0]));
        }
    }

    private void setLaunchAutotoolsEnablement(boolean enabled) {
        if (this.iCfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.iCfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IConfiguration cfg = cfs[i];
                IOptionalBuildProperties p = cfg.getOptionalBuildProperties();
                p.setProperty(RUN_IN_CONFIGURE_LAUNCHER, Boolean.toString(this.launchAutotoolsButton.getSelection()));
                ++i;
            }
        } else {
            IOptionalBuildProperties p = this.iCfg.getOptionalBuildProperties();
            p.setProperty(RUN_IN_CONFIGURE_LAUNCHER, Boolean.toString(this.launchAutotoolsButton.getSelection()));
        }
    }

    private void setImageId(String imageId) {
        if (this.iCfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.iCfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IConfiguration cfg = cfs[i];
                IOptionalBuildProperties p = cfg.getOptionalBuildProperties();
                p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image", imageId);
                ++i;
            }
        } else {
            IOptionalBuildProperties p = this.iCfg.getOptionalBuildProperties();
            p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image", imageId);
        }
    }

    private void setConnection(String uri) {
        if (this.iCfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.iCfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IConfiguration cfg = cfs[i];
                IOptionalBuildProperties p = cfg.getOptionalBuildProperties();
                p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", uri);
                ++i;
            }
        } else {
            IOptionalBuildProperties p = this.iCfg.getOptionalBuildProperties();
            p.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", uri);
        }
    }

    private void setControlsEnabled(boolean enabled) {
        this.imageCombo.setEnabled(enabled);
        this.connectionSelector.setEnabled(enabled);
        if (this.isAutotoolsProject) {
            this.launchAutotoolsButton.setEnabled(enabled);
        }
        ContainerPropertyTab.setVolumeControlsEnabled((Control[])new Button[]{this.addButton}, enabled);
    }

    private void initializeEnablementButton() {
        this.initialEnabled = false;
        IOptionalBuildProperties properties = this.iCfg.getOptionalBuildProperties();
        String savedEnabled = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement");
        if (savedEnabled != null) {
            this.initialEnabled = Boolean.parseBoolean(savedEnabled);
        }
        this.enableButton.setSelection(this.initialEnabled);
        this.setControlsEnabled(this.initialEnabled);
    }

    private void initializeLaunchAutotoolsButton() {
        this.initialEnabled = false;
        IOptionalBuildProperties properties = this.iCfg.getOptionalBuildProperties();
        String savedEnabled = properties.getProperty(RUN_IN_CONFIGURE_LAUNCHER);
        if (savedEnabled != null) {
            this.initialAutotoolsLaunchEnabled = Boolean.parseBoolean(savedEnabled);
        }
        this.launchAutotoolsButton.setSelection(this.initialAutotoolsLaunchEnabled);
    }

    private void initializeConnectionSelector() {
        int defaultIndex = -1;
        this.initialConnection = null;
        IOptionalBuildProperties properties = this.iCfg.getOptionalBuildProperties();
        String id = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
        if (id != null) {
            this.initialConnection = id;
        }
        this.connections = DockerConnectionManager.getInstance().getConnections();
        if (this.connections.length == 0) {
            return;
        }
        String[] connectionNames = new String[this.connections.length];
        int i = 0;
        while (i < this.connections.length) {
            connectionNames[i] = this.connections[i].getName();
            if (this.connections[i].getUri().equals(this.initialConnection)) {
                defaultIndex = i;
            }
            ++i;
        }
        if (defaultIndex < 0) {
            this.initialEnabled = false;
            defaultIndex = 0;
        }
        this.connectionSelector.setItems(connectionNames);
        if (this.connections.length > 0) {
            this.connectionSelector.select(defaultIndex);
            this.connection = this.connections[defaultIndex];
            this.connectionName = this.connection.getName();
            this.initialConnection = this.connectionUri = this.connection.getUri();
            this.model.setConnection(this.connection);
        }
    }

    private void refreshImages() {
        if (this.connection != null) {
            int index;
            List images = this.connection.getImages();
            if (images == null || images.size() == 0) {
                return;
            }
            this.connection.removeImageListener(this.containerTab);
            ArrayList<String> imageNames = new ArrayList<String>();
            this.displayedImages = new ArrayList<IDockerImage>();
            for (IDockerImage image : images) {
                List tags = image.repoTags();
                if (tags == null) continue;
                for (String tag : tags) {
                    if (tag.equals("<none>:<none>")) continue;
                    imageNames.add(tag);
                    this.displayedImages.add(image);
                }
            }
            this.imageCombo.setItems(imageNames.toArray(new String[0]));
            if (this.initialImageId != null && (index = this.imageCombo.indexOf(this.initialImageId)) > -1) {
                this.imageCombo.select(index);
                this.model.setSelectedImage(this.displayedImages.get(index));
                ContainerPropertyTab.setVolumeControlsEnabled((Control[])new Button[]{this.addButton}, true);
            }
            this.connection.addImageListener(this.containerTab);
        }
    }

    private void initializeImageCombo() {
        this.initialImageId = null;
        IOptionalBuildProperties properties = this.iCfg.getOptionalBuildProperties();
        String id = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        if (id != null) {
            this.initialImageId = id;
        }
        this.refreshImages();
    }

    private void initializeVolumesTable() {
        this.model.clearDataVolumes();
        int imageSelectionIndex = this.imageCombo.getSelectionIndex();
        if (imageSelectionIndex >= 0 && imageSelectionIndex < this.displayedImages.size()) {
            this.model.setSelectedImage(this.displayedImages.get(imageSelectionIndex));
        }
        IOptionalBuildProperties properties = this.iCfg.getOptionalBuildProperties();
        this.initialVolumes = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes");
        Map<String, DataVolumeModel> volumeMap = this.parseVolumes(this.initialVolumes);
        this.initialSelectedVolumes = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes");
        Map<String, DataVolumeModel> selectedVolumeMap = this.parseVolumes(this.initialSelectedVolumes);
        HashSet<DataVolumeModel> selectedVolumes = new HashSet<DataVolumeModel>();
        for (DataVolumeModel dvm : selectedVolumeMap.values()) {
            volumeMap.put(dvm.getContainerPath(), dvm);
            selectedVolumes.add(dvm);
        }
        this.model.setDataVolumes(volumeMap.values());
        this.model.setSelectedDataVolumes(selectedVolumes);
    }

    private Map<String, DataVolumeModel> parseVolumes(String volumesString) {
        HashMap<String, DataVolumeModel> volumeMap = new HashMap<String, DataVolumeModel>();
        if (volumesString != null && !volumesString.equals("")) {
            String[] volumes;
            String[] stringArray = volumes = volumesString.split("[|]");
            int n = volumes.length;
            int n2 = 0;
            while (n2 < n) {
                String volume = stringArray[n2];
                if (volume != null && !volume.equals("")) {
                    DataVolumeModel dataVolume = DataVolumeModel.parseString(volume);
                    volumeMap.put(dataVolume.getContainerPath(), dataVolume);
                }
                ++n2;
            }
        }
        return volumeMap;
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.setVolumes();
        boolean needToRecalculate = false;
        ICConfigurationDescription defaultCfg = null;
        if (this.page.isMultiCfg()) {
            ICMultiConfigDescription mc1 = (ICMultiConfigDescription)src.getConfiguration();
            ICMultiConfigDescription mc2 = (ICMultiConfigDescription)dst.getConfiguration();
            ICConfigurationDescription[] cds1 = (ICConfigurationDescription[])mc1.getItems();
            ICConfigurationDescription[] cds2 = (ICConfigurationDescription[])mc2.getItems();
            defaultCfg = cds1[0];
            int i = 0;
            while (i < cds1.length) {
                needToRecalculate |= this.applyToCfg(cds1[i], cds2[i]);
                ++i;
            }
        } else {
            defaultCfg = src.getConfiguration();
            needToRecalculate = this.applyToCfg(src.getConfiguration(), dst.getConfiguration());
        }
        if (needToRecalculate) {
            this.recalculateSpecs(defaultCfg, true);
        }
    }

    private boolean applyToCfg(ICConfigurationDescription c1, ICConfigurationDescription c2) {
        Configuration cfg01 = (Configuration)ContainerPropertyTab.getCfg((ICConfigurationDescription)c1);
        Configuration cfg02 = (Configuration)ContainerPropertyTab.getCfg((ICConfigurationDescription)c2);
        IOptionalBuildProperties prop1 = cfg01.getOptionalBuildProperties();
        IOptionalBuildProperties prop2 = cfg02.getOptionalBuildProperties();
        boolean needToRecalculate = false;
        ICTargetPlatformSetting tps = c1.getTargetPlatformSetting();
        String[] pids = tps.getBinaryParserIds();
        ICTargetPlatformSetting tps2 = c2.getTargetPlatformSetting();
        tps2.setBinaryParserIds(pids);
        String enablementProperty = prop1.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement");
        String enablementProperty2 = prop2.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement");
        if (enablementProperty != null && !enablementProperty.equals(enablementProperty2)) {
            needToRecalculate = true;
        }
        prop2.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement", enablementProperty);
        String connectionProperty = prop1.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
        String connectionProperty2 = prop2.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
        if (connectionProperty != null && !connectionProperty.equals(connectionProperty2)) {
            needToRecalculate = true;
        }
        prop2.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", connectionProperty);
        String imageProperty = prop1.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        String imageProperty2 = prop2.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        if (imageProperty != null && !imageProperty.equals(imageProperty2)) {
            needToRecalculate = true;
        }
        prop2.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image", imageProperty);
        String volumesProperty = prop1.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes");
        prop2.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes", volumesProperty);
        String selectedVolumesProperty = prop1.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes");
        prop2.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes", selectedVolumesProperty);
        return needToRecalculate;
    }

    protected void recalculateSpecs(ICConfigurationDescription cfgd, boolean performingApply) {
        IConfiguration cfg = ContainerPropertyTab.getCfg((ICConfigurationDescription)cfgd);
        IOptionalBuildProperties properties = cfg.getOptionalBuildProperties();
        this.initialEnabled = Boolean.parseBoolean(properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement"));
        this.initialConnection = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
        this.initialImageId = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        this.initialVolumes = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes");
        this.initialSelectedVolumes = properties.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes");
        this.initialAutotoolsLaunchEnabled = Boolean.parseBoolean(properties.getProperty(RUN_IN_CONFIGURE_LAUNCHER));
        List providers = ((ILanguageSettingsProvidersKeeper)cfgd).getLanguageSettingProviders();
        for (ILanguageSettingsProvider provider : providers) {
            if (!(provider instanceof GCCBuiltinSpecsDetector)) continue;
            GCCBuiltinSpecsDetector d = (GCCBuiltinSpecsDetector)provider;
            d.clear();
            if (!performingApply) continue;
            d.handleEvent(null);
        }
    }

    protected void performOK() {
        boolean needToRecalculate = false;
        this.setVolumes();
        if (this.iCfg instanceof IMultiConfiguration) {
            needToRecalculate = this.multiChange;
        } else {
            IOptionalBuildProperties p = this.iCfg.getOptionalBuildProperties();
            if (this.initialEnabled != Boolean.parseBoolean(p.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement"))) {
                needToRecalculate = true;
            } else if (!(!this.initialEnabled || this.initialConnection.equals(p.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection")) && this.initialImageId.equals(p.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image")))) {
                needToRecalculate = true;
            }
        }
        if (needToRecalculate) {
            this.recalculateSpecs(ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.iCfg), false);
        }
    }

    protected void performDefaults() {
        if (this.iCfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.iCfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IOptionalBuildProperties props = cfs[i].getOptionalBuildProperties();
                props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement", Boolean.toString(false));
                if (this.connections.length > 0) {
                    props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", this.connections[0].getUri());
                } else {
                    props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", null);
                }
                props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image", null);
                props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.volumes", null);
                props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.selectedvolumes", null);
                ++i;
            }
        } else {
            IOptionalBuildProperties props = this.iCfg.getOptionalBuildProperties();
            props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement", Boolean.toString(false));
            if (this.connections.length > 0) {
                props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", this.connections[0].getUri());
            } else {
                props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection", null);
            }
            props.setProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image", null);
        }
        this.initialEnabled = false;
        this.initialConnection = null;
        this.initialImageId = null;
        this.initialVolumes = null;
        this.initialSelectedVolumes = null;
        if (this.connections.length > 0) {
            this.connectionSelector.select(0);
        }
        this.imageCombo.setText("");
        this.model.setDataVolumes(null);
        this.model.setSelectedDataVolumes(null);
        this.enableButton.setSelection(false);
        this.setControlsEnabled(false);
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.iCfg = ContainerPropertyTab.getCfg((ICConfigurationDescription)cfgd.getConfiguration());
        this.iCfgd = cfgd.getConfiguration();
        this.multiChange = false;
        this.initializeConnectionSelector();
        this.initializeImageCombo();
        this.initializeEnablementButton();
        this.initializeVolumesTable();
    }

    protected void updateButtons() {
    }

    public void changeEvent(IDockerConnection changedConnection, int type) {
        String currUri = null;
        int currIndex = 0;
        this.connections = DockerConnectionManager.getInstance().getConnections();
        if (this.connection != null) {
            currUri = this.connection.getUri();
            currIndex = this.connectionSelector.getSelectionIndex();
        }
        String[] connectionNames = new String[this.connections.length];
        int index = 0;
        int i = 0;
        while (i < this.connections.length) {
            connectionNames[i] = this.connections[i].getName();
            if (this.connections[i].getUri().equals(currUri)) {
                index = i;
            }
            ++i;
        }
        if (type == 2) {
            index = currIndex;
        }
        this.connectionSelector.removeModifyListener(this.connectionModifyListener);
        this.connectionSelector.setItems(connectionNames);
        if (connectionNames.length > 0) {
            this.connectionSelector.setText(connectionNames[index]);
            this.connection = this.connections[index];
            this.model.setConnection(this.connection);
            this.connectionUri = this.connection.getUri();
        } else {
            this.connection = null;
            this.model.setConnection(null);
            this.model.setSelectedImage(null);
            this.connectionUri = "";
            this.connectionSelector.setText("");
        }
        this.connectionSelector.addModifyListener(this.connectionModifyListener);
    }

    public void listChanged(IDockerConnection c, List<IDockerImage> list) {
        IDockerImage[] finalList = list.toArray(new IDockerImage[0]);
        if (c.getName().equals(this.connection.getName())) {
            Display.getDefault().syncExec(() -> {
                this.connection.removeImageListener(this.containerTab);
                ArrayList<String> imageNames = new ArrayList<String>();
                this.displayedImages = new ArrayList<IDockerImage>();
                IDockerImage[] iDockerImageArray2 = finalList;
                int n = finalList.length;
                int n2 = 0;
                while (n2 < n) {
                    IDockerImage image = iDockerImageArray2[n2];
                    List tags = image.repoTags();
                    if (tags != null) {
                        for (String tag : tags) {
                            imageNames.add(tag);
                            this.displayedImages.add(image);
                        }
                    }
                    ++n2;
                }
                if (!this.imageCombo.isDisposed()) {
                    this.imageCombo.setItems(imageNames.toArray(new String[0]));
                }
                this.connection.addImageListener(this.containerTab);
            });
        }
    }

    private static final class DataVolumesLabelProvider
    extends ObservableMapLabelProvider {
        private Image CONTAINER_IMAGE = SWTImagesFactory.DESC_CONTAINER.createImage();
        private Image FOLDER_CLOSED_IMAGE = SWTImagesFactory.DESC_FOLDER_CLOSED.createImage();
        private Image FILE_IMAGE = SWTImagesFactory.DESC_FILE.createImage();

        public DataVolumesLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public void dispose() {
            this.CONTAINER_IMAGE.dispose();
            this.FOLDER_CLOSED_IMAGE.dispose();
            this.FILE_IMAGE.dispose();
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            if (dataVolume.getMountType() != null && columnIndex == 1) {
                switch (dataVolume.getMountType()) {
                    case CONTAINER: {
                        return this.CONTAINER_IMAGE;
                    }
                    case HOST_FILE_SYSTEM: {
                        File hostFile = new File(dataVolume.getMount());
                        if (!hostFile.exists() || hostFile.isDirectory()) {
                            return this.FOLDER_CLOSED_IMAGE;
                        }
                        return this.FILE_IMAGE;
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            switch (columnIndex) {
                case 0: {
                    return dataVolume.getContainerPath();
                }
                case 1: {
                    return dataVolume.getMount();
                }
                case 2: {
                    if (dataVolume.getMountType() != ContainerPropertyVolumesModel.MountType.HOST_FILE_SYSTEM) {
                        return null;
                    }
                    if (dataVolume.isReadOnly()) {
                        return WizardMessages.getString((String)"ImageRunResourceVolVarPage.true");
                    }
                    return WizardMessages.getString((String)"ImageRunResourceVolVarPage.false");
                }
            }
            return null;
        }
    }
}

