/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.ui.launch.AbstractCargoLaunchConfigurationTab;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CargoTestTab
extends AbstractCargoLaunchConfigurationTab {
    private Text testnameText;

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("TEST_NAME", this.testnameText.getText());
        super.performApply(configuration);
    }

    @Override
    protected String getCommandGroupText() {
        return "cargo test [options] [test name] [--] [arguments]";
    }

    @Override
    protected String getCargoSubcommand() {
        return "test";
    }

    @Override
    protected Group createExtraControlsGroup(Composite container) {
        Group commandGroup = super.createExtraControlsGroup(container);
        Label testnameLabel = new Label((Composite)commandGroup, 0);
        testnameLabel.setText(Messages.CargoTestTab_testName);
        testnameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.testnameText = new Text((Composite)commandGroup, 2048);
        this.testnameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.testnameText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label((Composite)commandGroup, 0);
        new Label((Composite)commandGroup, 0);
        Label testnameExplanation = new Label((Composite)commandGroup, 0);
        testnameExplanation.setText(Messages.CargoTestTab_testNameDescription);
        testnameExplanation.setEnabled(false);
        testnameExplanation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        return commandGroup;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("TEST_NAME", "");
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.testnameText.setText(configuration.getAttribute("TEST_NAME", ""));
        }
        catch (CoreException ce) {
            this.testnameText.setText("");
        }
    }

    public Image getImage() {
        return CorrosionPlugin.getDefault().getImageRegistry().get("images/cargo16.png");
    }

    @Override
    public String getName() {
        return Messages.CargoTestTab_Title;
    }
}

