/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.XMLWriter;
import org.eclipse.dltk.internal.core.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibrary {
    private static final String CURRENT_VERSION = "1";
    private static final String TAG_VERSION = "version";
    private static final String TAG_USERLIBRARY = "userlibrary";
    private static final String TAG_PATH = "path";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
    private static final String ATTRIBUTE_PREFIX = "__attribute__";
    private boolean isSystemLibrary;
    private IBuildpathEntry[] entries;
    private Map<String, String> attributes;

    public UserLibrary(IBuildpathEntry[] entries, boolean isSystemLibrary) {
        this(entries, isSystemLibrary, null);
    }

    public UserLibrary(IBuildpathEntry[] entries, boolean isSystemLibrary, Map<String, String> attributes) {
        Assert.isNotNull((Object)entries);
        this.entries = entries;
        this.isSystemLibrary = isSystemLibrary;
        this.attributes = new HashMap<String, String>();
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public IBuildpathEntry[] getEntries() {
        return this.entries;
    }

    public boolean isSystemLibrary() {
        return this.isSystemLibrary;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            UserLibrary other = (UserLibrary)obj;
            if (this.entries.length == other.entries.length && this.isSystemLibrary == other.isSystemLibrary && this.attributes.size() == other.attributes.size()) {
                if (!Arrays.equals(this.entries, other.entries)) {
                    return false;
                }
                return this.attributes.equals(other.attributes);
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.isSystemLibrary()) {
            ++hashCode;
        }
        int i = 0;
        while (i < this.entries.length) {
            hashCode = hashCode * 17 + this.entries[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public static String serialize(IBuildpathEntry[] entries, boolean isSystemLibrary) throws IOException {
        return UserLibrary.serialize(entries, isSystemLibrary, null);
    }

    public static String serialize(IBuildpathEntry[] entries, boolean isSystemLibrary, Map<String, String> attributes) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, StandardCharsets.UTF_8);
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, null, true);
        HashMap<String, String> library = new HashMap<String, String>();
        library.put(TAG_VERSION, String.valueOf(CURRENT_VERSION));
        library.put(TAG_SYSTEMLIBRARY, String.valueOf(isSystemLibrary));
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                library.put(ATTRIBUTE_PREFIX + key, attributes.get(key));
            }
        }
        xmlWriter.printTag(TAG_USERLIBRARY, library, true, true, false);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            BuildpathEntry cpEntry = (BuildpathEntry)entries[i];
            HashMap<String, String> archive = new HashMap<String, String>();
            archive.put(TAG_PATH, cpEntry.getPath().toString());
            boolean hasExtraAttributes = cpEntry.extraAttributes != null && cpEntry.extraAttributes.length != 0;
            boolean hasRestrictions = cpEntry.getAccessRuleSet() != null;
            xmlWriter.printTag(TAG_ARCHIVE, archive, true, true, !hasExtraAttributes && !hasRestrictions);
            if (hasExtraAttributes) {
                cpEntry.encodeExtraAttributes(xmlWriter, true, true);
            }
            if (hasRestrictions) {
                cpEntry.encodeAccessRules(xmlWriter, true, true);
            }
            if (hasExtraAttributes || hasRestrictions) {
                xmlWriter.endTag(TAG_ARCHIVE, true, true);
            }
            ++i;
        }
        xmlWriter.endTag(TAG_USERLIBRARY, true, true);
        writer.flush();
        writer.close();
        return s.toString("UTF8");
    }

    public static UserLibrary createFromString(Reader reader) throws IOException {
        Element cpElement;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException e) {
                throw new IOException(Messages.file_badFormat);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(Messages.file_badFormat);
            }
        }
        finally {
            reader.close();
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(TAG_USERLIBRARY)) {
            throw new IOException(Messages.file_badFormat);
        }
        boolean isSystem = Boolean.valueOf(cpElement.getAttribute(TAG_SYSTEMLIBRARY));
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 0;
        while (i < cpElement.getAttributes().getLength()) {
            Node node = cpElement.getAttributes().item(i);
            if (node.getNodeName().startsWith(ATTRIBUTE_PREFIX)) {
                String name = node.getNodeName().substring(ATTRIBUTE_PREFIX.length());
                attributes.put(name, node.getNodeValue());
            }
            ++i;
        }
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>(length);
        int i2 = 0;
        while (i2 < length) {
            Element element;
            Node node = list.item(i2);
            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals(TAG_ARCHIVE)) {
                String path = element.getAttribute(TAG_PATH);
                NodeList children = element.getElementsByTagName("*");
                boolean[] foundChildren = new boolean[children.getLength()];
                NodeList attributeList = BuildpathEntry.getChildAttributes("attributes", children, foundChildren);
                IBuildpathAttribute[] extraAttributes = BuildpathEntry.decodeExtraAttributes(attributeList);
                attributeList = BuildpathEntry.getChildAttributes("accessrules", children, foundChildren);
                IAccessRule[] accessRules = BuildpathEntry.decodeAccessRules(attributeList);
                IBuildpathEntry entry = DLTKCore.newLibraryEntry(Path.fromPortableString((String)path), accessRules, extraAttributes, false, true);
                res.add(entry);
            }
            ++i2;
        }
        IBuildpathEntry[] entries = res.toArray(new IBuildpathEntry[res.size()]);
        return new UserLibrary(entries, isSystem, attributes);
    }

    public String toString() {
        if (this.entries == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int length = this.entries.length;
        int i = 0;
        while (i < length) {
            buffer.append(String.valueOf(this.entries[i].toString()) + '\n');
            ++i;
        }
        return buffer.toString();
    }
}

