/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.preferences.IPreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class OptionsConfigurationBlock {
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    private final IStatusChangeListener fContext;
    protected final IProject fProject;
    private PreferenceKey[] fAllKeys;
    private final IScopeContext[] fLookupOrder;
    private Shell fShell;
    private final IWorkingCopyManager fManager;
    private final IWorkbenchPreferenceContainer fContainer;
    private boolean fInitialized;
    private Map<PreferenceKey, String> fDisabledProjectSettings;
    private int fRebuildCount;
    private List<ExpandableComposite> fExpandedComposites = new ArrayList<ExpandableComposite>();
    private static final String SETTINGS_EXPANDED = "expanded";

    public OptionsConfigurationBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        this.fContext = context;
        this.fProject = project;
        this.fAllKeys = allKeys;
        this.fContainer = container;
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        this.testIfOptionsComplete(allKeys);
        this.fRebuildCount = this.getRebuildCount();
    }

    protected void initializeProjectSettings() {
        if (this.fInitialized) {
            return;
        }
        this.fInitialized = true;
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new HashMap<PreferenceKey, String>();
            PreferenceKey[] preferenceKeyArray = this.getPreferenceKeys();
            int n = preferenceKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceKey curr = preferenceKeyArray[n2];
                this.fDisabledProjectSettings.put(curr, curr.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++n2;
            }
        }
    }

    protected void addKeys(List<PreferenceKey> keys) {
        Assert.isLegal((!this.fInitialized ? 1 : 0) != 0);
        LinkedHashSet<PreferenceKey> all = new LinkedHashSet<PreferenceKey>();
        Collections.addAll(all, this.fAllKeys);
        all.addAll(keys);
        if (all.size() != this.fAllKeys.length) {
            this.fAllKeys = all.toArray(new PreferenceKey[all.size()]);
        }
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected static PreferenceKey getKey(String plugin, String key) {
        return new PreferenceKey(plugin, key);
    }

    private void testIfOptionsComplete(PreferenceKey[] allKeys) {
        PreferenceKey[] preferenceKeyArray = allKeys;
        int n = allKeys.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceKey key = preferenceKeyArray[n2];
            this.validateValuePresenceFor(key);
            ++n2;
        }
    }

    protected void validateValuePresenceFor(PreferenceKey key) {
        if (key.getStoredValue(this.fLookupOrder, false, this.fManager) == null) {
            DLTKUIPlugin.logErrorMessage("preference option missing: " + key + " (" + this.getClass().getName() + ')');
        }
    }

    private int getRebuildCount() {
        return this.fManager.getWorkingCopy(DefaultScope.INSTANCE.getNode("org.eclipse.dltk.ui")).getInt(REBUILD_COUNT_KEY, 0);
    }

    private void incrementRebuildCount() {
        ++this.fRebuildCount;
        this.fManager.getWorkingCopy(DefaultScope.INSTANCE.getNode("org.eclipse.dltk.ui")).putInt(REBUILD_COUNT_KEY, this.fRebuildCount);
    }

    protected PreferenceKey[] getPreferenceKeys() {
        return this.fAllKeys;
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            PreferenceKey[] allKeys = this.getPreferenceKeys();
            int i = 0;
            while (i < allKeys.length) {
                if (allKeys[i].getStoredValue((IScopeContext)projectContext, this.fManager) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected boolean checkValue(PreferenceKey key, String value) {
        return value.equals(this.getValue(key));
    }

    protected String getValue(PreferenceKey key) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected boolean getBooleanValue(PreferenceKey key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected int getIntValue(PreferenceKey key) {
        try {
            return Integer.parseInt(this.getValue(key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected String setValue(PreferenceKey key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        key.setStoredValue(this.fLookupOrder[0], value, this.fManager);
        return oldValue;
    }

    protected String setValue(PreferenceKey key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    private boolean getChanges(IScopeContext currContext, List<PreferenceKey> changedSettings) {
        boolean completeSettings = this.fProject != null && this.fDisabledProjectSettings == null;
        boolean needsBuild = false;
        PreferenceKey[] allKeys = this.getPreferenceKeys();
        int i = 0;
        while (i < allKeys.length) {
            PreferenceKey key = allKeys[i];
            String oldVal = key.getStoredValue(currContext, null);
            String val = key.getStoredValue(currContext, this.fManager);
            if (val == null) {
                if (oldVal != null) {
                    changedSettings.add(key);
                    needsBuild |= !oldVal.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                } else if (completeSettings) {
                    key.setStoredValue(currContext, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changedSettings.add(key);
                }
            } else if (!val.equals(oldVal)) {
                changedSettings.add(key);
                needsBuild |= oldVal != null || !val.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
            }
            ++i;
        }
        return needsBuild;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            PreferenceKey[] allKeys = this.getPreferenceKeys();
            if (enable) {
                int i = 0;
                while (i < allKeys.length) {
                    PreferenceKey curr = allKeys[i];
                    String val = this.fDisabledProjectSettings.get(curr);
                    curr.setStoredValue(this.fLookupOrder[0], val, this.fManager);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
            } else {
                this.fDisabledProjectSettings = new HashMap<PreferenceKey, String>();
                int i = 0;
                while (i < allKeys.length) {
                    PreferenceKey curr = allKeys[i];
                    String oldSetting = curr.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    curr.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++i;
                }
            }
        }
    }

    public boolean areSettingsEnabled() {
        return this.fDisabledProjectSettings == null || this.fProject == null;
    }

    public boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    public boolean performApply() {
        return this.processChanges(null);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        block12: {
            Job job;
            int n;
            boolean doBuild;
            block11: {
                IPreferenceChangeRebuildPrompt prompt;
                int count;
                IScopeContext currContext = this.fLookupOrder[0];
                ArrayList<PreferenceKey> changedOptions = new ArrayList<PreferenceKey>();
                boolean needsBuild = this.getChanges(currContext, changedOptions);
                if (changedOptions.isEmpty()) {
                    return true;
                }
                if (needsBuild && (count = this.getRebuildCount()) > this.fRebuildCount) {
                    needsBuild = false;
                    this.fRebuildCount = count;
                }
                doBuild = false;
                if (needsBuild && (prompt = this.getPreferenceChangeRebuildPrompt(this.fProject == null, changedOptions)) != null) {
                    MessageDialog dialog = new MessageDialog(this.getShell(), prompt.getTitle(), null, prompt.getMessage(), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                    int res = dialog.open();
                    if (res == 0) {
                        doBuild = true;
                    } else if (res != 1) {
                        return false;
                    }
                }
                if (container == null) break block11;
                if (!doBuild) break block12;
                this.incrementRebuildCount();
                Job[] jobArray = this.createBuildJobs(this.fProject);
                n = jobArray.length;
                int n2 = 0;
                while (n2 < n) {
                    job = jobArray[n2];
                    container.registerUpdateJob(job);
                    ++n2;
                }
                break block12;
            }
            try {
                this.fManager.applyChanges();
            }
            catch (BackingStoreException e) {
                DLTKUIPlugin.log(e);
                return false;
            }
            if (doBuild) {
                Job[] jobArray = this.createBuildJobs(this.fProject);
                n = jobArray.length;
                int n3 = 0;
                while (n3 < n) {
                    job = jobArray[n3];
                    job.schedule();
                    ++n3;
                }
            }
        }
        return true;
    }

    protected Job[] createBuildJobs(IProject project) {
        return new Job[]{CoreUtility.getBuildJob(project)};
    }

    public void performDefaults() {
        PreferenceKey[] allKeys = this.getPreferenceKeys();
        int i = 0;
        while (i < allKeys.length) {
            PreferenceKey curr = allKeys[i];
            String origValue = curr.getStoredValue(this.fLookupOrder, true, this.fManager);
            this.setValue(curr, origValue);
            ++i;
        }
    }

    protected IPreferenceChangeRebuildPrompt getPreferenceChangeRebuildPrompt(boolean workspaceSettings, Collection<PreferenceKey> changedOptions) {
        return null;
    }

    public void dispose() {
    }

    protected void statusChanged(IStatus status) {
        this.fContext.statusChanged(status);
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandedComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite excomposite = this.fExpandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite curr = this.fExpandedComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }
}

