/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.core.runtime.IConfigurationElement;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;

import org.eclipse.swt.graphics.Image;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Processor Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getProcessor <em>Processor</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getConfigurationElement <em>Configuration Element</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getIcon16 <em>Icon16</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getContributor <em>Contributor</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDirective <em>Directive</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#isAutomatic <em>Automatic</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor()
 * @model
 * @generated
 */
public interface IProcessorDescriptor extends EObject {
	/**
	 * Returns the value of the '<em><b>Processor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Processor</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Processor</em>' attribute.
	 * @see #setProcessor(ReportProcessorSafeWrapper)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Processor()
	 * @model dataType="org.eclipse.epp.internal.logging.aeri.ide.ReportProcessorSafeWrapper"
	 * @generated
	 */
	ReportProcessorSafeWrapper getProcessor();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getProcessor <em>Processor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Processor</em>' attribute.
	 * @see #getProcessor()
	 * @generated
	 */
	void setProcessor(ReportProcessorSafeWrapper value);

	/**
	 * Returns the value of the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configuration Element</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configuration Element</em>' attribute.
	 * @see #setConfigurationElement(IConfigurationElement)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_ConfigurationElement()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IConfigurationElement"
	 * @generated
	 */
	IConfigurationElement getConfigurationElement();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getConfigurationElement <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configuration Element</em>' attribute.
	 * @see #getConfigurationElement()
	 * @generated
	 */
	void setConfigurationElement(IConfigurationElement value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Icon16</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Icon16</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Icon16</em>' attribute.
	 * @see #setIcon16(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Icon16()
	 * @model
	 * @generated
	 */
	String getIcon16();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getIcon16 <em>Icon16</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Icon16</em>' attribute.
	 * @see #getIcon16()
	 * @generated
	 */
	void setIcon16(String value);

	/**
	 * Returns the value of the '<em><b>Contributor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Contributor</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contributor</em>' attribute.
	 * @see #setContributor(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Contributor()
	 * @model
	 * @generated
	 */
	String getContributor();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getContributor <em>Contributor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Contributor</em>' attribute.
	 * @see #getContributor()
	 * @generated
	 */
	void setContributor(String value);

	/**
	 * Returns the value of the '<em><b>Directive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Directive</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Directive</em>' attribute.
	 * @see #setDirective(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Directive()
	 * @model
	 * @generated
	 */
	String getDirective();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDirective <em>Directive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Directive</em>' attribute.
	 * @see #getDirective()
	 * @generated
	 */
	void setDirective(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Automatic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Automatic</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Automatic</em>' attribute.
	 * @see #setAutomatic(boolean)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getProcessorDescriptor_Automatic()
	 * @model
	 * @generated
	 */
	boolean isAutomatic();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#isAutomatic <em>Automatic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Automatic</em>' attribute.
	 * @see #isAutomatic()
	 * @generated
	 */
	void setAutomatic(boolean value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" dataType="org.eclipse.epp.internal.logging.aeri.ide.Image"
	 * @generated
	 */
	Image getImage16();

} // IProcessorDescriptor
