/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.clustermode.ClusterMode;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.outputmode.OutputMode;
import org.eclipse.gef.dot.internal.language.pagedir.Pagedir;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.ranktype.RankType;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.style.ClusterStyle;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.contentassist.DotColorProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.contentassist.DotProposalProviderDelegator;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivatorEx;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public class DotProposalProvider
extends AbstractDotProposalProvider {
    @Inject
    private DotGrammarAccess dotGrammarAccess;
    @Inject
    private IImageHelper imageHelper;
    private static Map<DotAttributes.Context, List<String>> dotAttributeNames;
    private String[] booleanAttributeValuesProposals = new String[]{"true", "false"};

    public DotProposalProvider() {
        if (dotAttributeNames == null) {
            dotAttributeNames = this.getDotAttributeNames();
        }
    }

    protected ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, int priority, final String prefix, final ContentAssistContext context) {
        ICompletionProposal completionProposal;
        EObject currentModel = context.getCurrentModel();
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)currentModel, DotGraph.class);
        if (dotGraph != null) {
            GraphType graphType = dotGraph.getType();
            if (EdgeOp.get((String)proposal) != null) {
                if (graphType == GraphType.DIGRAPH && proposal.equals(EdgeOp.UNDIRECTED.toString())) {
                    return null;
                }
                if (graphType == GraphType.GRAPH && proposal.equals(EdgeOp.DIRECTED.toString())) {
                    return null;
                }
                String format = "%s: Edge";
                displayString = DotEditorUtils.style(format, proposal);
            }
        }
        if (prefix.equals("=") && proposal.equals("=")) {
            return null;
        }
        if (prefix.equals("[") && proposal.equals("[")) {
            return null;
        }
        if ("subgraph".equals(proposal)) {
            String format = "%s: Subgraph";
            displayString = DotEditorUtils.style(format, proposal);
        }
        if ((completionProposal = super.createCompletionProposal(proposal, displayString, image, priority, prefix, context)) instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
            if (dotGraph != null && AttributeType.get((String)proposal) != null && !context.getLastCompleteNode().getText().equals("strict")) {
                String format = "%s[]: Attributes";
                StyledString newDisplayString = DotEditorUtils.style(format, displayString);
                configurableCompletionProposal.setDisplayString(newDisplayString);
                configurableCompletionProposal.setReplacementString(String.valueOf(configurableCompletionProposal.getReplacementString()) + "[]");
                configurableCompletionProposal.setCursorPosition(configurableCompletionProposal.getCursorPosition() + 1);
            }
            if (context.getMatcher() instanceof AttributeValueMatcher) {
                if (configurableCompletionProposal.getReplacementString().length() == 0) {
                    configurableCompletionProposal.setDisplayString("\"\"");
                }
                configurableCompletionProposal.setTextApplier(new ConfigurableCompletionProposal.IReplacementTextApplier(configurableCompletionProposal){
                    private final ConfigurableCompletionProposal.IReplacementTextApplier initialTextApplier;
                    {
                        this.initialTextApplier = configurableCompletionProposal.getTextApplier();
                    }

                    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                        String original = document.get(proposal.getReplacementOffset(), proposal.getReplacementLength());
                        String replacement = proposal.getReplacementString();
                        int replacementOffset = proposal.getReplacementOffset();
                        int replacementLength = proposal.getReplacementLength();
                        if (original.startsWith("\"") && (original.length() == 1 || !original.endsWith("\""))) {
                            Character listSeparator = ((AttributeValueMatcher)context.getMatcher()).getListSeparator();
                            if (listSeparator != null && prefix.contains(listSeparator.toString())) {
                                proposal.setReplacementOffset(replacementOffset + original.lastIndexOf(listSeparator.charValue(), prefix.length() - 1) + 1);
                                proposal.setReplacementLength(replacementLength - original.lastIndexOf(listSeparator.charValue(), prefix.length() - 1) - 1);
                            } else {
                                proposal.setReplacementOffset(replacementOffset + 1);
                                proposal.setReplacementLength(replacementLength - 1);
                            }
                        } else {
                            String idValue = ID.fromValue((String)replacement).toString();
                            boolean idIsQuoted = idValue.startsWith("\"");
                            if (idIsQuoted) {
                                proposal.setReplacementString(idValue);
                                proposal.setCursorPosition(idValue.length());
                            }
                        }
                        if (this.initialTextApplier == null) {
                            document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposal.getReplacementString());
                        } else {
                            this.initialTextApplier.apply(document, proposal);
                        }
                    }
                });
            }
        }
        return completionProposal;
    }

    @Override
    public void completePort_Compass_pt(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Keyword k : EcoreUtil2.getAllContentsOfType((EObject)this.dotGrammarAccess.getCOMPASS_PTRule().getAlternatives(), Keyword.class)) {
            acceptor.accept(this.createCompletionProposal(k.getValue(), context));
        }
        super.completePort_Compass_pt(model, assignment, context, acceptor);
    }

    @Override
    public void completeAttribute_Name(EObject model, Assignment assignment, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject modelCompleted;
        super.completeAttribute_Name(model, assignment, contentAssistContext, acceptor);
        EObject eObject = modelCompleted = model instanceof NodeStmt ? model.eContainer() : model;
        if (modelCompleted instanceof AttrList || modelCompleted instanceof DotGraph || modelCompleted instanceof Subgraph) {
            DotAttributes.Context attributeContext = DotAttributes.getContext((EObject)modelCompleted);
            this.proposeAttributeNames(attributeContext, contentAssistContext, acceptor);
        }
    }

    @Override
    public void completeAttribute_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block196: {
            block193: {
                block203: {
                    Attribute attribute;
                    block201: {
                        block199: {
                            block197: {
                                block194: {
                                    if (!(model instanceof Attribute)) break block193;
                                    attribute = (Attribute)model;
                                    context = context.copy().setMatcher((PrefixMatcher)new AttributeValueMatcher(context.getMatcher())).toContext();
                                    if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.EDGE) break block194;
                                    switch (attribute.getName().toValue()) {
                                        case "arrowhead": 
                                        case "arrowtail": {
                                            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotArrowType", context, acceptor);
                                            break;
                                        }
                                        case "color": {
                                            this.proposeColorListAttributeValues(attribute, context, acceptor);
                                            break;
                                        }
                                        case "edgetooltip": 
                                        case "tooltip": 
                                        case "labeltooltip": 
                                        case "headtooltip": 
                                        case "tailtooltip": {
                                            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotEscString", context, acceptor);
                                            break;
                                        }
                                        case "fillcolor": {
                                            this.proposeColorAttributeValues(attribute, context, acceptor);
                                            break;
                                        }
                                        case "fontcolor": 
                                        case "labelfontcolor": {
                                            this.proposeColorAttributeValues(attribute, context, acceptor);
                                            break;
                                        }
                                        case "colorscheme": {
                                            this.proposeColorSchemeAttributeValues(context, acceptor);
                                            break;
                                        }
                                        case "dir": {
                                            this.proposeAttributeValues(DirType.values(), context, acceptor);
                                            break;
                                        }
                                        case "labelfontname": 
                                        case "fontname": {
                                            this.proposeFontNameAttributeValues(context, acceptor);
                                            break;
                                        }
                                        case "tail_lp": 
                                        case "lp": 
                                        case "xlp": 
                                        case "head_lp": {
                                            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                            break;
                                        }
                                        case "xlabel": 
                                        case "headlabel": 
                                        case "taillabel": 
                                        case "label": {
                                            this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                            break;
                                        }
                                        case "headport": 
                                        case "tailport": {
                                            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPortPos", context, acceptor);
                                            break;
                                        }
                                        case "pos": {
                                            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotSplineType", context, acceptor);
                                            break;
                                        }
                                        case "style": {
                                            ((AttributeValueMatcher)context.getMatcher()).setListSeparator(',');
                                            this.proposeAttributeValues(EdgeStyle.VALUES, context, acceptor);
                                            break;
                                        }
                                        default: {
                                            super.completeAttribute_Value(model, assignment, context, acceptor);
                                            break;
                                        }
                                    }
                                    break block196;
                                }
                                if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.GRAPH) break block197;
                                switch (attribute.getName().toValue()) {
                                    case "bgcolor": {
                                        this.proposeColorListAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "fontcolor": {
                                        this.proposeColorAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "clusterrank": {
                                        this.proposeAttributeValues(ClusterMode.values(), context, acceptor);
                                        break;
                                    }
                                    case "colorscheme": {
                                        this.proposeColorSchemeAttributeValues(context, acceptor);
                                        break;
                                    }
                                    case "fontname": {
                                        this.proposeFontNameAttributeValues(context, acceptor);
                                        break;
                                    }
                                    case "forcelabels": {
                                        this.proposeAttributeValues(this.booleanAttributeValuesProposals, context, acceptor);
                                        break;
                                    }
                                    case "label": {
                                        this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "layout": {
                                        this.proposeAttributeValues(Layout.values(), context, acceptor);
                                        break;
                                    }
                                    case "lp": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                        break;
                                    }
                                    case "outputorder": {
                                        this.proposeAttributeValues(OutputMode.values(), context, acceptor);
                                        break;
                                    }
                                    case "pagedir": {
                                        this.proposeAttributeValues(Pagedir.values(), context, acceptor);
                                        break;
                                    }
                                    case "rankdir": {
                                        this.proposeAttributeValues(Rankdir.values(), context, acceptor);
                                        break;
                                    }
                                    case "splines": {
                                        this.proposeAttributeValues(Splines.values(), context, acceptor);
                                        break;
                                    }
                                    default: {
                                        super.completeAttribute_Value(model, assignment, context, acceptor);
                                        break;
                                    }
                                }
                                break block196;
                            }
                            if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.NODE) break block199;
                            switch (attribute.getName().toValue()) {
                                case "color": {
                                    this.proposeColorAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "fillcolor": {
                                    this.proposeColorListAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "fontcolor": {
                                    this.proposeColorAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "colorscheme": {
                                    this.proposeColorSchemeAttributeValues(context, acceptor);
                                    break;
                                }
                                case "fixedsize": {
                                    this.proposeAttributeValues(this.booleanAttributeValuesProposals, context, acceptor);
                                    break;
                                }
                                case "fontname": {
                                    this.proposeFontNameAttributeValues(context, acceptor);
                                    break;
                                }
                                case "xlabel": 
                                case "label": {
                                    this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "pos": 
                                case "xlp": {
                                    this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                    break;
                                }
                                case "shape": {
                                    this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotShape", context, acceptor);
                                    break;
                                }
                                case "style": {
                                    ((AttributeValueMatcher)context.getMatcher()).setListSeparator(',');
                                    this.proposeAttributeValues(NodeStyle.VALUES, context, acceptor);
                                    break;
                                }
                                case "tooltip": {
                                    this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotEscString", context, acceptor);
                                }
                            }
                            break block196;
                        }
                        if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.CLUSTER) break block201;
                        switch (attribute.getName().toValue()) {
                            case "bgcolor": {
                                this.proposeColorListAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "color": {
                                this.proposeColorAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "colorscheme": {
                                this.proposeColorSchemeAttributeValues(context, acceptor);
                                break;
                            }
                            case "fillcolor": {
                                this.proposeColorListAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "fontcolor": {
                                this.proposeColorAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "fontname": {
                                this.proposeFontNameAttributeValues(context, acceptor);
                                break;
                            }
                            case "label": {
                                this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "style": {
                                ((AttributeValueMatcher)context.getMatcher()).setListSeparator(',');
                                this.proposeAttributeValues(ClusterStyle.VALUES, context, acceptor);
                                break;
                            }
                            case "tooltip": {
                                this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotEscString", context, acceptor);
                            }
                        }
                        break block196;
                    }
                    if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.SUBGRAPH) break block203;
                    switch (attribute.getName().toValue()) {
                        case "rank": {
                            this.proposeAttributeValues(RankType.values(), context, acceptor);
                        }
                    }
                    break block196;
                }
                super.completeAttribute_Value(model, assignment, context, acceptor);
                break block196;
            }
            super.completeAttribute_Value(model, assignment, context, acceptor);
        }
    }

    private void proposeAttributeNames(DotAttributes.Context attributeContext, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        Image attributeImage = this.imageHelper.getImage("attribute.png");
        String format = "%s: Attribute";
        for (String attributeName : dotAttributeNames.get(attributeContext)) {
            StyledString displayString = DotEditorUtils.style(format, attributeName);
            ICompletionProposal completionProposal = this.createCompletionProposal(attributeName, displayString, attributeImage, contentAssistContext);
            if (completionProposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
                configurableCompletionProposal.setReplacementString(String.valueOf(configurableCompletionProposal.getReplacementString()) + "=");
                configurableCompletionProposal.setCursorPosition(configurableCompletionProposal.getCursorPosition() + 1);
            }
            acceptor.accept(completionProposal);
        }
    }

    private void proposeAttributeValues(String subgrammarName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String text = context.getPrefix();
        if (text.startsWith("\"")) {
            text = ID.fromString((String)text, (ID.Type)ID.Type.QUOTED_STRING).toValue();
            context = context.copy().setPrefix(text).toContext();
        }
        if (text.startsWith("<")) {
            text = text.substring(1);
            context = context.copy().setPrefix(text).toContext();
        }
        List<ConfigurableCompletionProposal> configurableCompletionProposals = new DotProposalProviderDelegator(subgrammarName).computeConfigurableCompletionProposals(text, text.length());
        for (ConfigurableCompletionProposal configurableCompletionProposal : configurableCompletionProposals) {
            configurableCompletionProposal.setReplacementOffset(context.getOffset() - configurableCompletionProposal.getReplaceContextLength());
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    private void proposeAttributeValues(Object[] values, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues(Arrays.asList(values), context, acceptor);
    }

    private void proposeAttributeValues(List<?> values, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        values.forEach(value -> acceptor.accept(this.createCompletionProposal(value.toString(), context)));
    }

    private void proposeColorAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DotColorProposalProvider.globalColorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotColor", context, acceptor);
        DotColorProposalProvider.globalColorScheme = null;
    }

    private void proposeColorListAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DotColorProposalProvider.globalColorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotColorList", context, acceptor);
        DotColorProposalProvider.globalColorScheme = null;
    }

    private void proposeFontNameAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues(PostScriptFontAlias.values(), context, acceptor);
    }

    private void proposeColorSchemeAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues(DotColors.getColorSchemes(), context, acceptor);
    }

    private void proposeHtmlLabelAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DotColorProposalProvider.globalColorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
        if (attribute.getValue() != null && attribute.getValue().getType() == ID.Type.HTML_STRING) {
            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotHtmlLabel", context, acceptor);
        }
        DotColorProposalProvider.globalColorScheme = null;
    }

    private Map<DotAttributes.Context, List<String>> getDotAttributeNames() {
        Field[] declaredFields;
        ArrayList<String> clusterAttributeNames = new ArrayList<String>();
        ArrayList<String> edgeAttributeNames = new ArrayList<String>();
        ArrayList<String> graphAttributeNames = new ArrayList<String>();
        ArrayList<String> nodeAttributeNames = new ArrayList<String>();
        ArrayList<String> subgraphAttributeNames = new ArrayList<String>();
        Field[] fieldArray = declaredFields = DotAttributes.class.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType().equals(String.class)) {
                String fieldName = field.getName();
                String dotClassifier = fieldName.substring(fieldName.lastIndexOf("_") + 1);
                if (!fieldName.startsWith("_")) {
                    String dotAttributeName = null;
                    try {
                        dotAttributeName = (String)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        DotActivatorEx.logError(e);
                    }
                    if (dotAttributeName != null) {
                        if (dotClassifier.contains("C")) {
                            clusterAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("E")) {
                            edgeAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("G")) {
                            graphAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("N")) {
                            nodeAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("S")) {
                            subgraphAttributeNames.add(dotAttributeName);
                        }
                    }
                }
            }
            ++n2;
        }
        HashMap<DotAttributes.Context, List<String>> dotAttributeNames = new HashMap<DotAttributes.Context, List<String>>();
        dotAttributeNames.put(DotAttributes.Context.CLUSTER, clusterAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.EDGE, edgeAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.GRAPH, graphAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.NODE, nodeAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.SUBGRAPH, subgraphAttributeNames);
        return dotAttributeNames;
    }

    private static class AttributeValueMatcher
    extends PrefixMatcher {
        private final PrefixMatcher originalMatcher;
        private Character listSeparator = null;

        public AttributeValueMatcher(PrefixMatcher originalMatcher) {
            this.originalMatcher = originalMatcher;
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            if (prefix.trim().startsWith("\"")) {
                if (this.listSeparator != null && prefix.contains(",")) {
                    return this.listMatch(name, prefix);
                }
                return this.quoteMatch(name, prefix);
            }
            return this.standardMatch(name, prefix);
        }

        public void setListSeparator(char listSeparator) {
            this.listSeparator = Character.valueOf(listSeparator);
        }

        public Character getListSeparator() {
            return this.listSeparator;
        }

        private boolean standardMatch(String name, String prefix) {
            return this.originalMatcher.isCandidateMatchingPrefix(name, prefix);
        }

        private boolean quoteMatch(String name, String prefix) {
            return this.originalMatcher.isCandidateMatchingPrefix(name, prefix.substring(1));
        }

        private boolean listMatch(String name, String prefix) {
            return this.originalMatcher.isCandidateMatchingPrefix(name, prefix.substring(prefix.lastIndexOf(44) + 1).trim());
        }
    }
}

