/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts.directedit;

import org.eclipse.graphiti.func.IProposal;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends org.eclipse.jface.viewers.TextCellEditor {
    private static final int defaultStyle = 4;
    private ModifyListener modifyListener;
    private IProposal acceptedProposal = null;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public TextCellEditor() {
        this.setStyle(4);
    }

    public TextCellEditor(Composite parent) {
        this(parent, 4);
    }

    public TextCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createControl(Composite parent) {
        this.text = new Text(parent, this.getStyle());
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TextCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (TextCellEditor.this.text != null && !TextCellEditor.this.text.isDisposed() && (TextCellEditor.this.text.getStyle() & 2) != 0 && e.character == '\r' && (e.stateMask & 0x20000) == 0) {
                    TextCellEditor.this.handleDefaultSelection(null);
                }
                TextCellEditor.this.keyReleaseOccured(e);
                if (TextCellEditor.this.getControl() == null || TextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TextCellEditor.this.checkSelection();
                TextCellEditor.this.checkDeleteable();
                TextCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TextCellEditor.this.checkSelection();
                TextCellEditor.this.checkDeleteable();
                TextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Object data;
                Shell shell;
                if (e.display != null && (shell = e.display.getActiveShell()) != null && (data = shell.getData()) != null && data instanceof PopupDialog) {
                    return;
                }
                TextCellEditor.this.focusLost();
            }
        });
        this.text.setFont(parent.getFont());
        this.text.setBackground(parent.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    public IProposal getAcceptedProposal() {
        return this.acceptedProposal;
    }

    public void setAcceptedProposal(IProposal acceptedProposal) {
        this.acceptedProposal = acceptedProposal;
    }
}

