/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.RunningAutsViewLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class RunningAutsView
extends ViewPart
implements DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IProjectStateListener {
    private IAutRegistrationListener m_autRegListener;
    private ListViewer m_runningAutComponent;
    private WritableList m_runningAuts;
    private Realm m_viewRealm;

    public void createPartControl(Composite parent) {
        this.m_runningAuts = new WritableList();
        this.m_runningAutComponent = new ListViewer(parent);
        this.m_viewRealm = Realm.getDefault();
        ViewerSupport.bind((StructuredViewer)this.m_runningAutComponent, (IObservableList)this.m_runningAuts, (IValueProperty)PojoProperties.value((String)"executableName"));
        this.m_autRegListener = new IAutRegistrationListener(){

            public void handleAutRegistration(final AutRegistrationEvent event) {
                RunningAutsView.this.m_viewRealm.exec(new Runnable(){

                    @Override
                    public void run() {
                        switch (event.getStatus()) {
                            case Register: {
                                RunningAutsView.this.m_runningAuts.add((Object)event.getAutId());
                                break;
                            }
                            case Deregister: {
                                RunningAutsView.this.m_runningAuts.remove((Object)event.getAutId());
                                break;
                            }
                        }
                    }
                });
            }
        };
        AutAgentRegistration.getInstance().addListener(this.m_autRegListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_runningAutComponent);
        this.m_runningAutComponent.setLabelProvider((IBaseLabelProvider)new RunningAutsViewLabelProvider());
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        Plugin.getHelpSystem().setHelp(this.m_runningAutComponent.getControl(), "org.eclipse.jubula.client.ua.help.runningAutsViewContextId");
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.m_runningAutComponent.getControl());
        this.m_runningAutComponent.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_runningAutComponent);
    }

    public void setFocus() {
        this.m_runningAutComponent.getControl().setFocus();
    }

    public void dispose() {
        AutAgentRegistration.getInstance().removeListener(this.m_autRegListener);
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        ded.removeProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        super.dispose();
    }

    public void handleProjectLoaded() {
        this.refreshViewer();
    }

    private void refreshViewer() {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RunningAutsView.this.m_runningAutComponent.refresh(true);
            }
        });
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        if (DataEventDispatcher.ProjectState.prop_modified.equals((Object)state)) {
            this.refreshViewer();
        }
    }
}

