/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.labelprovider.decorators;

import java.util.Date;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.provider.labelprovider.decorators.AbstractLightweightLabelDecorator;

public class TestResultDurationDecorator
extends AbstractLightweightLabelDecorator {
    private static final String SUFFIX_SPACER = " - ";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof TestResultNode) {
            TestResultNode testResult = (TestResultNode)element;
            if (testResult.getNode() instanceof ICommentPO) {
                return;
            }
            Object testSuiteEndTimeValue = decoration.getDecorationContext().getProperty("org.eclipse.jubula.client.ui.editors.TestResultViewer.testSuiteEndTime");
            Date endTime = testSuiteEndTimeValue instanceof Date ? (Date)testSuiteEndTimeValue : null;
            long durationMillis = testResult.getDuration(endTime);
            if (durationMillis != -1L) {
                decoration.addSuffix(SUFFIX_SPACER + DurationFormatUtils.formatDurationHMS((long)durationMillis));
            }
        }
    }
}

