/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import java.util.BitSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.actions.GotoAction;
import org.eclipse.ptp.internal.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.internal.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.AbstractParallelElementView;

public class CreateSetAction
extends GotoDropDownAction {
    public static final String name = Messages.CreateSetAction_0;

    public CreateSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_CREATESET_NORMAL);
    }

    @Override
    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        String curID = this.view.getCurrentSetID();
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElementSet[] iElementSetArray = setManager.getSets();
        int n = iElementSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementSet set = iElementSetArray[n2];
            this.addAction(dropDownMenuMgr, set.getID(), set.getID(), curID, null);
            ++n2;
        }
    }

    @Override
    protected void addAction(MenuManager dropDownMenuMgr, String e_name, String id, String curID, Object data) {
        InternalSetAction action = new InternalSetAction(String.valueOf(Messages.CreateSetAction_1) + e_name, id, this.view, this);
        action.setEnabled(!curID.equals(id));
        dropDownMenuMgr.add((IAction)action);
    }

    @Override
    public void run(BitSet elements) {
        this.run(elements, null, null);
    }

    @Override
    public void run(BitSet elements, String setID, Object data) {
        if (this.validation(elements)) {
            final IElementHandler setManager = this.view.getCurrentElementHandler();
            if (setManager == null) {
                return;
            }
            if (setID == null) {
                IInputValidator inputValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.length() == 0) {
                            return Messages.CreateSetAction_2;
                        }
                        if (setManager.getSet(newText) != null) {
                            return NLS.bind((String)Messages.CreateSetAction_5, (Object)newText);
                        }
                        return null;
                    }
                };
                InputDialog inputDialog = new InputDialog(this.getShell(), Messages.CreateSetAction_3, Messages.CreateSetAction_4, "", inputValidator);
                if (inputDialog.open() == 1) {
                    return;
                }
                setID = inputDialog.getValue();
                this.view.getUIManager().createSet(setID, setID, setManager, elements);
            } else {
                this.view.getUIManager().addToSet(setID, setManager, elements);
            }
            this.view.selectSet(setManager.getSet(setID));
            this.view.refresh(false);
        }
    }

    private class InternalSetAction
    extends GotoAction {
        public InternalSetAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action, null);
            this.setImageDescriptor(ParallelImages.ID_ICON_CREATESET_NORMAL);
        }
    }
}

