/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.lookup;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchShellLookup;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkbenchPartMenuLookup {
    private static WorkbenchPartMenuLookup instance;

    public static WorkbenchPartMenuLookup getInstance() {
        if (instance == null) {
            instance = new WorkbenchPartMenuLookup();
        }
        return instance;
    }

    public Menu getViewMenu() {
        IWorkbenchPart part = this.getActivePart(false);
        final IMenuManager m = ((IViewSite)part.getSite()).getActionBars().getMenuManager();
        if (m instanceof MenuManager) {
            return (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

                public Menu run() {
                    MenuManager manager = (MenuManager)m;
                    manager.createContextMenu((Control)WorkbenchShellLookup.getInstance().getWorkbenchShell());
                    manager.update(false);
                    return ((MenuManager)m).getMenu();
                }
            });
        }
        return null;
    }

    private IWorkbenchPart getActivePart(final boolean restore) {
        IWorkbenchPart result = (IWorkbenchPart)Display.syncExec((ResultRunnable)new ResultRunnable<IWorkbenchPart>(){

            public IWorkbenchPart run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                IWorkbenchPartReference activePartReference = activePage.getActivePartReference();
                IWorkbenchPart part = activePartReference.getPart(restore);
                return part;
            }
        });
        return result;
    }
}

