/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.importexport;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.importexport.TranslationImportExportWizardExtension;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractImportExportWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class TranslationImportExportWizardPage
extends WizardPage {
    private final TranslationStoreStack m_project;
    private final List<TranslationImportExportWizardExtension> m_extensions;
    private IWizardPage m_nextPage;

    public TranslationImportExportWizardPage(String title, String description, TranslationStoreStack project, List<TranslationImportExportWizardExtension> extensions) {
        super(TranslationImportExportWizardPage.class.getName());
        this.m_project = project;
        this.m_extensions = extensions;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        Table table = new Table(parent, 68100);
        TableViewer viewer = new TableViewer(table);
        P_TableContentProvider provider = new P_TableContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        viewer.setContentProvider((IContentProvider)provider);
        viewer.setInput((Object)provider);
        viewer.addDoubleClickListener(event -> {
            IWizardContainer container;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            TranslationImportExportWizardExtension extension = null;
            if (!selection.isEmpty()) {
                extension = (TranslationImportExportWizardExtension)selection.getFirstElement();
            }
            this.handleWizardExtensionSelected(extension);
            IWizardPage page = this.getNextPage();
            if (page != null && (container = this.getWizard().getContainer()) != null) {
                container.showPage(page);
            }
        });
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            TranslationImportExportWizardExtension extension = null;
            if (!selection.isEmpty()) {
                extension = (TranslationImportExportWizardExtension)selection.getFirstElement();
            }
            this.handleWizardExtensionSelected(extension);
        });
        this.setControl((Control)table);
    }

    private void handleWizardExtensionSelected(TranslationImportExportWizardExtension extension) {
        boolean pageComplete = false;
        if (extension != null) {
            AbstractImportExportWizard wizard = extension.createWizard();
            wizard.setNlsProject(this.m_project);
            wizard.addPages();
            if (wizard.getPageCount() > 0) {
                this.setNextPage(wizard.getPages()[0]);
                pageComplete = true;
            }
        }
        this.setPageComplete(pageComplete);
    }

    public IWizardPage getNextPage() {
        return this.m_nextPage;
    }

    private void setNextPage(IWizardPage nextPage) {
        this.m_nextPage = nextPage;
    }

    private class P_TableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private P_TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return TranslationImportExportWizardPage.this.m_extensions.toArray();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((TranslationImportExportWizardExtension)element).getName();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }
}

