/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.proposal;

import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public abstract class AbstractTranslationProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private final String m_searchText;
    private final int m_initialOffset;
    private Point m_selection;

    protected AbstractTranslationProposal(String searchText, int initialOffset) {
        this.m_searchText = searchText;
        this.m_initialOffset = initialOffset;
    }

    public int getInitialOffset() {
        return this.m_initialOffset;
    }

    public String getPrefix() {
        return this.m_searchText;
    }

    public int getRelevance() {
        return -1;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return null;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return 0;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            Point keyRange = AbstractTranslationProposal.findKeyRange(document, offset);
            if (keyRange != null) {
                return keyRange.x < offset && keyRange.y >= offset;
            }
        }
        catch (BadLocationException e) {
            SdkLog.error((Object[])new Object[]{e});
        }
        return false;
    }

    public void apply(IDocument document) {
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument(), trigger, offset);
    }

    protected static Point findKeyRange(IDocument document, int offset) throws BadLocationException {
        IRegion lineRange = document.getLineInformationOfOffset(offset);
        int startOffest = -1;
        int index = offset - 1;
        while (index > 0 && index > lineRange.getOffset()) {
            if (document.getChar(index) == '\"') {
                if (index > 1) {
                    if (document.getChar(index - 1) != '\\') {
                        startOffest = index + 1;
                        break;
                    }
                } else {
                    startOffest = index + 1;
                    break;
                }
            }
            --index;
        }
        int endOffset = -1;
        index = offset;
        boolean masked = false;
        while (document.getLength() > index && index < lineRange.getOffset() + lineRange.getLength()) {
            if (masked) {
                masked = false;
            } else if (document.getChar(index) == '\\') {
                masked = true;
            } else if (document.getChar(index) == '\"') {
                endOffset = index;
                break;
            }
            ++index;
        }
        if (startOffest > -1) {
            if (endOffset < 0) {
                endOffset = lineRange.getOffset() + lineRange.getLength();
            }
            return new Point(startOffest, endOffset);
        }
        return null;
    }

    protected void replaceWith(IDocument document, int offset, String replacement) throws BadLocationException {
        Point keyRange = AbstractTranslationProposal.findKeyRange(document, offset);
        if (keyRange != null) {
            this.m_selection = new Point(keyRange.x, replacement.length());
            ReplaceEdit replaceEdit = new ReplaceEdit(keyRange.x, keyRange.y - keyRange.x, replacement);
            try {
                replaceEdit.apply(document);
            }
            catch (BadLocationException | MalformedTreeException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
        }
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 0;
    }

    public Point getSelection(IDocument document) {
        return this.m_selection;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

