/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class JoinNode
extends DualInputNode {
    private final DualInputNode.NetworkStructureChangeSensitiveLogic TIMELESS = new DualInputNode.NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            if (JoinNode.this.primarySlot == null || JoinNode.this.secondarySlot == null) {
                return;
            }
            if (flush) {
                JoinNode.this.reteContainer.flushUpdates();
            }
            for (Tuple signature : JoinNode.this.primarySlot.getSignatures()) {
                Collection<Tuple> primaries = JoinNode.this.primarySlot.get(signature);
                Collection<Tuple> opposites = JoinNode.this.secondarySlot.get(signature);
                if (opposites == null) continue;
                for (Tuple primary : primaries) {
                    for (Tuple opposite : opposites) {
                        collector.add(JoinNode.this.unify(primary, opposite));
                    }
                }
            }
        }

        @Override
        public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
            if (!$assertionsDisabled && timestamp != Timestamp.ZERO) {
                throw new AssertionError();
            }
            Collection<Tuple> opposites = JoinNode.this.retrieveOpposites(side, signature);
            if (!JoinNode.this.coincidence) {
                if (opposites != null) {
                    for (Tuple opposite : opposites) {
                        JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(side, updateElement, opposite), timestamp);
                    }
                }
            } else {
                if (opposites != null) {
                    for (Tuple opposite : opposites) {
                        if (opposite.equals((Object)updateElement)) continue;
                        JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(opposite, updateElement), timestamp);
                        JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(updateElement, opposite), timestamp);
                    }
                }
                JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(updateElement, updateElement), timestamp);
            }
        }
    };
    private final DualInputNode.NetworkStructureChangeSensitiveLogic TIMELY = new DualInputNode.NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
            if (JoinNode.this.primarySlot == null || JoinNode.this.secondarySlot == null) {
                return;
            }
            if (flush) {
                JoinNode.this.reteContainer.flushUpdates();
            }
            for (Tuple signature : JoinNode.this.primarySlot.getSignatures()) {
                Map<Tuple, Timestamp> primaries = JoinNode.this.getWithTimestamp(signature, JoinNode.this.primarySlot);
                Map<Tuple, Timestamp> opposites = JoinNode.this.getWithTimestamp(signature, JoinNode.this.secondarySlot);
                if (opposites == null) continue;
                for (Tuple primary : primaries.keySet()) {
                    Timestamp primaryTimestamp = primaries.get(primary);
                    for (Tuple opposite : opposites.keySet()) {
                        collector.put(JoinNode.this.unify(primary, opposite), primaryTimestamp.max(opposites.get(opposite)));
                    }
                }
            }
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            JoinNode.this.TIMELESS.pullInto(collector, flush);
        }

        @Override
        public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
            Indexer oppositeIndexer = JoinNode.this.getSlot(side.opposite());
            Map<Tuple, Timestamp> opposites = JoinNode.this.getWithTimestamp(signature, oppositeIndexer);
            if (!JoinNode.this.coincidence) {
                if (opposites != null) {
                    for (Tuple opposite : opposites.keySet()) {
                        JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(side, updateElement, opposite), timestamp.max(opposites.get(opposite)));
                    }
                }
            } else {
                if (opposites != null) {
                    for (Tuple opposite : opposites.keySet()) {
                        if (opposite.equals((Object)updateElement)) continue;
                        Timestamp oppositeTimestamp = opposites.get(opposite);
                        JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(opposite, updateElement), timestamp.max(oppositeTimestamp));
                        JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(updateElement, opposite), timestamp.max(oppositeTimestamp));
                    }
                }
                JoinNode.this.propagateUpdate(direction, JoinNode.this.unify(updateElement, updateElement), timestamp);
            }
        }
    };

    public JoinNode(ReteContainer reteContainer, TupleMask complementerSecondaryMask) {
        super(reteContainer, complementerSecondaryMask);
        this.logic = this.createLogic();
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return this.unify(primary, secondary);
    }

    @Override
    protected DualInputNode.NetworkStructureChangeSensitiveLogic createTimelessLogic() {
        return this.TIMELESS;
    }

    @Override
    protected DualInputNode.NetworkStructureChangeSensitiveLogic createTimelyLogic() {
        return this.TIMELY;
    }
}

