/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.figure.OutlineImageFigure;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.IHeadersProvider;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsolutePolicyUtils;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.KeyboardMovingLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.ISnapPointsListener;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoints;
import org.eclipse.wb.internal.swt.gef.ControlsLayoutRequestValidator;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormLayoutSnapPointsProvider;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormLayoutVisualDataProvider;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormSelectionEditPolicy2;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutPreferences;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormLayoutEditPolicy2
extends KeyboardMovingLayoutEditPolicy
implements IFeedbackProxy,
IHeadersProvider {
    private final FormLayoutInfo m_layout;
    private final FormLayoutVisualDataProvider m_visualDataProvider;
    private int m_frozenYValue;
    private Figure m_createFeedback;
    private TextFeedback m_locationFeedback;
    private TextFeedback m_sizeFeedback;
    private SnapPoints m_snapPoints;
    private Figure m_moveFeedback;
    private MoveListener m_moveListener;
    private FormHeaderLayoutEditPolicy m_headersPolicyHorizontal;
    private FormHeaderLayoutEditPolicy m_headersPolicyVertical;

    public FormLayoutEditPolicy2(FormLayoutInfo layout) {
        this.m_layout = layout;
        this.m_visualDataProvider = new FormLayoutVisualDataProvider<ControlInfo>(layout);
    }

    protected void decorateChild(EditPart child) {
        if (this.m_layout.getControls().contains(child.getModel())) {
            child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new FormSelectionEditPolicy2(this.m_layout));
        }
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ControlsLayoutRequestValidator.INSTANCE;
    }

    protected String getResizeRequestType() {
        return "_absolute_resize";
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            this.getMoveSnapPoints();
            this.showMoveFeedback((ChangeBoundsRequest)request);
        } else if (!(request instanceof CreateRequest)) {
            boolean cfr_ignored_0 = request instanceof PasteRequest;
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.m_snapPoints != null) {
            this.m_snapPoints.removeFeedbacks();
            this.m_snapPoints = null;
        }
        if (this.m_moveFeedback != null) {
            this.removeFeedback(this.m_moveFeedback);
            this.m_moveFeedback = null;
        }
        if (this.m_locationFeedback != null) {
            this.m_locationFeedback.remove();
            this.m_locationFeedback = null;
        }
        this.m_frozenYValue = 0;
    }

    private boolean isFreezeVerticalAxis(Request request) {
        return request.isControlKeyPressed() && this.m_frozenYValue != 0;
    }

    private SnapPoints createSnapPoints(ISnapPointsListener listener) {
        List<IAbstractComponentInfo> allComponents = this.getAllComponents();
        FormLayoutSnapPointsProvider<ControlInfo> snapPointsProvider = new FormLayoutSnapPointsProvider<ControlInfo>(this.m_layout, this.m_visualDataProvider, allComponents);
        return new SnapPoints((IVisualDataProvider)this.m_visualDataProvider, (IFeedbackProxy)this, snapPointsProvider, listener, allComponents);
    }

    private Layer getTextFeedbackLayer() {
        return this.getLayer("Feedback Layer Abv 1");
    }

    protected final Polyline createLineFeedback(int x1, int y1, int x2, int y2) {
        Point begin = new Point(x1, y1);
        Point end = new Point(x2, y2);
        this.translateModelToFeedback((Translatable)begin);
        this.translateModelToFeedback((Translatable)end);
        Polyline line = new Polyline();
        line.addPoint(begin);
        line.addPoint(end);
        line.setLineStyle(3);
        this.addFeedback((Figure)line);
        return line;
    }

    public Figure addHorizontalFeedbackLine(int y, int x, int width) {
        Polyline line = this.createLineFeedback(x, y, x + width, y);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        return line;
    }

    public Figure addHorizontalMiddleLineFeedback(int y, int x, int width) {
        Polyline line = this.createLineFeedback(x, y, x + width, y);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        line.setLineStyle(2);
        return line;
    }

    public Figure addOutlineFeedback(Rectangle bounds) {
        Rectangle feedbackBounds = bounds.getCopy();
        this.translateModelToFeedback((Translatable)feedbackBounds);
        Figure outline = new Figure();
        outline.setBorder((Border)new LineBorder(AbsolutePolicyUtils.COLOR_OUTLINE));
        outline.setBounds(feedbackBounds);
        this.addFeedback(outline);
        return outline;
    }

    public Figure addVerticalFeedbackLine(int x, int y, int height) {
        Polyline line = this.createLineFeedback(x, y, x, y + height);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        return line;
    }

    public Figure addVerticalMiddleLineFeedback(int x, int y, int height) {
        Polyline line = this.createLineFeedback(x, y, x, y + height);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        line.setLineStyle(2);
        return line;
    }

    private void getMoveSnapPoints() {
        if (this.m_snapPoints == null) {
            this.m_moveListener = new MoveListener();
            this.m_snapPoints = this.createSnapPoints(this.m_moveListener);
        }
    }

    private void showMoveFeedback(ChangeBoundsRequest request) {
        Rectangle widgetBounds;
        if (this.m_moveFeedback != null) {
            this.removeFeedback(this.m_moveFeedback);
            this.m_moveFeedback = null;
        }
        boolean isKeyboardMoving = this.isKeyboardMoving();
        List editParts = request.getEditParts();
        ArrayList modelList = Lists.newArrayList();
        Rectangle[] relativeBounds = new Rectangle[editParts.size()];
        if (editParts.size() > 1) {
            GraphicalEditPart firstEditPart = (GraphicalEditPart)editParts.get(0);
            widgetBounds = new Rectangle(firstEditPart.getFigure().getBounds());
            this.m_moveFeedback = new OutlineImageFigure(null);
            for (EditPart editPart : editParts) {
                IAbstractComponentInfo model = (IAbstractComponentInfo)editPart.getModel();
                Rectangle bounds = ((GraphicalEditPart)editPart).getFigure().getBounds();
                widgetBounds.union(bounds);
                modelList.add(model);
                this.m_moveFeedback.add((Figure)new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE), bounds);
            }
            List moveFeedbackFigures = this.m_moveFeedback.getChildren();
            int i = 0;
            while (i < moveFeedbackFigures.size()) {
                Figure figure = (Figure)moveFeedbackFigures.get(i);
                figure.getBounds().translate(-widgetBounds.x, -widgetBounds.y);
                relativeBounds[i] = figure.getBounds().getCopy();
                ++i;
            }
        } else {
            EditPart editPart = (EditPart)editParts.get(0);
            IAbstractComponentInfo model = (IAbstractComponentInfo)editPart.getModel();
            widgetBounds = ((GraphicalEditPart)editPart).getFigure().getBounds().getCopy();
            relativeBounds[0] = new Rectangle(new Point(), widgetBounds.getSize());
            modelList.add(model);
            this.m_moveFeedback = new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE);
        }
        FigureUtils.translateFigureToAbsolute2((Figure)((GraphicalEditPart)editParts.get(0)).getFigure().getParent(), (Translatable)widgetBounds);
        this.translateAbsoluteToModel((Translatable)widgetBounds);
        Point moveDelta = request.getMoveDelta();
        widgetBounds.x += moveDelta.x;
        widgetBounds.y = this.isFreezeVerticalAxis((Request)request) ? this.m_frozenYValue : (this.m_frozenYValue = widgetBounds.y + moveDelta.y);
        this.addFeedback(this.m_moveFeedback);
        Point moveLocation = this.isKeyboardMoving() ? moveDelta : request.getLocation();
        this.m_snapPoints.processBounds(moveLocation, (List)modelList, widgetBounds, 0);
        Rectangle feedbackBounds = widgetBounds.getCopy();
        this.translateModelToFeedback((Translatable)feedbackBounds);
        this.m_moveFeedback.setBounds(feedbackBounds);
        if (this.m_locationFeedback == null && this.isShowTextFeedback() && !isKeyboardMoving) {
            this.m_locationFeedback = new TextFeedback(this.getTextFeedbackLayer());
            this.m_locationFeedback.add();
        }
        if (this.m_locationFeedback != null) {
            EditPart firstEditPart = (EditPart)editParts.get(0);
            this.m_locationFeedback.setText(this.getLocationHintText(firstEditPart, widgetBounds.x, widgetBounds.y));
            Point locationFeedbackLocation = this.getLocationHintLocation(feedbackBounds);
            this.m_locationFeedback.setLocation(locationFeedbackLocation);
        }
    }

    private Point getLocationHintLocation(Rectangle widgetBounds) {
        return widgetBounds.getLocation().getTranslated(-30, -25);
    }

    private String getSizeHintString(EditPart editPart, int width, int height) {
        return MessageFormat.format("{0} x {1}", width, height);
    }

    private String getLocationHintText(EditPart editPart, int x, int y) {
        return MessageFormat.format("{0} x {1}", x, y);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return this.m_moveListener.getCommand();
    }

    private boolean isShowTextFeedback() {
        return true;
    }

    private List<IAbstractComponentInfo> getAllComponents() {
        ArrayList components = Lists.newArrayList();
        components.addAll(this.m_layout.getComposite().getChildrenControls());
        return components;
    }

    private void translateModelToFeedback(Translatable t) {
        PolicyUtils.translateModelToFeedback((LayoutEditPolicy)this, (Translatable)t);
        t.translate(this.m_visualDataProvider.getClientAreaOffset());
    }

    private void translateAbsoluteToModel(Translatable t) {
        PolicyUtils.translateAbsoluteToModel((LayoutEditPolicy)this, (Translatable)t);
        t.translate(this.m_visualDataProvider.getClientAreaOffset().getNegated());
    }

    public EditPart createHeaderEditPart(boolean isHorizontal, Object model) {
        return new FormHeaderEditPart<ControlInfo>(this.m_layout, model, isHorizontal, this.getHostFigure());
    }

    public void buildContextMenu(IMenuManager manager, boolean isHorizontal) {
        FormHeaderLayoutEditPolicy headersPolicy = isHorizontal ? this.m_headersPolicyHorizontal : this.m_headersPolicyVertical;
        headersPolicy.buildContextMenu(manager);
    }

    public LayoutEditPolicy getContainerLayoutPolicy(boolean isHorizontal) {
        FormHeaderLayoutEditPolicy<ControlInfo> headersPolicy = new FormHeaderLayoutEditPolicy<ControlInfo>(this.m_layout, (LayoutEditPolicy)this, isHorizontal);
        if (isHorizontal) {
            this.m_headersPolicyHorizontal = headersPolicy;
        } else {
            this.m_headersPolicyVertical = headersPolicy;
        }
        return headersPolicy;
    }

    public List<?> getHeaders(boolean isHorizontal) {
        FormLayoutPreferences<ControlInfo> preferences = this.m_layout.getPreferences();
        List<Integer> values = isHorizontal ? preferences.getHorizontalPercents() : preferences.getVerticalPercents();
        ArrayList results = Lists.newArrayList();
        for (Integer percent : values) {
            results.add(new FormLayoutPreferences.PercentsInfo(percent));
        }
        return results;
    }

    public void handleDoubleClick(boolean isHorizontal) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MoveListener
    implements ISnapPointsListener {
        private CompoundEditCommand m_command;

        private MoveListener() {
        }

        public Command getCommand() {
            return this.m_command;
        }

        public void boundsChanged(Rectangle bounds, List<? extends IAbstractComponentInfo> components, SnapPoint[] snapPoints, int[] directions) {
            this.m_command = new CompoundEditCommand((ObjectInfo)FormLayoutEditPolicy2.this.m_layout);
            int i = 0;
            while (i < snapPoints.length) {
                SnapPoint snapPoint = snapPoints[i];
                if (snapPoint != null) {
                    this.m_command.add(snapPoint.getCommand());
                } else {
                    int moveDirection = directions[i];
                    boolean isHorizontal = i == 0;
                    FormLayoutSnapPointsProvider.MoveFreelyCommand<ControlInfo> command = new FormLayoutSnapPointsProvider.MoveFreelyCommand<ControlInfo>(FormLayoutEditPolicy2.this.m_layout, bounds, components, moveDirection, isHorizontal, FormLayoutEditPolicy2.this.m_visualDataProvider);
                    this.m_command.add(command);
                }
                ++i;
            }
        }
    }
}

