/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtend.ide.refactoring.ExtractMethodRefactoring;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.Strings;

public class ExtractMethodUserInputPage
extends UserInputWizardPage {
    @Inject
    private EmbeddedEditorFactory editorFactory;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private ProjectUtil projectUtil;
    private ExtractMethodRefactoring refactoring;
    private Text textField;
    private EmbeddedEditor signaturePreview;
    private EmbeddedEditorModelAccess partialEditor;
    private boolean isInitialName = true;

    protected ExtractMethodUserInputPage() {
        super("ExtractMethodInputPage");
    }

    public void setRefactoring(ExtractMethodRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)result);
        this.createNameField(result);
        this.createAccessModifierSection(result);
        this.createParameterControl(result);
        this.createAdditionalCheckboxes(result);
        this.createSeparator(result);
        this.createSignaturePreview(result);
        Dialog.applyDialogFont((Control)result);
    }

    protected void createNameField(Composite result) {
        Label label = new Label(result, 0);
        label.setText("Method name:");
        this.textField = new Text(result, 2048);
        this.textField.setText(this.refactoring.getMethodName());
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractMethodUserInputPage.this.textModified(ExtractMethodUserInputPage.this.getText());
            }
        });
        this.textField.setLayoutData((Object)new GridData(768));
    }

    protected void createAccessModifierSection(Composite result) {
        Label label = new Label(result, 0);
        label.setText("Access modifier:");
        Composite group = new Composite(result, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{"public", "protected", "private"};
        JvmVisibility[] data = new JvmVisibility[]{JvmVisibility.PUBLIC, JvmVisibility.PROTECTED, JvmVisibility.PRIVATE};
        JvmVisibility visibility = this.refactoring.getVisibility();
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button(group, 16);
            radio.setText(labels[i]);
            radio.setData((Object)data[i]);
            if (data[i].equals((Object)visibility)) {
                radio.setSelection(true);
            }
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JvmVisibility selectedModifier = (JvmVisibility)event.widget.getData();
                    ExtractMethodUserInputPage.this.visibilityModified(selectedModifier);
                    ExtractMethodUserInputPage.this.updatePreview();
                }
            });
            ++i;
        }
    }

    protected void createParameterControl(Composite result) {
        if (!this.refactoring.getParameterInfos().isEmpty()) {
            ChangeParametersControl cp = new ChangeParametersControl(result, 0, "Parameters", new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameter) {
                    ExtractMethodUserInputPage.this.parameterModified();
                }

                public void parameterListChanged() {
                    ExtractMethodUserInputPage.this.parameterModified();
                }

                public void parameterAdded(ParameterInfo parameter) {
                    ExtractMethodUserInputPage.this.updatePreview();
                }
            }, ChangeParametersControl.Mode.EXTRACT_METHOD);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            cp.setLayoutData((Object)gridData);
            cp.setInput(this.refactoring.getParameterInfos());
        }
    }

    protected void createAdditionalCheckboxes(Composite result) {
        Button declareReturnTypeButton = new Button(result, 32);
        declareReturnTypeButton.setText("Explicitly declare return type");
        declareReturnTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractMethodUserInputPage.this.refactoring.setExplicitlyDeclareReturnType(((Button)e.widget).getSelection());
                ExtractMethodUserInputPage.this.updatePreview();
            }
        });
        declareReturnTypeButton.setSelection(this.refactoring.isExplicitlyDeclareReturnType());
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        declareReturnTypeButton.setLayoutData((Object)layoutData);
    }

    protected void createSeparator(Composite result) {
        Label label = new Label(result, 258);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
    }

    protected void createSignaturePreview(Composite composite) {
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText("Method signature preview:");
        GridData gridData = new GridData(4);
        gridData.horizontalSpan = 2;
        previewLabel.setLayoutData((Object)gridData);
        this.signaturePreview = this.editorFactory.newEditor(new IEditedResourceProvider(){

            public XtextResource createResource() {
                URI resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)ExtractMethodUserInputPage.this.refactoring.getXtendClass()).trimFragment();
                IProject project = ExtractMethodUserInputPage.this.projectUtil.getProject(resourceURI);
                ResourceSet resourceSet = ExtractMethodUserInputPage.this.resourceSetProvider.get(project);
                return (XtextResource)resourceSet.getResource(resourceURI, true);
            }
        }).readOnly().withParent(composite);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.signaturePreview.getViewer().getControl().setLayoutData((Object)gridData2);
        this.partialEditor = this.signaturePreview.createPartialEditor(this.getPartialEditorModelPrefix(), this.refactoring.getMethodSignature(), this.getPartialEditorModelSuffix(), true);
    }

    protected String getPartialEditorModelPrefix() {
        return "class " + this.refactoring.getXtendClass().getName() + " {";
    }

    protected String getPartialEditorModelSuffix() {
        return "() {} }";
    }

    protected String getText() {
        if (this.textField == null) {
            return null;
        }
        return this.textField.getText();
    }

    protected void textModified(String text) {
        this.isInitialName = false;
        this.refactoring.setMethodName(text);
        RefactoringStatus status = this.validatePage(true);
        if (!status.hasFatalError()) {
            this.updatePreview();
        }
        this.setPageComplete(status);
    }

    protected void visibilityModified(JvmVisibility visibility) {
        this.refactoring.setVisibility(visibility);
        this.updatePreview();
    }

    protected void parameterModified() {
        this.updatePreview();
        RefactoringStatus status = this.validatePage(false);
        this.setPageComplete(status);
    }

    protected void updatePreview() {
        if (this.signaturePreview == null) {
            return;
        }
        String signature = this.refactoring.getMethodSignature();
        this.partialEditor.updateModel(this.getPartialEditorModelPrefix(), signature, this.getPartialEditorModelSuffix());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.isInitialName) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(this.validatePage(true));
            }
            this.updatePreview();
            this.textField.setFocus();
        }
        super.setVisible(visible);
    }

    protected RefactoringStatus validatePage(boolean text) {
        RefactoringStatus result = new RefactoringStatus();
        if (text) {
            result.merge(this.validateMethodName());
            result.merge(this.validateParameters());
        } else {
            result.merge(this.validateParameters());
            result.merge(this.validateMethodName());
        }
        return result;
    }

    protected RefactoringStatus validateMethodName() {
        RefactoringStatus result = new RefactoringStatus();
        String text = this.getText();
        if (Strings.isEmpty((String)text)) {
            if (!this.isInitialName) {
                result.addFatalError("Provide a method name");
            }
            return result;
        }
        result.merge(this.refactoring.validateMethodName(text));
        return result;
    }

    protected RefactoringStatus validateParameters() {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.refactoring.validateParameters());
        return result;
    }
}

