/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CFOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.actions.BaseCommandHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IModule;

public class UpdateRestartModuleCommand
extends BaseCommandHandler {
    private String getFailureMessage() {
        return "Unable to update and restart module";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CloudFoundryApplicationModule appModule;
        this.initializeSelection(event);
        String error = null;
        CloudFoundryServer cloudServer = this.selectedServer != null ? (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null) : null;
        CloudFoundryApplicationModule cloudFoundryApplicationModule = appModule = cloudServer != null && this.selectedModule != null ? cloudServer.getExistingCloudModule(this.selectedModule) : null;
        if (this.selectedServer == null) {
            error = "No Cloud Foundry server instance available to run the selected action.";
        }
        if (error == null) {
            this.doRun(cloudServer, appModule);
        } else {
            CloudFoundryPlugin.logError((String)error);
        }
        return null;
    }

    protected void doRun(CloudFoundryServer server, CloudFoundryApplicationModule appModule) {
        final CloudFoundryServer cloudServer = server;
        Job job = new Job(Messages.PushApplicationOperation_UPDATE_APP_MESSAGE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ICloudFoundryOperation operation = cloudServer.getBehaviour().operations().applicationDeployment(new IModule[]{UpdateRestartModuleCommand.this.selectedModule}, ApplicationAction.UPDATE_RESTART);
                    if (operation instanceof CFOperation) {
                        this.setName(((CFOperation)operation).getOperationName());
                    }
                    operation.run(monitor);
                }
                catch (CoreException e) {
                    CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.core", UpdateRestartModuleCommand.this.getFailureMessage(), (Throwable)e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

