/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.admin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.internal.admin.CDOAdminClientImpl;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.om.monitor.NotifyingMonitor;

public class CDOAdminClientRepositoryImpl
extends Notifier
implements CDOAdminClientRepository {
    private CDOAdminClientImpl admin;
    private String name;
    private String uuid;
    private CDOCommonRepository.Type type;
    private CDOCommonRepository.State state;
    private String storeType;
    private Set<CDOID.ObjectType> objectIDTypes;
    private long creationTime;
    private CDOID rootResourceID;
    private boolean authenticating;
    private boolean supportingAudits;
    private boolean supportingBranches;
    private boolean supportingUnits;
    private boolean serializingCommits;
    private boolean ensuringReferentialIntegrity;
    private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
    private CDOCommonRepository.CommitInfoStorage commitInfoStorage;

    public CDOAdminClientRepositoryImpl(CDOAdminClientImpl admin, ExtendedDataInputStream in) throws IOException {
        this.admin = admin;
        this.name = in.readString();
        this.uuid = in.readString();
        this.type = (CDOCommonRepository.Type)in.readEnum(CDOCommonRepository.Type.class);
        this.state = (CDOCommonRepository.State)in.readEnum(CDOCommonRepository.State.class);
        this.storeType = in.readString();
        HashSet<CDOID.ObjectType> objectIDTypes = new HashSet<CDOID.ObjectType>();
        int types = in.readInt();
        int i = 0;
        while (i < types) {
            CDOID.ObjectType objectIDType = (CDOID.ObjectType)in.readEnum(CDOID.ObjectType.class);
            objectIDTypes.add(objectIDType);
            ++i;
        }
        this.creationTime = in.readLong();
        CDODataInputImpl.Default wrapper = new CDODataInputImpl.Default((ExtendedDataInput)in);
        this.rootResourceID = wrapper.readCDOID();
        if (ObjectUtil.never()) {
            wrapper.close();
        }
        this.authenticating = in.readBoolean();
        this.supportingAudits = in.readBoolean();
        this.supportingBranches = in.readBoolean();
        this.supportingUnits = in.readBoolean();
        this.serializingCommits = in.readBoolean();
        this.ensuringReferentialIntegrity = in.readBoolean();
        this.idGenerationLocation = (CDOCommonRepository.IDGenerationLocation)in.readEnum(CDOCommonRepository.IDGenerationLocation.class);
        this.commitInfoStorage = (CDOCommonRepository.CommitInfoStorage)in.readEnum(CDOCommonRepository.CommitInfoStorage.class);
    }

    @Override
    public CDOAdminClient getAdmin() {
        return this.admin;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public CDOCommonRepository.Type getType() {
        return this.type;
    }

    public CDOCommonRepository.State getState() {
        return this.state;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.objectIDTypes;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public CDOID getRootResourceID() {
        return this.rootResourceID;
    }

    public boolean isAuthenticating() {
        return this.authenticating;
    }

    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    public boolean isSupportingBranches() {
        return this.supportingBranches;
    }

    public boolean isSupportingUnits() {
        return this.supportingUnits;
    }

    @Deprecated
    public boolean isSupportingEcore() {
        return true;
    }

    public boolean isSerializingCommits() {
        return this.serializingCommits;
    }

    public boolean isEnsuringReferentialIntegrity() {
        return this.ensuringReferentialIntegrity;
    }

    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.idGenerationLocation;
    }

    public CDOCommonRepository.CommitInfoStorage getCommitInfoStorage() {
        return this.commitInfoStorage;
    }

    public boolean waitWhileInitial(IProgressMonitor monitor) {
        return CDOCommonUtil.waitWhileInitial((CDOCommonRepository)this, (INotifier)this, (IProgressMonitor)monitor);
    }

    public long getTimeStamp() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(String type) {
        return this.admin.deleteRepository(this, type);
    }

    @Override
    public CDONet4jSession openSession() {
        return this.openSession(null);
    }

    @Override
    public CDONet4jSession openSession(CDOAdminClientRepository.SessionConfigurator configurator) {
        IConnector connector = this.admin.getConnector();
        if (connector == null) {
            return null;
        }
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName(this.name);
        if (configurator != null) {
            configurator.prepare(configuration);
        }
        return configuration.openNet4jSession();
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public String toString() {
        return this.name;
    }

    public void typeChanged(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.type = newType;
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
    }

    public void stateChanged(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.state = newState;
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
    }

    public void replicationProgressed(double totalWork, double work) {
        this.fireEvent((IEvent)new NotifyingMonitor.ProgressEvent((INotifier)this, totalWork, work));
    }
}

