/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.ui;

import org.eclipse.emf.cdo.transfer.CDOTransfer;
import org.eclipse.emf.cdo.transfer.CDOTransferMapping;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.emf.cdo.transfer.spi.ui.TransferUIProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class TransferLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    public static final Color GRAY = UIUtil.getDisplay().getSystemColor(15);
    public static final Color RED = UIUtil.getDisplay().getSystemColor(3);
    private CDOTransfer transfer;
    private ILabelProvider sourceSystemLabelProvider;

    public TransferLabelProvider(CDOTransfer transfer) {
        this.transfer = transfer;
        CDOTransferSystem sourceSystem = transfer.getSourceSystem();
        TransferUIProvider provider = TransferUIProvider.Factory.get(this.getContainer(), sourceSystem.getType());
        this.sourceSystemLabelProvider = provider.createLabelProvider(sourceSystem);
    }

    public CDOTransfer getTransfer() {
        return this.transfer;
    }

    public void dispose() {
        this.sourceSystemLabelProvider.dispose();
        this.sourceSystemLabelProvider = null;
        super.dispose();
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof CDOTransferMapping) {
            CDOTransferMapping mapping = (CDOTransferMapping)element;
            switch (columnIndex) {
                case 0: {
                    return this.sourceSystemLabelProvider.getText((Object)mapping.getSource());
                }
                case 1: {
                    return mapping.getTransferType().toString();
                }
                case 2: {
                    return mapping.getFullPath().toString();
                }
                case 3: {
                    return mapping.getStatus().toString();
                }
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof CDOTransferMapping) {
            CDOTransferMapping mapping = (CDOTransferMapping)element;
            switch (columnIndex) {
                case 0: {
                    return this.sourceSystemLabelProvider.getImage((Object)mapping.getSource());
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return null;
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof CDOTransferMapping) {
            CDOTransferMapping mapping = (CDOTransferMapping)element;
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    CDOTransferType transferType = mapping.getTransferType();
                    if (transferType == CDOTransferType.FOLDER) {
                        return GRAY;
                    }
                    return null;
                }
                case 2: 
                case 3: {
                    CDOTransferMapping.Status status = mapping.getStatus();
                    if (status == CDOTransferMapping.Status.MERGE) {
                        return GRAY;
                    }
                    if (status == CDOTransferMapping.Status.CONFLICT) {
                        return RED;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

