/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.epp.internal.logging.aeri.ide.*;

import org.eclipse.epp.logging.aeri.core.ILinkable;
import org.eclipse.epp.logging.aeri.core.IUserSettings;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage
 * @generated
 */
public class IdeAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static IIdePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IdeAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = IIdePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdeSwitch<Adapter> modelSwitch =
		new IdeSwitch<Adapter>() {
			@Override
			public Adapter caseLogEventsQueue(ILogEventsQueue object) {
				return createLogEventsQueueAdapter();
			}
			@Override
			public Adapter caseLogEventGroup(ILogEventGroup object) {
				return createLogEventGroupAdapter();
			}
			@Override
			public Adapter caseLogEvent(ILogEvent object) {
				return createLogEventAdapter();
			}
			@Override
			public Adapter caseInternalInput(IInternalInput object) {
				return createInternalInputAdapter();
			}
			@Override
			public Adapter caseServerDescriptor(IServerDescriptor object) {
				return createServerDescriptorAdapter();
			}
			@Override
			public Adapter caseProcessorDescriptor(IProcessorDescriptor object) {
				return createProcessorDescriptorAdapter();
			}
			@Override
			public Adapter caseLinkable(ILinkable object) {
				return createLinkableAdapter();
			}
			@Override
			public Adapter caseUserSettings(IUserSettings object) {
				return createUserSettingsAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue <em>Log Events Queue</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue
	 * @generated
	 */
	public Adapter createLogEventsQueueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup <em>Log Event Group</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup
	 * @generated
	 */
	public Adapter createLogEventGroupAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent <em>Log Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent
	 * @generated
	 */
	public Adapter createLogEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.internal.logging.aeri.ide.IInternalInput <em>Internal Input</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IInternalInput
	 * @generated
	 */
	public Adapter createInternalInputAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor <em>Server Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor
	 * @generated
	 */
	public Adapter createServerDescriptorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor <em>Processor Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor
	 * @generated
	 */
	public Adapter createProcessorDescriptorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.logging.aeri.core.ILinkable <em>Linkable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.logging.aeri.core.ILinkable
	 * @generated
	 */
	public Adapter createLinkableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.epp.logging.aeri.core.IUserSettings <em>User Settings</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.epp.logging.aeri.core.IUserSettings
	 * @generated
	 */
	public Adapter createUserSettingsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //IdeAdapterFactory
