/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.compare;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.actions.QueryDropDownMenuAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.panes.TableResultPane;
import org.eclipse.mat.ui.snapshot.panes.HistogramPane;
import org.eclipse.mat.ui.snapshot.panes.OQLPane;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.IPolicy;
import org.eclipse.mat.ui.util.NavigatorState;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class CompareBasketView
extends ViewPart {
    public static final String ID = "org.eclipse.mat.ui.views.CompareBasketView";
    private Table table;
    private TableViewer tableViewer;
    private Action compareAction;
    private Action clearAction;
    private MoveAction moveUpAction;
    private MoveAction moveDownAction;
    private Action removeAction;
    private Set<MultiPaneEditor> editors = new HashSet<MultiPaneEditor>();
    List<ComparedResult> results = new ArrayList<ComparedResult>();
    NavigatorState.IStateChangeListener stateListener = new StateChangeListener();
    IPartListener2 partListener = new PartListener();

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        this.addToolbar();
        this.hookContextMenu();
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 66306);
        this.table = this.tableViewer.getTable();
        AccessibleCompositeAdapter.access(this.table);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 16384);
        TableColumn tableColumn = column.getColumn();
        tableColumn.setText(Messages.CompareBasketView_ResultsToBeComparedColumnHeader);
        tableColumn.setWidth(200);
        TableViewerColumn heapDumpColumn = new TableViewerColumn(this.tableViewer, 16384);
        tableColumn = heapDumpColumn.getColumn();
        tableColumn.setText(Messages.CompareBasketView_HeapDumpColumnHeader);
        tableColumn.setWidth(400);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new CompareContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CompareLabelProvider());
        this.tableViewer.setInput(this.results);
    }

    private void addToolbar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        this.moveDownAction = new MoveAction(1024);
        manager.add((IAction)this.moveDownAction);
        this.moveUpAction = new MoveAction(128);
        manager.add((IAction)this.moveUpAction);
        manager.add((IContributionItem)new Separator());
        this.removeAction = new RemoveAction();
        manager.add((IAction)this.removeAction);
        this.clearAction = new RemoveAllAction();
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator());
        this.compareAction = new CompareAction();
        manager.add((IAction)this.compareAction);
    }

    public void setFocus() {
    }

    public void addResultToCompare(PaneState state, MultiPaneEditor editor) {
        AbstractEditorPane pane = CompareBasketView.resultPane(state, editor);
        ComparedResult entry = null;
        if (pane != null) {
            QueryResult qr = pane.getAdapter(QueryResult.class);
            if (qr != null && qr.getSubject() instanceof IResultTree) {
                entry = new ComparedResult(state, editor, (IStructuredResult)((IResultTree)qr.getSubject()));
            }
            if (qr != null && qr.getSubject() instanceof IResultTable) {
                entry = new ComparedResult(state, editor, (IStructuredResult)((IResultTable)qr.getSubject()));
            }
        }
        if (pane instanceof HistogramPane) {
            entry = new ComparedResult(state, editor, (IStructuredResult)((HistogramPane)pane).getHistogram());
        } else if (pane instanceof TableResultPane) {
            entry = new ComparedResult(state, editor, (IStructuredResult)((IResultTable)((TableResultPane)pane).getSrcQueryResult().getSubject()));
        } else if (pane instanceof QueryResultPane) {
            entry = new ComparedResult(state, editor, (IStructuredResult)((IResultTree)((QueryResultPane)pane).getSrcQueryResult().getSubject()));
        }
        if (entry != null) {
            this.results.add(entry);
        }
        this.tableViewer.refresh();
        this.clearAction.setEnabled(true);
        if (this.results.size() > 1) {
            this.compareAction.setEnabled(true);
        }
        if (this.editors.add(editor)) {
            editor.getSite().getPage().addPartListener(this.partListener);
            editor.getNavigatorState().addChangeStateListener(this.stateListener);
        }
    }

    public static boolean accepts(PaneState state, MultiPaneEditor editor) {
        AbstractEditorPane pane = CompareBasketView.resultPane(state, editor);
        if (pane != null) {
            QueryResult qr = pane.getAdapter(QueryResult.class);
            if (qr != null && qr.getSubject() instanceof IResultTree) {
                return true;
            }
            if (qr != null && qr.getSubject() instanceof IResultTable) {
                return true;
            }
        }
        return pane instanceof HistogramPane || pane instanceof TableResultPane || pane instanceof QueryResultPane && ((QueryResultPane)pane).getSrcQueryResult().getSubject() instanceof IResultTree;
    }

    private static AbstractEditorPane resultPane(PaneState state, MultiPaneEditor editor) {
        AbstractEditorPane pane;
        if (state.isActive() && state.getType() == PaneState.PaneType.COMPOSITE_CHILD) {
            PaneState pstate = state.getParentPaneState();
            pane = editor.getEditor(pstate);
            if (pane instanceof OQLPane) {
                pane = ((OQLPane)pane).getEmbeddedPane();
            } else if (pane instanceof CompositeHeapEditorPane) {
                pane = (CompositeHeapEditorPane)pane;
            }
        } else {
            pane = editor.getEditor(state);
        }
        return pane;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CompareBasketView.this.editorContextMenuAboutToShow(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                TableItem[] items = CompareBasketView.this.table.getSelection();
                ArrayList<IStructuredResult> tables = new ArrayList<IStructuredResult>(items.length);
                ArrayList<IQueryContext> contexts = new ArrayList<IQueryContext>(items.length);
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ComparedResult result = (ComparedResult)item.getData();
                    tables.add(result.table);
                    contexts.add(result.editor.getQueryContext());
                    ++n2;
                }
                MultiPaneEditor editor = CompareBasketView.this.getEditor();
                if (editor == null) {
                    return;
                }
                QueryDropDownMenuAction qa = new QueryDropDownMenuAction(editor, new ComparePolicy(tables, contexts, editor.getQueryContext()), false);
                PopupMenu menu1 = new PopupMenu();
                qa.contribute(menu1);
                IStatusLineManager statusLineManager = CompareBasketView.this.getViewSite().getActionBars().getStatusLineManager();
                menu1.addToMenu(statusLineManager, CompareBasketView.this.table.getMenu());
            }
        });
    }

    private void editorContextMenuAboutToShow(IMenuManager manager) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return;
        }
        manager.add((IAction)this.moveDownAction);
        manager.add((IAction)this.moveUpAction);
        manager.add((IAction)this.removeAction);
    }

    public void dispose() {
        for (MultiPaneEditor editor : this.editors) {
            if (editor.isDisposed()) continue;
            editor.getSite().getPage().removePartListener(this.partListener);
            editor.getNavigatorState().removeChangeStateListener(this.stateListener);
        }
    }

    private void updateButtons() {
        this.compareAction.setEnabled(this.results.size() > 1);
        this.clearAction.setEnabled(this.results.size() > 0);
    }

    private MultiPaneEditor getEditor() {
        if (this.results.size() > 0) {
            return (MultiPaneEditor)this.results.get((int)(this.results.size() - 1)).editor.getSite().getPage().getActiveEditor();
        }
        return null;
    }

    class CompareAction
    extends Action {
        public CompareAction() {
            this.setText(Messages.CompareBasketView_CompareButtonLabel);
            this.setToolTipText(Messages.CompareBasketView_CompareTooltip);
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/execute_query.gif"));
            this.setEnabled(false);
        }

        public void run() {
            try {
                MultiPaneEditor editor = CompareBasketView.this.getEditor();
                ArrayList<IStructuredResult> tables = new ArrayList<IStructuredResult>(CompareBasketView.this.results.size());
                ArrayList<ISnapshot> snapshots = new ArrayList<ISnapshot>(CompareBasketView.this.results.size());
                int i = 0;
                while (i < CompareBasketView.this.results.size()) {
                    tables.add(CompareBasketView.this.results.get((int)i).table);
                    snapshots.add((ISnapshot)CompareBasketView.this.results.get((int)i).editor.getQueryContext().get(ISnapshot.class, null));
                    ++i;
                }
                String query = "comparetablesquery";
                SnapshotQuery compareQuery = SnapshotQuery.lookup((String)query, (ISnapshot)((ISnapshot)editor.getQueryContext().get(ISnapshot.class, null)));
                compareQuery.setArgument("tables", tables);
                compareQuery.setArgument("snapshots", snapshots);
                IResult absolute = compareQuery.execute((IProgressListener)new VoidProgressListener());
                QueryResult queryResult = new QueryResult(null, Messages.CompareBasketView_ComparedTablesResultTitle, absolute);
                QueryExecution.displayResult(editor, null, null, queryResult, false);
            }
            catch (Exception e) {
                ErrorHelper.logThrowable(e);
            }
        }
    }

    static class CompareContentProvider
    implements IStructuredContentProvider {
        CompareContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List results = (List)inputElement;
            return results.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class CompareLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CompareLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ComparedResult res = (ComparedResult)element;
            return columnIndex == 0 ? res.state.getImage() : null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ComparedResult res = (ComparedResult)element;
            switch (columnIndex) {
                case 0: {
                    return res.state.getIdentifier();
                }
                case 1: {
                    return res.editor.getResourceFile().getAbsolutePath();
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComparePolicy
    implements IPolicy {
        private final List<IStructuredResult> tables;
        private final List<IQueryContext> contexts;
        private final IQueryContext currentContext;
        private final List<ISnapshot> snapshots;
        private final ISnapshot currentSnapshot;

        private ComparePolicy(List<IStructuredResult> tables, List<IQueryContext> contexts, IQueryContext currentContext) {
            this.tables = tables;
            this.contexts = contexts;
            this.currentContext = currentContext;
            this.snapshots = new ArrayList<ISnapshot>();
            for (IQueryContext ctx : contexts) {
                this.snapshots.add((ISnapshot)ctx.get(ISnapshot.class, null));
            }
            this.currentSnapshot = (ISnapshot)currentContext.get(ISnapshot.class, null);
        }

        @Override
        public boolean accept(QueryDescriptor query) {
            boolean foundTables = false;
            boolean foundContexts = false;
            boolean foundSnapshots = false;
            for (ArgumentDescriptor argument : query.getArguments()) {
                if (!IStructuredResult.class.isAssignableFrom(argument.getType()) || !argument.isMultiple()) continue;
                for (IStructuredResult res : this.tables) {
                    if (!argument.getType().isAssignableFrom(res.getClass())) {
                        return false;
                    }
                    foundTables = true;
                }
            }
            for (ArgumentDescriptor argument : query.getArguments()) {
                if (IQueryContext.class.isAssignableFrom(argument.getType()) && argument.isMultiple()) {
                    foundContexts = true;
                }
                if (!ISnapshot.class.isAssignableFrom(argument.getType()) || !argument.isMultiple()) continue;
                foundSnapshots = true;
            }
            if (!foundContexts && !foundSnapshots) {
                foundContexts = true;
                for (IQueryContext ctx : this.contexts) {
                    if (ctx.equals(this.currentContext)) continue;
                    foundContexts = false;
                    break;
                }
            }
            if (!foundContexts && !foundSnapshots) {
                foundSnapshots = true;
                for (ISnapshot snap : this.snapshots) {
                    if (snap.equals(this.currentSnapshot)) continue;
                    foundSnapshots = false;
                    break;
                }
            }
            return foundTables && (foundContexts || foundSnapshots);
        }

        @Override
        public void fillInObjectArguments(ISnapshot snapshot, QueryDescriptor query, ArgumentSet set) {
            for (ArgumentDescriptor argument : query.getArguments()) {
                if (IStructuredResult.class.isAssignableFrom(argument.getType())) {
                    if (argument.isMultiple()) {
                        set.setArgumentValue(argument, this.tables);
                        continue;
                    }
                    set.setArgumentValue(argument, (Object)this.tables.get(0));
                    continue;
                }
                if (IQueryContext.class.isAssignableFrom(argument.getType())) {
                    if (!argument.isMultiple()) continue;
                    set.setArgumentValue(argument, this.contexts);
                    continue;
                }
                if (!ISnapshot.class.isAssignableFrom(argument.getType()) || !argument.isMultiple()) continue;
                set.setArgumentValue(argument, this.snapshots);
            }
        }
    }

    static class ComparedResult {
        PaneState state;
        MultiPaneEditor editor;
        IStructuredResult table;

        public ComparedResult(PaneState state, MultiPaneEditor editor, IStructuredResult table) {
            this.state = state;
            this.editor = editor;
            this.table = table;
        }
    }

    class MoveAction
    extends Action
    implements ISelectionChangedListener {
        private int direction;

        public MoveAction(int direction) {
            this.direction = direction;
            if (direction == 128) {
                this.setText(Messages.CompareBasketView_MoveUpButtonLabel);
                this.setToolTipText(Messages.CompareBasketView_MoveUpTooltip);
                this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/move_up.gif"));
            } else if (direction == 1024) {
                this.setText(Messages.CompareBasketView_MoveDownButtonLabel);
                this.setToolTipText(Messages.CompareBasketView_MoveDownTooltip);
                this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/move_down.gif"));
            }
            this.setEnabled(false);
            CompareBasketView.this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void run() {
            int idx = CompareBasketView.this.tableViewer.getTable().getSelectionIndex();
            ComparedResult selectedResult = (ComparedResult)((IStructuredSelection)CompareBasketView.this.tableViewer.getSelection()).getFirstElement();
            if (this.direction == 128) {
                CompareBasketView.this.results.set(idx, CompareBasketView.this.results.get(idx - 1));
                CompareBasketView.this.results.set(idx - 1, selectedResult);
            } else if (this.direction == 1024) {
                CompareBasketView.this.results.set(idx, CompareBasketView.this.results.get(idx + 1));
                CompareBasketView.this.results.set(idx + 1, selectedResult);
            }
            CompareBasketView.this.tableViewer.setInput(CompareBasketView.this.results);
            CompareBasketView.this.tableViewer.getTable().setSelection(this.direction == 128 ? idx - 1 : idx + 1);
            CompareBasketView.this.moveUpAction.updateState();
            CompareBasketView.this.moveDownAction.updateState();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                this.updateState();
            } else {
                this.setEnabled(false);
            }
        }

        void updateState() {
            IStructuredSelection selection = (IStructuredSelection)CompareBasketView.this.tableViewer.getSelection();
            if (selection.size() != 1) {
                this.setEnabled(false);
                return;
            }
            int idx = CompareBasketView.this.tableViewer.getTable().getSelectionIndex();
            if (idx == 0 && this.direction == 128) {
                this.setEnabled(false);
            } else if (idx == CompareBasketView.this.results.size() - 1 && this.direction == 1024) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            ArrayList<ComparedResult> toBeRemoved = new ArrayList<ComparedResult>();
            for (ComparedResult res : CompareBasketView.this.results) {
                if (res.editor != part) continue;
                toBeRemoved.add(res);
            }
            CompareBasketView.this.editors.remove(part);
            CompareBasketView.this.results.removeAll(toBeRemoved);
            if (!CompareBasketView.this.table.isDisposed()) {
                CompareBasketView.this.tableViewer.refresh();
            }
            CompareBasketView.this.updateButtons();
        }
    }

    class RemoveAction
    extends Action
    implements ISelectionChangedListener {
        public RemoveAction() {
            this.setText(Messages.CompareBasketView_RemoveButtonLabel);
            this.setToolTipText(Messages.CompareBasketView_RemoveTooltip);
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/remove.gif"));
            this.setEnabled(false);
            CompareBasketView.this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void run() {
            int[] selectionIndeces = CompareBasketView.this.tableViewer.getTable().getSelectionIndices();
            int alreadyRemoved = 0;
            int[] nArray = selectionIndeces;
            int n = selectionIndeces.length;
            int n2 = 0;
            while (n2 < n) {
                int idx = nArray[n2];
                CompareBasketView.this.results.remove(idx - alreadyRemoved);
                ++alreadyRemoved;
                ++n2;
            }
            CompareBasketView.this.tableViewer.refresh();
            this.setEnabled(false);
            if (CompareBasketView.this.results.size() < 2) {
                CompareBasketView.this.compareAction.setEnabled(false);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setEnabled(!CompareBasketView.this.tableViewer.getSelection().isEmpty());
        }
    }

    class RemoveAllAction
    extends Action {
        public RemoveAllAction() {
            this.setText(Messages.CompareBasketView_ClearButtonLabel);
            this.setToolTipText(Messages.CompareBasketView_ClearTooltip);
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/removeall.gif"));
            this.setEnabled(false);
        }

        public void run() {
            CompareBasketView.this.results.clear();
            CompareBasketView.this.tableViewer.refresh();
            this.setEnabled(false);
            CompareBasketView.this.compareAction.setEnabled(false);
        }
    }

    private class StateChangeListener
    implements NavigatorState.IStateChangeListener {
        private StateChangeListener() {
        }

        public void onStateChanged(PaneState state) {
            if (state != null && !state.isActive()) {
                ArrayList<ComparedResult> toBeRemoved = new ArrayList<ComparedResult>();
                for (ComparedResult res : CompareBasketView.this.results) {
                    if (res.state != state) continue;
                    toBeRemoved.add(res);
                }
                CompareBasketView.this.results.removeAll(toBeRemoved);
                CompareBasketView.this.tableViewer.refresh();
                CompareBasketView.this.updateButtons();
            }
        }
    }
}

