/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.core.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.facet.util.emf.core.command.ILockableUndoCommand;
import org.eclipse.modisco.facet.util.emf.core.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetResourceContentCommand
implements Command,
ILockableUndoCommand {
    private EList<EObject> oldContent = null;
    private Collection<EObject> newContent = null;
    private Resource resource;
    private boolean enableUndo = true;

    public SetResourceContentCommand(Resource resource, Collection<EObject> content) {
        this.resource = resource;
        this.newContent = content;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.oldContent = this.resource.getContents();
        this.resource.getContents().clear();
        this.resource.getContents().addAll(this.newContent);
    }

    public boolean canUndo() {
        boolean canUndo = this.enableUndo && this.oldContent != null;
        return canUndo;
    }

    public void undo() {
        this.resource.getContents().clear();
        this.resource.getContents().addAll(this.oldContent);
    }

    public void redo() {
        this.resource.getContents().clear();
        this.resource.getContents().addAll(this.newContent);
    }

    public Collection<?> getResult() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        result.add(this.resource);
        return result;
    }

    public Collection<?> getAffectedObjects() {
        ArrayList<Object> affectedObjects = new ArrayList<Object>();
        affectedObjects.add(this.resource);
        affectedObjects.addAll(this.newContent);
        affectedObjects.addAll((Collection<Object>)this.oldContent);
        return affectedObjects;
    }

    public String getLabel() {
        return Messages.SetResourceContentCommand_Label;
    }

    public String getDescription() {
        return Messages.SetResourceContentCommand_Description;
    }

    public void dispose() {
        this.oldContent = null;
        this.newContent = null;
        this.resource = null;
    }

    public Command chain(Command command) {
        return null;
    }

    @Override
    public void enableCanUndo(boolean enable) {
        this.enableUndo = enable;
    }
}

