/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.modisco.facet.util.ui.internal.Messages;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OkDialog
implements IOkDialog {
    private static final int SHELL_WIDTH = 450;
    private static final int SHELL_HEIGHT = 170;
    private static final int BUTTON_WIDTH_HINT = 80;
    private static final int MARGIN_LEFT = 5;
    private static final int MARGIN_TOP = 8;
    private static final int VERTICAL_SPACING = 10;
    private static final int HORIZONT_SPACING = 15;
    private static final int BUTTONS_COMP_COL = 3;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final Shell parentShell;
    private final String title;
    private final String message;
    private final IDialogCallback<Void> callback;
    private Shell shell;
    private final int kind;

    public OkDialog(Shell parentShell, int kind, String title, String message, IDialogCallback<Void> iDialogCallback) {
        this.parentShell = parentShell;
        this.title = title;
        this.message = message;
        this.callback = iDialogCallback;
        this.kind = kind;
        this.createContents();
    }

    private void createContents() {
        this.shell = new Shell(this.parentShell, 67632);
        this.shell.setSize(450, 170);
        this.shell.setText(this.title);
        GridLayout shellLayout = new GridLayout(2, false);
        shellLayout.marginLeft = 5;
        shellLayout.marginTop = 8;
        shellLayout.verticalSpacing = 10;
        shellLayout.horizontalSpacing = 15;
        this.shell.setLayout((Layout)shellLayout);
        Label image = new Label((Composite)this.shell, 0);
        image.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        image.setImage(Display.getDefault().getSystemImage(this.kind));
        Text labelMessage = new Text((Composite)this.shell, 840);
        labelMessage.setText(this.message);
        labelMessage.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite((Composite)this.shell, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite paddingComposite = new Composite(buttonsComposite, 0);
        GridData paddCompGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        paddCompGridData.heightHint = 0;
        paddingComposite.setLayoutData((Object)paddCompGridData);
        Button btnOk = new Button(buttonsComposite, 0);
        GridData button1GridData = new GridData(16384, 1024, false, false, 1, 1);
        button1GridData.widthHint = 80;
        btnOk.setLayoutData((Object)button1GridData);
        btnOk.setText(Messages.OK);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OkDialog.this.commit();
            }
        });
        btnOk.setFocus();
    }

    public void open() {
        this.shell.layout();
        if (this.parentShell != null) {
            Rectangle parentShellBounds = this.parentShell.getBounds();
            Point shellSize = this.shell.getSize();
            this.shell.setLocation(parentShellBounds.x + (parentShellBounds.width - shellSize.x) / 2, parentShellBounds.y + (parentShellBounds.height - shellSize.y) / 2);
        }
        this.shell.open();
    }

    @Override
    public final void commit() {
        if (this.shell.isDisposed()) {
            throw new UnsupportedOperationException("Dialog is disposed");
        }
        this.shell.dispose();
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.callback != null) {
            this.callback.committed(null);
        }
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }

    public void addCloseListener(Runnable paramRunnable) {
        this.listeners.add(paramRunnable);
    }

    public Shell getShell() {
        return this.shell;
    }

    @Override
    public boolean isInformation() {
        return this.kind == 2;
    }

    @Override
    public boolean isWarning() {
        return this.kind == 8;
    }

    @Override
    public boolean isError() {
        return this.kind == 1;
    }
}

