/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ResourceApiTypeRoot
extends AbstractApiTypeRoot {
    private IFile fFile;
    byte[] fContents = null;
    private long modifiedTimeStamp = -1L;

    public ResourceApiTypeRoot(IApiElement parent, IFile file, String typeName) {
        super(parent, typeName);
        this.fFile = file;
    }

    @Override
    public byte[] getContents() throws CoreException {
        if (this.fContents != null && this.fFile.getModificationStamp() == this.modifiedTimeStamp && this.modifiedTimeStamp != -1L) {
            return this.fContents;
        }
        this.modifiedTimeStamp = this.fFile.getModificationStamp();
        InputStream stream = this.fFile.getContents(true);
        try {
            byte[] byArray = this.fContents = Util.getInputStreamAsByteArray(stream, -1);
            return byArray;
        }
        catch (IOException ioe) {
            this.abort("Unable to read class file: " + this.getTypeName(), ioe);
            return null;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
        }
    }

    @Override
    public String getTypeName() {
        return this.getName();
    }

    public String toString() {
        return this.getTypeName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiTypeRoot) {
            IApiTypeRoot file = (IApiTypeRoot)obj;
            return this.getName().equals(file.getTypeName());
        }
        return super.equals(obj);
    }
}

