/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Dispatch;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.Visitor;

public class MethodInvocation
extends Dispatch {
    private FunctionInvocation method;
    public static final ChildPropertyDescriptor DISPATCHER_PROPERTY = new ChildPropertyDescriptor(MethodInvocation.class, "dispatcher", VariableBase.class, true, true);
    public static final ChildPropertyDescriptor METHOD_PROPERTY = new ChildPropertyDescriptor(MethodInvocation.class, "method", FunctionInvocation.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(2);
        propertyList.add(METHOD_PROPERTY);
        propertyList.add(DISPATCHER_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    ChildPropertyDescriptor getDispatcherProperty() {
        return DISPATCHER_PROPERTY;
    }

    public MethodInvocation(AST ast) {
        super(ast);
    }

    public MethodInvocation(int start, int end, AST ast, VariableBase dispatcher, FunctionInvocation method) {
        super(start, end, ast, dispatcher);
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.setMethod(method);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getDispatcher().accept(visitor);
        this.method.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getDispatcher().accept(visitor);
        this.method.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getDispatcher().traverseBottomUp(visitor);
        this.method.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<MethodInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Dispatcher>\n");
        this.getDispatcher().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Dispatcher>\n");
        buffer.append("\t").append(tab).append("<Property>\n");
        this.method.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Property>\n");
        buffer.append(tab).append("</MethodInvocation>");
    }

    @Override
    public int getType() {
        return 43;
    }

    public FunctionInvocation getMethod() {
        return this.method;
    }

    @Override
    public FunctionInvocation getMember() {
        return this.getMethod();
    }

    public void setMethod(FunctionInvocation method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        FunctionInvocation oldChild = this.method;
        this.preReplaceChild(oldChild, method, METHOD_PROPERTY);
        this.method = method;
        this.postReplaceChild(oldChild, method, METHOD_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == METHOD_PROPERTY) {
            if (get) {
                return this.getMethod();
            }
            this.setMethod((FunctionInvocation)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        VariableBase dispatcher = ASTNode.copySubtree(target, this.getDispatcher());
        FunctionInvocation field = ASTNode.copySubtree(target, this.getMethod());
        MethodInvocation result = new MethodInvocation(this.getStart(), this.getEnd(), target, dispatcher, field);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IMethodBinding resolveConstructorBinding() {
        return this.ast.getBindingResolver().resolveConstructor(this);
    }

    public IMethodBinding resolveMethodBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }
}

