/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ITrackedNodePosition;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewrite;
import org.eclipse.php.internal.core.ast.rewrite.IndentManipulation;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.internal.ui.editor.contentassist.PHPOverrideCompletionProposal;
import org.eclipse.php.internal.ui.preferences.PHPPreferencesSettings;
import org.eclipse.php.internal.ui.text.correction.ASTResolving;
import org.eclipse.php.ui.util.CodeGenerationUtils;

public final class MethodOverrideCompletionProposal
extends PHPOverrideCompletionProposal {
    protected IScriptProject fScriptProject;
    protected String fMethodName;

    public MethodOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule cu, String methodName, String[] paramTypes, int start, int length, StyledString displayName, String completionProposal) {
        super(scriptProject, cu, methodName, paramTypes, start, length, displayName, completionProposal);
        this.fScriptProject = scriptProject;
        this.fMethodName = methodName;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset) throws CoreException, BadLocationException {
        Document recovered = new Document(document.get());
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(recovered.getChar(index))) {
            --index;
        }
        int length = offset - index - 1;
        recovered.replace(index + 1, length, " ");
        Program program = this.getAST(index, (IDocument)recovered);
        ASTNode node = NodeFinder.perform((ASTNode)program.getRoot(), (int)index, (int)1);
        node = ASTResolving.findParentType(node);
        ImportRewrite importRewrite = ImportRewrite.create((Program)program, (boolean)true);
        ImportRewrite.ImportRewriteContext context = new ImportRewrite.ImportRewriteContext(){

            public int findInContext(NamespaceDeclaration namespace, String qualifier, String name, int kind) {
                return 3;
            }
        };
        ITypeBinding declaringType = null;
        Block descriptor = null;
        if (node instanceof AnonymousClassDeclaration) {
            declaringType = ((AnonymousClassDeclaration)node).resolveTypeBinding();
            descriptor = ((AnonymousClassDeclaration)node).getBody();
        } else if (node instanceof TypeDeclaration) {
            declaringType = ((TypeDeclaration)node).resolveTypeBinding();
            descriptor = ((TypeDeclaration)node).getBody();
        }
        if (declaringType != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)program.getAST());
            IMethodBinding methodToOverride = Bindings.findMethodInHierarchy((ITypeBinding)declaringType, (String)this.fMethodName);
            if (methodToOverride != null) {
                CodeGenerationSettings settings = PHPPreferencesSettings.getCodeGenerationSettings(this.fScriptProject.getProject());
                settings.createComments = true;
                MethodDeclaration stub = CodeGenerationUtils.createImplementationStub(program, rewrite, methodToOverride, declaringType.getName(), settings, declaringType.isInterface());
                ListRewrite rewriter = rewrite.getListRewrite((ASTNode)descriptor, Block.STATEMENTS_PROPERTY);
                rewriter.insertFirst((ASTNode)stub, null);
                ITrackedNodePosition position = rewrite.track((ASTNode)stub);
                rewrite.rewriteAST((IDocument)recovered, null).apply((IDocument)recovered);
                String generatedCode = recovered.get(position.getStartPosition(), position.getLength());
                int generatedIndent = IndentManipulation.measureIndentUnits((CharSequence)this.getIndentAt((IDocument)recovered, position.getStartPosition(), settings), (int)settings.tabWidth, (int)settings.indentWidth);
                String indent = this.getIndentAt(document, this.getReplacementOffset(), settings);
                this.setReplacementString(IndentManipulation.changeIndent((String)generatedCode, (int)generatedIndent, (int)settings.tabWidth, (int)settings.indentWidth, (String)indent, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document)));
                int replacementLength = this.getReplacementLength();
                if (document.get(this.getReplacementOffset() + replacementLength, 1).equals(")")) {
                    this.setReplacementLength(replacementLength + 1);
                }
            }
        }
        return true;
    }

    private String getIndentAt(IDocument document, int offset, CodeGenerationSettings settings) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            return IndentManipulation.extractIndentString((String)document.get(region.getOffset(), region.getLength()), (int)settings.tabWidth, (int)settings.indentWidth);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private Program getAST(int offset, IDocument recovered) throws ModelException, BadLocationException {
        return CodeGenerationUtils.getASTRoot(this.fSourceModule, recovered, this.fScriptProject.getProject());
    }

    @Override
    public boolean isAutoInsertable() {
        return false;
    }

    @Override
    protected boolean insertCompletion() {
        return false;
    }

    @Override
    public IContextInformation getContextInformation() {
        return null;
    }
}

